/**
 * This class is used to construct message errors
 * 
 * @author I054742
 *
 */
public class Error {

	
	static void numberOfEntries (EntrySet esCTT, EntrySet esSystem) {
		
		String msg = Globals.indent()+"ERROR: The total number of expected entries is not the same as the one returned by the connector\n";
		msg+=Globals.indent()+"--Number of expected entries: "+esCTT.getNumbOfEntries()+"\n";
		msg+=Globals.indent()+"--Number of entries given by the connector: "+esSystem.getNumbOfEntries();
		Globals.errorMessage = msg;
		Loggin.Log(Globals.errorMessage);
	}
	
	
	static void diffEntries (Entry entCTT, Entry entSystem) {
		
		String msg = Globals.indent()+"ERROR: The next two entries were expected to be equal but they are not (automatic attributes and attributes with no definition must not be taken into account):\n";
		msg+=Globals.indent()+"Expected one: DN:\""+entCTT.getDn()+"\" Attributes: "+entCTT.printAttributes()+"\n";
		msg+=Globals.indent()+"Connector's one: DN:\""+entSystem.getDn()+"\" Attributes: "+entSystem.printAttributes();
		Globals.errorMessage = msg;
		Loggin.Log(Globals.errorMessage);
	}
	
	
	static void diffAttributes (MyAttribute attCTT, MyAttribute attSystem) {
		
		String msg = Globals.indent()+"ERROR: The next two attributes were expected to be equal but they are not:\n";
		msg+=Globals.indent()+"Expected one: Name:\""+attCTT.getName()+"\" value: "+attCTT.getValues()+"\n";
		msg+=Globals.indent()+"Connector's one: Name:\""+attSystem.getName()+"\" value: "+attSystem.getValues();
		Globals.errorMessage = msg;
		Loggin.Log(Globals.errorMessage);
	}
	
	
	static void entryNOTFound(String dn, boolean notFound) {
		
		String msg = Globals.indent()+"ERROR: The entry with DN: \""+dn+"\" was expected to"+(notFound?"":" not")+" be found";
		Globals.errorMessage = msg;
		Loggin.Log(Globals.errorMessage);
	}
	
	
	static void missedMandAttribute (String dn, String attName) {

		Globals.errorMessage = Globals.indent()+"ERROR: The entry with DN: \""+dn+"\" has not the mandatory attribute \""+attName+"\"";
		Loggin.Log(Globals.errorMessage);
	}
	
	
	static void illegalAttValue (String dn, String attName, String val) {
		
		Globals.errorMessage = Globals.indent()+"ERROR: The value \""+val+"\" of the attribute: \""+attName+"\" of the entry with DN: \""+dn+"\" is illegal according to the specifications of the configuration files";
		Loggin.Log(Globals.errorMessage);
	}
	
	
	static void internalUnexpected () {
		
		Globals.errorMessage = Globals.indent()+"ERROR: Internal unexpected error";
		Loggin.Log(Globals.errorMessage);
	}
	
	
	static void internalUnexpected (String dn) {
		
		Loggin.Log(Globals.indent()+"WARNING: Some internal error occurred. The process will be stopped in order to avoid errors in chain");
		Globals.errorMessage="ERROR: Error from VDS or entry: \""+dn+"\" not found while modifying";
	}
}
