
/**
 * Main class
 * 
 * @author I054742
 *
 */
public class Certification {

	/* Indicates if the log info will be displayed on the standard output */
	static final boolean OUTPUT_INFO = true;
	/* Indicates if the debugging info will be displayed on the standard output */
	static final boolean DEBUGGING_INFO = false;
	/* This attribute will say to the pre-processing extension class */
	static final String DELETE_JDNIKEY = "deleteDnIdKeyJNDIpoelkmngkjujnejkqyyejjsj2375h".toLowerCase();
	
	
	/**
	 * Main method
	 * @param args
	 */
	static public void main (String[] args) {
		
		try {
			Loggin.init();
			Loggin.Log(Globals.indent()+"Starting Connector Testing Tool...");
			Globals.incIndent();
			
			/* Read the needed configuration files */
			if (Configurations.readFiles()==false) return;
			/* Checks if it is necessary to read the IntructionsAndExpecteds file */
			if (GeneralConfiguration.getTestType().equalsIgnoreCase(Tester.EXPECTEDS)) InstructionsAndExpectedsFile.readFile();
			/* Checks if the there is inconsistencies between the configuration files */
			else if (Configurations.checking()==false) return;
			/* Tries connecting with VDS */
			if (Preprocessing.connect()==false) return;
			/* Checks the initial state against the specifications of the configuration files for every testing process except for expected */
			if (GeneralConfiguration.getTestType().equalsIgnoreCase(Tester.EXPECTEDS)==false && Preprocessing.initialChecking()==false) return;
			/* Executes the testing process */
			Tester.execute();
			/* Writes the final report */
			Tester.report();
		}
		catch (Exception exc) {
			if (Certification.DEBUGGING_INFO) Loggin.Log(Globals.indent()+"Exception: \""+exc.getMessage()+"\" in Certification.main");
			Loggin.Log("");
			Loggin.Log(Globals.indent()+"ERROR: Some error occurred while Connector Testing Tool execution");
			if (DEBUGGING_INFO) Loggin.Log("Exception: "+exc.getMessage());
		}
		finally {
			Globals.decIndent();
			Loggin.Log("");
			Loggin.Log(Globals.indent()+"Connector Testing Tool finished its execution");
		}
	}
}
