package com.sap.idm.vds.connector.samplefile.impl;

import java.io.*;
import java.util.*;
import java.util.regex.*;

/**
 * Class to filter results
 * @author I054742
 *
 */
public class FileFilter implements FilenameFilter {
	
	/**
	 * Constructor
	 */
    public FileFilter () {
    }
    
    
    /**
     * Checks if the name of a file matches with the regular expression given by 'filter'
     * @param file -> The file where the name will be taken from
     * @param filter -> Regular expression
     * @return -> Returns true if the file name matches with the regular expression given in 'filter' 
     */
    public boolean accept(File file, String filter) {
    	
        return this.stringFilter(filter, file.getName());
    }
    
    
    /**
     * Checks if there is some attribute which name and value match with the regular expression given in 'filter'
     * @param attrList -> List of attributes (names and values)
     * @param filter -> Regular expression
     * @return -> Returns true if there is some attribute which 
     * 			  name and value match with the regular expression given in 'filter'
     */
    public boolean accept (HashMap attrList, String filter) {
    	
    	Vector vNames = new Vector();
    	Vector vValues = new Vector();
    	
    	for (Iterator it=attrList.keySet().iterator(); it.hasNext(); ) {
    		String name = (String)it.next();
    		String value = (String)attrList.get(name);
    		vNames.add(name);
    		vValues.add(value);
    	}
    	
    	String names[] = new String[vNames.size()];
    	String values[] = new String[vValues.size()];
    	
    	for (int i=0; i<vNames.size(); i++) {
    		names[i] = (String)vNames.elementAt(i);
    		values[i] = (String)vValues.elementAt(i);
    	}
    	
    	return new AcceptFilter().accept(filter,names,values);
    }
    
    
    /**
     * Checks if the string 'str' matches with the regular expression 'filter'
     * @param str -> The string to be checked against the regular expression 'filter'
     * @param filter -> The regular expression
     * @return -> True if 'str' matches with the regular expression 'filter',
     * 			  false otherwise
     */
    private boolean stringFilter (String str, String filter) {
    	
    	/* Compile a pattern to be replaced in the filter */
    	Pattern pattern = Pattern.compile("\\*");
    	/* Replace in filter all the occurrences of '*' by '.*' in order to prepare 
    	 * the correct syntax for the matching of the string against the regular expression */
    	filter=pattern.matcher(filter).replaceAll(".*");
    	/* Checks if the string matches with the regular expression */
    	return Pattern.matches(filter,str);
    }
}
