/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.ie.op;

import com.sap.idm.vds.ie.op.common.util.MVDMic_Util;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.naming.ldap.InitialLdapContext;

public class vdsStop {
    public static void usage() {
        System.err.println("Usage: java MVDStop <Path to .rnd>");
        System.exit(1);
    }

    public static void main(String[] args) {
        try {
            File rndFile;
            String rndStr;
            if (args.length != 1) {
                vdsStop.usage();
            }
            if (!(rndStr = args[0]).endsWith(".rnd")) {
                vdsStop.usage();
            }
            if (!(rndFile = new File(rndStr)).exists()) {
                throw new Exception(rndStr + " does not exist");
            }
            rndStr = rndFile.getName();
            System.out.println(rndStr);
            String configbase = rndStr.substring(0, rndStr.length() - 4);
            vdsStop.sendKillCommand(rndFile, configbase);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void sendKillCommand(File aRndFile, String aConfigbase) {
        boolean isrunning;
        boolean bl = isrunning = aRndFile.exists() && aRndFile.lastModified() > System.currentTimeMillis() - 30000L;
        if (!isrunning) {
            return;
        }
        String rndContents = vdsStop.readFileContents(aRndFile);
        if (rndContents != null) {
            String tmpStr;
            String randomnum = "";
            String serverport = "";
            String reloadsource = "";
            String securitoption = "";
            String truststorefile = "";
            String truststorepass = "";
            StringTokenizer st = new StringTokenizer(rndContents, ",");
            if (st.countTokens() >= 4) {
                randomnum = st.nextToken();
                serverport = st.nextToken();
                tmpStr = st.nextToken();
                if (tmpStr.equalsIgnoreCase("file")) {
                    reloadsource = "file";
                } else if (tmpStr.equalsIgnoreCase("db")) {
                    reloadsource = "db";
                } else if (tmpStr.equalsIgnoreCase("mic")) {
                    reloadsource = "mic";
                } else if (tmpStr.equalsIgnoreCase("http")) {
                    reloadsource = "http";
                }
                securitoption = st.nextToken();
                int ix = securitoption.indexOf(58);
                String temp = securitoption.substring(ix + 1);
                securitoption = securitoption.substring(0, ix);
                temp = MVDMic_Util.dcString(temp);
                Vector v = MVDMic_Util.splitString(temp, "$$");
                if (v.size() == 2) {
                    truststorefile = (String)v.elementAt(0);
                    truststorepass = MVDMic_Util.dcString((String)v.elementAt(1));
                }
            } else if (st.countTokens() >= 3) {
                randomnum = st.nextToken();
                serverport = st.nextToken();
                tmpStr = st.nextToken();
                if (tmpStr.equalsIgnoreCase("file")) {
                    reloadsource = "file";
                } else if (tmpStr.equalsIgnoreCase("db")) {
                    reloadsource = "db";
                } else if (tmpStr.equalsIgnoreCase("mic")) {
                    reloadsource = "mic";
                } else if (tmpStr.equalsIgnoreCase("http")) {
                    reloadsource = "http";
                }
                securitoption = null;
            } else if (st.countTokens() == 2) {
                randomnum = st.nextToken();
                serverport = st.nextToken();
                reloadsource = "file";
                securitoption = null;
            } else {
                return;
            }
            String dn = "o=" + randomnum + ",c=" + aConfigbase;
            try {
                Hashtable<String, String> env = new Hashtable<String, String>(5, 0.75f);
                env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
                env.put("java.naming.security.authentication", "simple");
                env.put("java.naming.provider.url", "ldap://" + serverport);
                env.put("java.naming.security.principal", randomnum);
                env.put("java.naming.security.credentials", randomnum);
                if (securitoption != null) {
                    env.put("java.naming.security.protocol", securitoption);
                    System.setProperty("javax.net.ssl.trustStore", truststorefile);
                    if (!truststorepass.equals("-NOT_NEEDED-")) {
                        System.setProperty("javax.net.ssl.trustStorePassword", truststorepass);
                        System.setProperty("javax.net.ssl.keyStore", truststorefile);
                        System.setProperty("javax.net.ssl.keyStorePassword", truststorepass);
                    }
                }
                InitialLdapContext ctx = new InitialLdapContext(env, null);
                ctx.destroySubcontext(dn);
                ctx.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public static String readFileContents(File f) {
        try {
            BufferedReader reader = new BufferedReader(new FileReader(f));
            String s = reader.readLine();
            String contents = "";
            while (s != null) {
                if (!contents.equals("")) {
                    contents = contents + System.getProperty("line.separator", "\n");
                }
                contents = contents + s;
                s = reader.readLine();
            }
            reader.close();
            return contents;
        }
        catch (Exception e) {
            return "";
        }
    }
}

