/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.ie.op.http;

import com.sap.idm.vds.ie.op.common.AbstractReader;
import com.sap.idm.vds.ie.op.common.Config;
import com.sap.idm.vds.ie.op.common.MVDIELogger;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;

public class vdsReadHTTP
extends AbstractReader {
    private long mLastChangeNumber = -1L;
    private URL mUrl = null;

    public void usage() {
        System.out.println("-----------------------------------------------------------------------------------------");
        System.out.println("USAGE:");
        System.out.println("  ReadHTTP  -version");
        System.out.println("     or");
        System.out.println("  ReadHTTP options OPER=<get|compile|start>");
        System.out.println("        (See 'options' below)");
        System.out.println("  options:");
        System.out.println("        [JDKHOME=<Path to Java SDK>]");
        System.out.println("        HTTPURL=<URL of XML file to be read>");
        System.out.println("        OUTPUTCONFIG=<Full path pf XML file to be created>");
        System.out.println("        [LOGLEVEL=<Log level: None=3, Error=2, Normal=1, Debug=0>]");
        System.out.println("----------------------------------------------------------------------------------------");
    }

    public void fetchSpecificProperties(Properties defaultProps) {
        try {
            if (this.mUrl == null) {
                String field = "HTTPURL";
                String tmpStr = defaultProps.getProperty(field, "");
                if ((tmpStr = tmpStr.trim()) == null || tmpStr.length() == 0) {
                    MVDIELogger.Log("Missing field:" + field + " in the property file", 2);
                }
                this.mUrl = new URL(tmpStr);
            }
        }
        catch (Exception e) {
            MVDIELogger.Log("Error reading specific properties :" + e.toString(), 2);
        }
    }

    public void sanitySpecificCheck() {
        String field = "HTTPURL";
        String tmpStr = this.mUrl.toString();
        if (tmpStr == null || tmpStr.length() == 0) {
            MVDIELogger.Log("Missing field:" + field, 2);
        }
    }

    public void load(boolean firstload) throws Exception {
        try {
            if (firstload) {
                URLConnection urlconn = this.mUrl.openConnection();
                this.mLastChangeNumber = urlconn.getHeaderFieldDate("Last-Modified", System.currentTimeMillis());
                this.Read(new Config(this.mUrl));
            } else {
                URLConnection urlconn = this.mUrl.openConnection();
                long urlmodified = urlconn.getHeaderFieldDate("Last-Modified", this.mLastChangeNumber);
                if (this.mLastChangeNumber < urlmodified) {
                    this.Read(new Config(this.mUrl));
                    this.mLastChangeNumber = urlmodified;
                }
            }
        }
        catch (Exception e) {
            MVDIELogger.Log("Error while importing configuration: " + e.getMessage(), 2);
        }
    }

    public void execute(String[] args, boolean aDoExitOnFatalError) throws Exception {
        String commandArgument = "";
        String commandKey = "";
        if (args.length == 0) {
            this.usage();
            throw new Exception("Invalid arguments");
        }
        if (args.length > 0 && args[0].equalsIgnoreCase("-version")) {
            this.printVersion(true);
            return;
        }
        this.printVersion(true);
        for (int x = 0; x < args.length; ++x) {
            commandArgument = args[x];
            int iHelp = commandArgument.indexOf("=");
            if (iHelp < 0) continue;
            commandKey = commandArgument.substring(0, iHelp);
            if ((commandKey = commandKey.toUpperCase()).equalsIgnoreCase("OUTPUTCONFIG")) {
                this.mXmlConfigFileName = commandArgument.substring(iHelp + 1);
                continue;
            }
            if (commandKey.equalsIgnoreCase("HTTPURL")) {
                this.mUrl = new URL(commandArgument.substring(iHelp + 1));
                continue;
            }
            if (commandKey.equalsIgnoreCase("OPER")) {
                this.setOperType(commandArgument.substring(iHelp + 1));
                continue;
            }
            if (commandKey.equalsIgnoreCase("JDKHOME")) {
                this.setJdkHome(commandArgument.substring(iHelp + 1));
                continue;
            }
            if (commandKey.equalsIgnoreCase("LOGLEVEL")) {
                MVDIELogger.setLevel(Integer.parseInt(commandArgument.substring(iHelp + 1)));
                continue;
            }
            this.usage();
            MVDIELogger.Log("Missing delimiter on command line", 2);
        }
        this.sanityCheck();
        try {
            this.load(true);
        }
        catch (Exception e) {
            MVDIELogger.Log("Error while importing configuration:" + this.mXmlConfigFileName + ":" + e.toString(), 2);
        }
    }

    public static void main(String[] args) throws Exception {
        vdsReadHTTP rhttp = new vdsReadHTTP();
        rhttp.execute(args, true);
        System.exit(0);
    }
}

