/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.ie.op.common.util;

import com.sap.idm.vds.ie.op.common.MVDIELogger;
import com.sap.idm.vds.ie.op.common.util.Base64;
import com.sap.idm.vds.ie.op.common.util.CompileUtil;
import com.sap.idm.vds.ie.op.common.util.JDBCShimDriver;
import com.sap.idm.vds.ie.op.common.util.Util;
import com.sap.idm.vds.ie.op.common.util.XMLUtil;
import com.sap.idm.vds.ie.op.db.DBConfig;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class DBUtil {
    public static Connection initConnection(String aURL, String aDriver) throws Exception {
        Connection aConnection = null;
        MVDIELogger.Log("Creating connection to dabatase", 1);
        DBUtil.loadDriverDynamiccaly(aDriver);
        try {
            aConnection = DBUtil.getConnection(aURL, aDriver);
        }
        catch (Exception e) {
            throw new Exception("Could not create connection to the database: " + e);
        }
        try {
            aConnection.setAutoCommit(false);
            aConnection.setTransactionIsolation(2);
        }
        catch (Exception e) {
            throw new Exception("Could not set auto commit on database to false: " + e);
        }
        String aDBUser = aConnection.getMetaData().getUserName();
        MVDIELogger.Log("User is " + aDBUser, 1);
        return aConnection;
    }

    private static Connection getConnection(String aURL, String aDriver) throws SQLException {
        int cutoff = aURL.indexOf("!!!");
        if (cutoff > 0) {
            String propstring = aURL.substring(cutoff + 3);
            Properties props = new Properties();
            StringTokenizer stringtokenizer = new StringTokenizer(propstring, ";", false);
            while (stringtokenizer.hasMoreElements()) {
                String value;
                String name;
                String oneprop = stringtokenizer.nextToken();
                int ix = oneprop.indexOf(61);
                if (ix >= 0) {
                    name = oneprop.substring(0, ix);
                    value = oneprop.substring(ix + 1);
                } else {
                    name = oneprop;
                    value = " ";
                }
                props.setProperty(name, value);
            }
            aURL = aURL.substring(0, cutoff);
            if (aDriver.indexOf("com.microsoft.jdbc.sqlserver.SQLServerDriver") >= 0) {
                aURL = aURL + ";SelectMethod=Cursor";
            }
            return DriverManager.getConnection(aURL, props);
        }
        if (aDriver.indexOf("com.microsoft.jdbc.sqlserver.SQLServerDriver") >= 0) {
            aURL = aURL + ";SelectMethod=Cursor";
        }
        return DriverManager.getConnection(aURL);
    }

    public static void closeConnection(Connection aConn, boolean aOK) throws Exception {
        try {
            if (aConn == null) {
                return;
            }
            DBUtil.commit(aConn, aOK);
            aConn.close();
            aConn = null;
        }
        catch (Exception e) {
            throw new Exception(e.toString());
        }
    }

    private static void commit(Connection aConn, boolean aOK) {
        try {
            if (aConn == null) {
                return;
            }
            if (aOK) {
                aConn.commit();
            } else {
                aConn.rollback();
            }
        }
        catch (Exception e) {
            MVDIELogger.Log("Could not set commit database: " + e.getMessage(), 2);
        }
    }

    private static void loadDriverDynamiccaly(String aDriver) throws Exception {
        try {
            Vector paths = Util.splitString(CompileUtil.getClassPath(), ";");
            URL[] urls = new URL[paths.size()];
            for (int i = 0; i < paths.size(); ++i) {
                try {
                    urls[i] = new URL("file:" + (String)paths.get(i));
                    MVDIELogger.Log("Saved url " + urls[i], 1);
                    continue;
                }
                catch (Exception e) {
                    MVDIELogger.Log("Exception adding URL to classpath: " + (String)paths.get(i) + ":" + e, 2);
                }
            }
            URLClassLoader mJDBCClassLoader = new URLClassLoader(urls);
            JDBCShimDriver.registerDriver(aDriver, mJDBCClassLoader, System.err);
        }
        catch (Exception e) {
            MVDIELogger.Log("Could not load driver " + aDriver + ":" + e, 2);
            throw new Exception(e);
        }
        catch (Throwable te) {
            MVDIELogger.Log("Could not load driver " + aDriver + ":" + te, 2);
            throw new Exception(te);
        }
    }

    public static DBConfig getConfigurationByConfigGUID(Connection aConn, String aConfigGUID, String aVersion) throws Exception {
        String sql = null;
        sql = aVersion.equalsIgnoreCase("0") ? "SELECT mx_configuration,mxversion FROM mx_configurations where CONFIGGUID ='" + aConfigGUID + "'" : "SELECT mx_configuration,mxversion FROM mx_configuration_history where CONFIGGUID ='" + aConfigGUID + "' and MXVersion=" + aVersion;
        DBConfig dc = DBUtil.getConfiguration(aConn, sql);
        if (dc.getPlainDoc() == null) {
            throw new Exception("Geting long data from table failed");
        }
        String result = dc.getPlainDoc().substring("{BASE64}".length());
        byte[] decoded = Base64.decode(result);
        result = new String(decoded);
        MVDIELogger.Log("The fetched configuration:\n" + result, 1);
        dc.setDoc(XMLUtil.transformStringToDOM(result));
        return dc;
    }

    public static DBConfig getConfigurationByConfigName(Connection aConn, String aConfigName, String aVersion) throws Exception {
        String sql = null;
        sql = aVersion.equalsIgnoreCase("0") ? "SELECT mx_configuration,mxversion  FROM mx_configurations where configname='" + aConfigName + "'" : "SELECT mx_configuration,mxversion FROM mx_configuration_history where configname='" + aConfigName + "' and MXVersion=" + aVersion;
        DBConfig dc = DBUtil.getConfiguration(aConn, sql);
        if (dc.getPlainDoc() == null) {
            throw new Exception("Geting long data from table failed");
        }
        String result = dc.getPlainDoc().substring("{BASE64}".length());
        byte[] decoded = Base64.decode(result);
        result = new String(decoded);
        MVDIELogger.Log("The fetched configuration:\n" + result, 0);
        dc.setDoc(XMLUtil.transformStringToDOM(result));
        return dc;
    }

    public static String getConfigurationVersion(Connection aConn, String aConfigName) throws Exception {
        String sql = null;
        sql = "SELECT mxversion  FROM mx_configurations where configname='" + aConfigName + "'";
        DBConfig dc = DBUtil.getConfiguration(aConn, sql);
        return dc.getVersion();
    }

    private static DBConfig getConfiguration(Connection aConn, String sql) throws Exception {
        String result = null;
        DBConfig dc = new DBConfig();
        try {
            Statement statement = aConn.createStatement();
            ResultSet rs = statement.executeQuery(sql);
            if (rs.next()) {
                ResultSetMetaData metadata = rs.getMetaData();
                for (int ix = 1; ix <= metadata.getColumnCount(); ++ix) {
                    if (metadata.getColumnName(ix).equalsIgnoreCase("mx_configuration")) {
                        if (metadata.getColumnType(ix) == 2005) {
                            Clob clob = rs.getClob(ix);
                            Long l = new Long(clob.length());
                            result = clob.getSubString(1L, l.intValue());
                        } else {
                            byte[] bb = null;
                            if (metadata.getColumnType(ix) == 2004) {
                                Blob blob = rs.getBlob(1);
                                Long l = new Long(blob.length());
                                bb = blob.getBytes(1L, l.intValue());
                            } else {
                                try {
                                    result = rs.getString(ix);
                                }
                                catch (Exception e) {
                                    result = null;
                                }
                            }
                        }
                        dc.setPlainDoc(result);
                        continue;
                    }
                    if (!metadata.getColumnName(ix).equalsIgnoreCase("mxversion")) continue;
                    result = rs.getString(ix);
                    dc.setVersion(result);
                }
            }
            try {
                rs.close();
                statement.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            return dc;
        }
        catch (SQLException se) {
            DBUtil.closeConnection(aConn, false);
            throw se;
        }
    }
}

