/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.ie.op.common.util;

import com.sap.idm.vds.ie.op.common.AbstractReader;
import com.sap.idm.vds.ie.op.common.MVDIELogger;
import com.sap.idm.vds.ie.op.common.util.MVDMic_Util;
import com.sap.idm.vds.ie.op.common.util.StreamGobler;
import com.sap.idm.vds.ie.op.common.util.Util;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class CompileUtil {
    private static URLClassLoader ucl = null;
    private static boolean bCompileUsingJDK = false;
    private static boolean bCompileUsingTools = false;
    private static String mClassPath = "";
    static /* synthetic */ Class class$com$sap$idm$vds$ie$op$http$vdsReadHTTP;

    public static String getClassPath() {
        return mClassPath;
    }

    public static void compile(String classfile, String script, AbstractReader absread) throws Exception {
        try {
            File path = new File(absread.getXmlConfigFileName()).getParentFile();
            File savedfile = Util.saveFile(classfile, script, path);
            if (savedfile == null) {
                MVDIELogger.Log("Script is NOT compiled - could not save file to:" + savedfile.getName(), 1);
                return;
            }
            if (bCompileUsingJDK) {
                MVDIELogger.Log("Compiling script " + classfile, 1);
                CompileUtil.compileJavac(savedfile, path);
                return;
            }
            if (bCompileUsingTools) {
                try {
                    MVDIELogger.Log("Compiling script " + classfile, 1);
                    CompileUtil.compileReflect(savedfile, path);
                }
                catch (Exception e) {
                    boolean ix = true;
                }
                return;
            }
            MVDIELogger.Log("Script is NOT compiled:" + classfile, 1);
            return;
        }
        catch (Exception e) {
            MVDIELogger.Log("Exception when compiling script " + classfile, 2);
            e.printStackTrace();
            return;
        }
    }

    public static void compileReflect(File javafile, File topath) throws Exception {
        try {
            Class<?> main = Class.forName("com.sun.tools.javac.Main", false, ucl);
            Object o = main.newInstance();
            Method methods = main.getMethod("compile", new String[0].getClass());
            methods.invoke(o, new Object[]{new String[]{"-classpath", mClassPath, javafile.getAbsolutePath()}});
            MVDIELogger.Log("OK", 1);
        }
        catch (Exception e) {
            MVDIELogger.Log("Compiling failed", 1);
            MVDIELogger.Log("Unable to compile class: " + javafile.getAbsolutePath(), 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void compileJavac(File javafile, File topath) {
        StreamGobler outputGobler = null;
        StreamGobler errorGobler = null;
        try {
            block4: {
                try {
                    String javac = CompileUtil.getJavacExecutableName();
                    MVDIELogger.Log("javac:" + javac, 1);
                    Runtime rt = Runtime.getRuntime();
                    String[] str = new String[]{javac, "-classpath", mClassPath, javafile.getAbsolutePath()};
                    Process p = rt.exec(str);
                    outputGobler = new StreamGobler(p.getInputStream());
                    errorGobler = new StreamGobler(p.getErrorStream());
                    errorGobler.start();
                    outputGobler.start();
                    int ret = p.waitFor();
                    if (ret == 0) break block4;
                    MVDIELogger.Log("Unable to compile class: " + javafile.getAbsolutePath(), 2);
                }
                catch (Exception e) {
                    MVDIELogger.Log("Unable to compile class: " + javafile.getAbsolutePath() + "/" + e.getMessage(), 2);
                    Object var10_11 = null;
                    System.out.println(outputGobler.getStreamContents(false));
                    System.out.println(errorGobler.getStreamContents(false));
                }
            }
            Object var10_10 = null;
            System.out.println(outputGobler.getStreamContents(false));
            System.out.println(errorGobler.getStreamContents(false));
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            System.out.println(outputGobler.getStreamContents(false));
            System.out.println(errorGobler.getStreamContents(false));
            throw throwable;
        }
    }

    public static boolean isCompileEnabled() {
        if (bCompileUsingJDK) {
            return true;
        }
        if (bCompileUsingTools) {
            try {
                if (ucl == null) {
                    MVDIELogger.Log("Missing Class Loader", 2);
                    return false;
                }
                Class.forName("com.sun.tools.javac.Main", false, ucl);
                return true;
            }
            catch (Exception e) {
                MVDIELogger.Log("A proper tools.jar must be in classpath:" + e.getMessage(), 2);
            }
        }
        return false;
    }

    public static String getJavacExecutableName() {
        String os = System.getProperty("os.name").toLowerCase();
        boolean dosBased = os.indexOf("windows") >= 0 || os.indexOf("os/2") >= 0;
        String extension = dosBased ? ".exe" : "";
        String aJdkHome = AbstractReader.getJdkHome();
        File jExecutable = new File(aJdkHome + (aJdkHome.endsWith(File.separator) ? "" : File.separator) + "bin" + File.separator + "javac" + extension);
        if (jExecutable.exists() || !jExecutable.isFile()) {
            return jExecutable.getAbsolutePath();
        }
        System.err.println("Could not find javac executable.  java.home is:" + aJdkHome);
        return "javac";
    }

    public static String resolveJarFileClasspath(Vector jarFiles) {
        LinkedList<JarFile> ll = new LinkedList<JarFile>();
        HashSet<String> s = new HashSet<String>();
        ArrayList<String> allJars = new ArrayList<String>();
        for (int i = 0; i < jarFiles.size(); ++i) {
            try {
                String jarfile = (String)jarFiles.elementAt(i);
                if (!jarfile.endsWith(".jar")) continue;
                File ff = new File(jarfile);
                if (ff.exists()) {
                    ll.addLast(new JarFile(jarfile));
                    s.add(ff.getAbsolutePath());
                    continue;
                }
                System.err.println(jarfile + " Not found");
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        while (ll.size() > 0) {
            try {
                Attributes attrs;
                String str;
                JarFile jf = (JarFile)ll.removeFirst();
                File f = new File(jf.getName());
                File path = f.getParentFile();
                Manifest mf = jf.getManifest();
                if (mf == null || (str = (attrs = mf.getMainAttributes()).getValue("Class-path")) == null) continue;
                Vector v = MVDMic_Util.splitString(str, ' ');
                Iterator iter = v.iterator();
                while (iter.hasNext()) {
                    String newjarabspath;
                    File newjarfile;
                    String element = (String)iter.next();
                    if (!element.endsWith(".jar") || !(newjarfile = new File(path, element)).exists() || s.contains(newjarabspath = newjarfile.getAbsolutePath())) continue;
                    JarFile jrf = new JarFile(newjarfile);
                    ll.addLast(jrf);
                    s.add(newjarabspath);
                    allJars.add(newjarabspath);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        String completePath = "";
        Iterator iter = allJars.iterator();
        while (iter.hasNext()) {
            if (!completePath.equals("")) {
                completePath = completePath + File.pathSeparator;
            }
            String aPath = (String)iter.next();
            completePath = completePath + aPath;
        }
        return completePath;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        mClassPath = System.getProperty("java.class.path");
        Vector classpathentries = MVDMic_Util.splitString(mClassPath, File.pathSeparatorChar);
        mClassPath = mClassPath + File.pathSeparator + CompileUtil.resolveJarFileClasspath(classpathentries);
        System.out.println("Full (expanded) classpath =" + mClassPath);
        String aJdkHome = AbstractReader.getJdkHome();
        if (aJdkHome != null && !aJdkHome.equals("")) {
            bCompileUsingJDK = true;
            MVDIELogger.Log("JDK_HOME=" + aJdkHome, 1);
        }
        String JDK_VERSION = System.getProperties().getProperty("java.specification.version");
        String toolsUrl = "";
        String findThis = "com/sap/idm/vds/ie/op/http/vdsReadHTTP.class";
        ClassLoader r = (class$com$sap$idm$vds$ie$op$http$vdsReadHTTP == null ? (class$com$sap$idm$vds$ie$op$http$vdsReadHTTP = CompileUtil.class$("com.sap.idm.vds.ie.op.http.vdsReadHTTP")) : class$com$sap$idm$vds$ie$op$http$vdsReadHTTP).getClassLoader();
        URL readhttpurl = r.getResource(findThis);
        String xxx = readhttpurl.getFile();
        String proto = readhttpurl.getProtocol();
        MVDIELogger.Log("PROTOCOL:FILE=" + proto + ":" + xxx, 1);
        String libpath = "";
        if (proto.equalsIgnoreCase("jar")) {
            try {
                JarURLConnection juc = (JarURLConnection)readhttpurl.openConnection();
                URL jarFile = juc.getJarFileURL();
                libpath = jarFile.getPath();
                int ix = libpath.lastIndexOf("/");
                libpath = libpath.substring(0, ix);
                libpath = libpath + "/jdk";
                MVDIELogger.Log("LIBPATH=" + libpath, 1);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        } else {
            int ix = readhttpurl.getFile().indexOf(findThis);
            libpath = readhttpurl.getFile().substring(0, ix);
            if (libpath.toLowerCase().endsWith("server/bin/")) {
                libpath = libpath.substring(0, libpath.length() - "server/bin/".length());
                libpath = libpath + "lib/jdk";
            } else {
                libpath = libpath + "jdk";
            }
        }
        if (JDK_VERSION != null) {
            toolsUrl = "file://" + libpath + JDK_VERSION + "/tools.jar";
        }
        MVDIELogger.Log("TOOLSURL=" + toolsUrl, 1);
        if (toolsUrl.length() > 0) {
            try {
                URL u = new URL(toolsUrl);
                URL[] toolsclasspath = new URL[]{u};
                ucl = URLClassLoader.newInstance(toolsclasspath);
                if (ucl != null) {
                    MVDIELogger.Log("Class loader succesfully created", 1);
                    bCompileUsingTools = true;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }
}

