/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.ie.op.common;

import com.sap.idm.vds.ie.op.common.AbstractReader;
import com.sap.idm.vds.ie.op.common.util.Base64;
import com.sap.idm.vds.ie.op.common.util.CompileUtil;
import java.util.HashMap;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Method {
    private static Vector mMethods = new Vector();

    public static void init(Document doc) throws Exception {
        String strVal = "";
        mMethods.clear();
        NodeList nl = doc.getElementsByTagName("Scripts");
        Node node = nl.item(0);
        if (node != null) {
            nl = ((Element)node).getElementsByTagName("Record");
            for (int i = 0; i < nl.getLength(); ++i) {
                HashMap<String, String> tmpMethodProperties = new HashMap<String, String>();
                Node methodNode = nl.item(i);
                if (methodNode != null && methodNode.hasChildNodes()) {
                    NodeList nodeList = methodNode.getChildNodes();
                    for (int x = 0; x < nodeList.getLength(); ++x) {
                        node = nodeList.item(x);
                        if (!node.hasChildNodes()) continue;
                        String nodeStr = node.getNodeName();
                        strVal = node.getFirstChild().getNodeValue();
                        tmpMethodProperties.put(nodeStr, strVal);
                    }
                }
                mMethods.add(tmpMethodProperties);
            }
        }
    }

    public static void compileMethods(AbstractReader absreader) throws Exception {
        try {
            Vector vc = mMethods;
            for (int i = 0; i < vc.size(); ++i) {
                HashMap hMap = (HashMap)vc.elementAt(i);
                String methodID = (String)hMap.get("ID");
                Method.compileMethods(methodID, hMap, absreader);
            }
        }
        catch (Exception e) {
            throw new Exception("Could not compile Methods: " + e.getMessage());
        }
    }

    private static void compileMethods(String methodID, HashMap hMap, AbstractReader absreader) throws Exception {
        try {
            int oid = Integer.parseInt(methodID);
            String classfile = (String)hMap.get("Name");
            String script = (String)hMap.get("Script");
            if (script.substring(0, 5).equalsIgnoreCase("{B64}")) {
                String sTemp = script.substring(5);
                byte[] bTemp = Base64.decode(sTemp);
                script = new String(bTemp);
            }
            if (classfile == null) {
                throw new Exception("Unable to find classname");
            }
            if (script == null) {
                throw new Exception("Unable to find script");
            }
            CompileUtil.compile(classfile, script, absreader);
        }
        catch (Exception de) {
            throw new Exception("Could not compile Script - " + methodID + " : " + de.getMessage());
        }
    }
}

