/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.connector.samplefile.impl;

import com.sap.idm.vds.filter.MVDFilter;
import com.sap.idm.vds.filter.MVDFilterComplex;
import com.sap.idm.vds.filter.MVDFilterSimple;
import com.sap.idm.vds.filter.MVDFilterUtilities;
import java.util.Vector;

public class FilterTransformer {
    private String toMyFormatFilter(String filter) {
        MVDFilter mFilter = MVDFilterUtilities.constructFilter((String)filter);
        return this.toMyFormatFilter(mFilter);
    }

    private String toMyFormatFilter(MVDFilter aMVDFilter) {
        if (aMVDFilter instanceof MVDFilterSimple) {
            return this.toMyFormatFilter((MVDFilterSimple)aMVDFilter);
        }
        return this.toMyFormatFilter((MVDFilterComplex)aMVDFilter);
    }

    private String toMyFormatFilter(MVDFilterSimple aMVDFilter) {
        String opstr = "";
        String value = null;
        String mAttrname = aMVDFilter.getAttrName();
        String mAttrvalue = aMVDFilter.getAttrValue();
        int mOptype = aMVDFilter.getOpType();
        if (mAttrname == null) {
            mAttrname = "*";
        }
        if (mAttrname.equals("MVD_CLEANED")) {
            return null;
        }
        if (mAttrname.equals("MVD_IGNORED")) {
            return "(*=*)";
        }
        value = mAttrvalue == null ? "*" : mAttrvalue;
        if (mOptype == 0 || mOptype == 1000) {
            opstr = "=";
        } else if (mOptype == 2) {
            opstr = ">";
        } else if (mOptype == 3) {
            opstr = "=";
        } else if (mOptype == 1) {
            opstr = "<";
        } else if (mOptype == 4) {
            opstr = "=";
        }
        return "(" + mAttrname + opstr + value + ")";
    }

    private String toMyFormatFilter(MVDFilterComplex aMVDFilter) {
        String tmp = "";
        int mFilterOpType = aMVDFilter.getFilterOpType();
        Vector mFilters = aMVDFilter.getFilters();
        MVDFilter mOne = (MVDFilter)mFilters.elementAt(0);
        if (mOne != null) {
            if (mFilterOpType == 13) {
                if (mOne instanceof MVDFilterComplex) {
                    String aux = this.toMyFormatFilter((MVDFilterComplex)mOne);
                    if (aux == null) {
                        return null;
                    }
                    tmp = "(NOT " + aux + ")";
                } else {
                    String aux = this.toMyFormatFilter((MVDFilterSimple)mOne);
                    if (aux == null) {
                        return null;
                    }
                    tmp = "(NOT " + aux + ")";
                }
                return tmp;
            }
            if (mFilters.size() > 1) {
                if (mFilterOpType == 11) {
                    tmp = "(";
                    int x = 0;
                    while (x < mFilters.size()) {
                        String aux;
                        if (x > 0) {
                            tmp = String.valueOf(tmp) + " AND ";
                        }
                        if (mFilters.elementAt(x) instanceof MVDFilterComplex) {
                            aux = this.toMyFormatFilter((MVDFilterComplex)mFilters.elementAt(x));
                            if (aux == null) {
                                return null;
                            }
                            tmp = String.valueOf(tmp) + aux;
                        } else {
                            aux = this.toMyFormatFilter((MVDFilterSimple)mFilters.elementAt(x));
                            if (aux == null) {
                                return null;
                            }
                            tmp = String.valueOf(tmp) + aux;
                        }
                        ++x;
                    }
                    return String.valueOf(tmp) + ")";
                }
                if (mFilterOpType == 12) {
                    tmp = "(";
                    int x = 0;
                    while (x < mFilters.size()) {
                        String aux;
                        if (x > 0) {
                            tmp = String.valueOf(tmp) + " OR ";
                        }
                        if (mFilters.elementAt(x) instanceof MVDFilterComplex) {
                            aux = this.toMyFormatFilter((MVDFilterComplex)mFilters.elementAt(x));
                            if (aux == null) {
                                return null;
                            }
                            tmp = String.valueOf(tmp) + aux;
                        } else {
                            aux = this.toMyFormatFilter((MVDFilterSimple)mFilters.elementAt(x));
                            if (aux == null) {
                                return null;
                            }
                            tmp = String.valueOf(tmp) + aux;
                        }
                        ++x;
                    }
                    return String.valueOf(tmp) + ")";
                }
            } else {
                return null;
            }
        }
        return null;
    }

    public static void main(String[] args) {
        FilterTransformer ft = new FilterTransformer();
        String[] filters = new String[]{"(a=1)", "(&(a=1)(b=2)(|(c=3)(d=4)(!(e=5))))", "(!(&(a=1)(b=2)))", "(|(&(a=1)(b=2))(c=3))", "(&(a=1))", "(|((a=1)(b=2)))", "()", "(|)", "(|()())", "(|(&(|(!(a=1))(b=2))(c=3))(d=4))", "(|(&(|(!(a=1))(b=2))(c=3)))"};
        int i = 0;
        while (i < filters.length) {
            String res = ft.toMyFormatFilter(filters[i]);
            if (res == null) {
                res = "null";
            }
            System.out.println(String.valueOf(filters[i]) + " -> " + res);
            ++i;
        }
    }
}

