/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.util.mic;

import com.sap.idm.vds.MVDLogger;
import com.sap.idm.vds.MVDUtil;
import com.sap.idm.vds.util.HidedIDStoreOperations;
import com.sap.idm.vds.util.mic.OracleBlobHandler;
import com.sap.idm.vds.util.mic.StoredProcedure;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Vector;

public class MICUtilities {
    HidedIDStoreOperations mHidID = null;

    public void initMicUtil(HidedIDStoreOperations hid) throws Exception {
        this.mHidID = hid;
    }

    public CallableStatement initStoredProcedure(int opType) throws Exception {
        try {
            StoredProcedure p = HidedIDStoreOperations.getStoredProcedures()[opType];
            int limit = 0;
            String temps = "";
            limit = HidedIDStoreOperations.getLikeSolid() ? p.GetInParams() : p.GetInParams() + p.GetOutParams();
            for (int x = 0; x < limit; ++x) {
                if (temps.length() > 0) {
                    temps = temps + ", ";
                }
                temps = temps + "?";
            }
            CallableStatement sss = this.mHidID.idstoreconnection().prepareCall("{call " + p.GetProcedureName() + "(" + temps + ")}");
            return sss;
        }
        catch (Exception e) {
            throw new Exception("Could not initialize initStoredProcedure - exception:" + e.toString());
        }
    }

    public String Get_IS_Error(int aErrCode) throws Exception {
        CallableStatement lcs = null;
        String errStr = "IS_ERROR (" + Integer.toString(aErrCode) + ")";
        try {
            lcs = this.initStoredProcedure(3);
            lcs.setInt(1, aErrCode);
            if (!HidedIDStoreOperations.getLikeSolid()) {
                lcs.registerOutParameter(2, 12);
                lcs.execute();
                errStr = lcs.getString(2);
            } else {
                lcs.execute();
                ResultSet rs = lcs.getResultSet();
                rs.next();
                errStr = rs.getString("ERRSTR");
                rs.close();
            }
            if (lcs != null) {
                lcs.close();
            }
            return errStr;
        }
        catch (Exception e) {
            if (lcs != null) {
                lcs.close();
            }
            throw new Exception("Could not carry out Get_IS_Error - exception:" + e.toString());
        }
    }

    public String Create_IS_Entry(int StoreID, String entryName) throws Exception {
        CallableStatement lcs = null;
        String result = "";
        try {
            int errCode;
            int msKey;
            lcs = this.initStoredProcedure(0);
            lcs.setInt(1, StoreID);
            lcs.setString(2, entryName);
            if (!HidedIDStoreOperations.getLikeSolid()) {
                lcs.registerOutParameter(3, 4);
                lcs.registerOutParameter(4, 4);
                lcs.execute();
                msKey = lcs.getInt(3);
                errCode = lcs.getInt(4);
            } else {
                lcs.execute();
                ResultSet rs = lcs.getResultSet();
                rs.next();
                msKey = rs.getInt("MSKEY");
                errCode = rs.getInt("ERR");
                rs.close();
            }
            if (lcs != null) {
                lcs.close();
            }
            result = errCode != 0 ? "ERROR:" + this.Get_IS_Error(errCode) : "" + msKey;
            return result;
        }
        catch (Exception e) {
            if (lcs != null) {
                lcs.close();
            }
            throw new Exception("Could not carry out Create_IS_Entry - exception:" + e.toString());
        }
    }

    public String Delete_IS_Entry(int StoreID, String entryName) throws Exception {
        CallableStatement lcs = null;
        String result = "";
        try {
            int errCode;
            int msKey;
            lcs = this.initStoredProcedure(7);
            lcs.setInt(1, StoreID);
            lcs.setString(2, entryName);
            if (!HidedIDStoreOperations.getLikeSolid()) {
                lcs.registerOutParameter(3, 4);
                lcs.registerOutParameter(4, 4);
                lcs.execute();
                msKey = lcs.getInt(3);
                errCode = lcs.getInt(4);
            } else {
                lcs.execute();
                ResultSet rs = lcs.getResultSet();
                rs.next();
                msKey = rs.getInt("MSKEY");
                errCode = rs.getInt("ERR");
                rs.close();
            }
            if (lcs != null) {
                lcs.close();
            }
            result = errCode != 0 ? "ERROR:" + this.Get_IS_Error(errCode) : "" + msKey;
            return result;
        }
        catch (Exception e) {
            if (lcs != null) {
                lcs.close();
            }
            throw new Exception("Could not carry out Delete_IS_Entry - exception:" + e.toString());
        }
    }

    public String Get_IS_EntryID(int StoreID, String entryName) throws Exception {
        CallableStatement lcs = null;
        String result = "";
        try {
            int errCode;
            int msKey;
            lcs = this.initStoredProcedure(1);
            lcs.setInt(1, StoreID);
            lcs.setString(2, entryName);
            if (!HidedIDStoreOperations.getLikeSolid()) {
                lcs.registerOutParameter(3, 4);
                lcs.registerOutParameter(4, 4);
                lcs.execute();
                msKey = lcs.getInt(3);
                errCode = lcs.getInt(4);
            } else {
                lcs.execute();
                ResultSet rs = lcs.getResultSet();
                rs.next();
                msKey = rs.getInt("MSKEY");
                errCode = rs.getInt("ERR");
                rs.close();
            }
            if (lcs != null) {
                lcs.close();
            }
            result = errCode != 0 ? "ERROR:" + this.Get_IS_Error(errCode) : "" + msKey;
            return result;
        }
        catch (Exception e) {
            if (lcs != null) {
                lcs.close();
            }
            throw new Exception("Could not carry out Get_IS_EntryID - exception:" + e.toString());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HashMap List_IS_Attribute(int mskey, int pidStore, String entryType, int searchMode, String searchFilter, int szLimit) throws Exception {
        CallableStatement lcs = null;
        int dbtype = Integer.parseInt(HidedIDStoreOperations.getDBInfo());
        HashMap result = new HashMap();
        try {
            try {
                switch (dbtype) {
                    default: {
                        lcs = this.initStoredProcedure(14);
                        lcs.setInt(1, mskey);
                        lcs.setInt(2, pidStore);
                        lcs.setString(3, entryType);
                        lcs.setInt(4, searchMode);
                        lcs.setString(5, searchFilter);
                        lcs.setInt(6, szLimit);
                        break;
                    }
                    case 2: {
                        lcs = this.initStoredProcedure(13);
                        lcs.setInt(1, mskey);
                        lcs.setInt(2, pidStore);
                        lcs.setString(3, entryType);
                        lcs.setInt(4, searchMode);
                        lcs.setString(5, searchFilter);
                        lcs.setInt(6, szLimit);
                        lcs.registerOutParameter(7, -10);
                    }
                }
                lcs.execute();
                ResultSet rset = null;
                do {
                    switch (dbtype) {
                        default: {
                            rset = lcs.getResultSet();
                            break;
                        }
                        case 2: {
                            rset = (ResultSet)lcs.getObject(7);
                        }
                    }
                    while (rset.next()) {
                        Vector<String> entry = new Vector<String>();
                        mskey = rset.getInt(1);
                        entry.add(rset.getString(2));
                        entry.add(rset.getString(3));
                        entry.add(rset.getString(4));
                        result.put(new Integer(mskey), entry);
                    }
                } while (lcs.getMoreResults());
            }
            catch (Exception e) {
                throw new Exception("Could not carry out List_IS_Attribute - exception:" + e.toString(), e);
            }
            Object var13_13 = null;
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            try {
                if (lcs == null) throw throwable;
                lcs.close();
                throw throwable;
            }
            catch (SQLException sqle) {
                throw new Exception("Could not carry out List_IS_Attribute - exception:" + sqle.toString(), sqle);
            }
        }
        try {}
        catch (SQLException sqle) {
            throw new Exception("Could not carry out List_IS_Attribute - exception:" + sqle.toString(), sqle);
        }
        if (lcs == null) return result;
        lcs.close();
        return result;
    }

    public String Set_IS_Attribute(int mskey, int StoreID, String attrName, int modType, String attrValue) throws Exception {
        String result = "";
        Statement lcs = null;
        boolean bLargeValueMode = false;
        String strMD5Value = "";
        String valueTobeAdded = "";
        if (attrValue == null) {
            attrValue = "--NULL--";
        }
        if (attrValue.length() > HidedIDStoreOperations.getLargeAttributeLength()) {
            bLargeValueMode = true;
            valueTobeAdded = strMD5Value = HidedIDStoreOperations.getLargeAttributePrefix() + MVDUtil.computeMD5(attrValue) + " SIZE=" + Integer.toString(attrValue.length()) + ">";
        } else {
            valueTobeAdded = attrValue;
        }
        try {
            int errCode;
            int attrid;
            int dbtype = Integer.parseInt(HidedIDStoreOperations.getDBInfo());
            lcs = dbtype == 2 ? this.initStoredProcedure(12) : this.initStoredProcedure(9);
            lcs.setInt(1, mskey);
            lcs.setInt(2, StoreID);
            lcs.setString(3, attrName);
            lcs.setString(4, valueTobeAdded);
            lcs.setString(5, "");
            lcs.setInt(6, 0);
            lcs.setInt(7, modType);
            if (!HidedIDStoreOperations.getLikeSolid()) {
                lcs.registerOutParameter(8, 4);
                lcs.registerOutParameter(9, 4);
                lcs.registerOutParameter(10, 4);
                lcs.registerOutParameter(11, 4);
                lcs.execute();
                int presedence = lcs.getInt(8);
                attrid = lcs.getInt(9);
                int audio = lcs.getInt(10);
                errCode = lcs.getInt(11);
            } else {
                lcs.execute();
                ResultSet rs = lcs.getResultSet();
                rs.next();
                int presedence = rs.getInt("PRESEDENCE");
                attrid = rs.getInt("ATTRID");
                int audio = rs.getInt("AUDIO");
                errCode = rs.getInt("ERR");
                rs.close();
            }
            if (lcs != null) {
                lcs.close();
            }
            if (errCode != -1 && errCode == 0 && bLargeValueMode) {
                errCode = this.setLargeAttributeValue(mskey, attrid, strMD5Value, attrValue);
            }
            result = "" + errCode;
            return result;
        }
        catch (Exception e) {
            if (lcs != null) {
                lcs.close();
            }
            throw new Exception("Could not carry out Set_IS_Attribute - exception:" + e.toString());
        }
    }

    public String ValidateOp(int mskey, int pModify) throws Exception {
        CallableStatement lcs = null;
        String result = "";
        try {
            int errCode;
            String descr;
            lcs = this.initStoredProcedure(8);
            lcs.setInt(1, mskey);
            lcs.setInt(2, pModify);
            if (!HidedIDStoreOperations.getLikeSolid()) {
                lcs.registerOutParameter(3, 12);
                lcs.registerOutParameter(4, 4);
                lcs.execute();
                descr = lcs.getString(3);
                errCode = lcs.getInt(4);
            } else {
                lcs.execute();
                ResultSet rs = lcs.getResultSet();
                rs.next();
                descr = rs.getString("DESCRIPTION");
                errCode = rs.getInt("ERR");
                rs.close();
            }
            if (lcs != null) {
                lcs.close();
            }
            result = errCode != 0 ? "ERROR:" + this.Get_IS_Error(errCode) + " - description:" + descr : "0";
            return result;
        }
        catch (Exception e) {
            if (lcs != null) {
                lcs.close();
            }
            throw new Exception("Could not carry out Delete_IS_Entry - exception:" + e.toString());
        }
    }

    private int setLargeAttributeValue(int aEntryID, int aAttributeId, String fullMD5Value, String aValue) {
        int dbtype = Integer.parseInt(HidedIDStoreOperations.getDBInfo());
        int errcode = 0;
        String sql = "-undefined-";
        if (dbtype == 2) {
            try {
                sql = "SELECT ALONG FROM MXI_VALUES WHERE MSKEY=" + Integer.toString(aEntryID) + " AND ATTR_ID=" + Integer.toString(aAttributeId) + " AND SEARCHVALUE = '" + fullMD5Value.toUpperCase() + "' FOR UPDATE";
                OracleBlobHandler olh = new OracleBlobHandler(this.mHidID);
                olh.updateLob(sql, aValue);
            }
            catch (IOException ioe) {
                MVDLogger.Log("setLargeAttributeValue failed adding BLOB or CLOB value to an Oracle Database. SQL:" + sql + ":" + ioe, 3);
                errcode = 99;
            }
            catch (SQLException se) {
                MVDLogger.Log("setLargeAttributeValue failed adding BLOB or CLOB value to an Oracle Database. SQL:" + sql + ":" + se, 3);
                errcode = 99;
            }
            catch (Error err) {
                MVDLogger.Log("setLargeAttributeValue failed adding BLOB or CLOB value to an Oracle Database. SQL:" + sql + ":" + err, 3);
                errcode = 99;
            }
        } else {
            sql = "UPDATE MXI_VALUES SET ALONG=? WHERE MSKEY=" + Integer.toString(aEntryID) + " AND ATTR_ID=" + Integer.toString(aAttributeId) + " AND SEARCHVALUE = '" + fullMD5Value.toUpperCase() + "'";
            try {
                PreparedStatement prep = this.mHidID.idstoreconnection().prepareStatement(sql);
                prep.clearParameters();
                StringReader ir = new StringReader(aValue);
                prep.setCharacterStream(1, (Reader)ir, aValue.length());
                prep.executeUpdate();
                prep.close();
            }
            catch (SQLException se) {
                MVDLogger.Log("setLargeAttributeValue failed", 3);
                errcode = 99;
            }
        }
        return errcode;
    }

    public boolean isMultiValueAttribute(String aAttrName, int isId) throws Exception {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            String p = this.mHidID.getQueries()[0];
            p = MVDUtil.replace(p, "$aATTRNAME$", aAttrName);
            p = MVDUtil.replace(p, "$aISID$", "" + isId);
            stmt = this.mHidID.idstoreconnection().createStatement();
            rs = stmt.executeQuery(p);
            if (!rs.next()) {
                rs.close();
                stmt.close();
                return false;
            }
            ResultSetMetaData localRsMd = rs.getMetaData();
            if (localRsMd.getColumnCount() != 1) {
                rs.close();
                stmt.close();
                localRsMd = null;
                return false;
            }
            int ismulti = 0;
            String colName = localRsMd.getColumnName(1);
            if (colName.equalsIgnoreCase("multivalue")) {
                ismulti = rs.getInt("MULTIVALUE");
            }
            rs.close();
            stmt.close();
            return ismulti == 1;
        }
        catch (Exception e) {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
            return false;
        }
    }

    public String Modify_IS_AttributeValue(int mskey, int StoreID, String attrName, int modType, Vector vValues) throws Exception {
        int attrValueIsChanged = 0;
        for (int x = 0; x < vValues.size(); ++x) {
            String ares = this.Set_IS_Attribute(mskey, StoreID, attrName, modType, (String)vValues.elementAt(x));
            int validate = Integer.parseInt(ares);
            if (validate == 0 && attrValueIsChanged != 2) {
                attrValueIsChanged = 0;
                continue;
            }
            if (validate <= 0) continue;
            attrValueIsChanged = 2;
        }
        return "" + attrValueIsChanged;
    }

    public String Add_IS_AttributeValue(int mskey, int StoreID, String attrName, HashMap hMap) throws Exception {
        Vector vValues = (Vector)hMap.get(attrName);
        return this.Modify_IS_AttributeValue(mskey, StoreID, attrName, 0, vValues);
    }

    public int GetOrCreate_Entry_ID(int IDStore, String aKey) throws Exception {
        String strMsKey = this.Get_IS_EntryID(IDStore, aKey);
        if (strMsKey.startsWith("ERROR") && (strMsKey = this.Create_IS_Entry(IDStore, aKey)).startsWith("ERROR")) {
            throw new Exception("Could not get or create" + aKey + "  node: " + strMsKey);
        }
        return Integer.parseInt(strMsKey);
    }

    public int Create_Entry_ID(int IDStore, String aKey) throws Exception {
        String strMsKey = this.Create_IS_Entry(IDStore, aKey);
        if (strMsKey.startsWith("ERROR")) {
            throw new Exception("Could not get or create" + aKey + "  node: " + strMsKey);
        }
        return Integer.parseInt(strMsKey);
    }

    public int Get_Entry_ID(int IDStore, String aKey) throws Exception {
        String strMsKey = this.Get_IS_EntryID(IDStore, aKey);
        if (strMsKey.startsWith("ERROR")) {
            throw new Exception("Could not get or create" + aKey + "  node: " + strMsKey);
        }
        return Integer.parseInt(strMsKey);
    }

    public String getLargeAttributeValue(int ISID, int aEntryId, String aAttrName, String aSearchValue) {
        String aAttrId = this.getAttrId(ISID, aAttrName);
        int aAttributeId = Integer.parseInt(aAttrId);
        String sql = "SELECT ALONG FROM MXI_VALUES WHERE MSKEY=? AND ATTR_ID=? AND SEARCHVALUE=?";
        String result = null;
        try {
            PreparedStatement prep = this.mHidID.idstoreconnection().prepareStatement(sql);
            prep.setInt(1, aEntryId);
            prep.setInt(2, aAttributeId);
            prep.setString(3, aSearchValue);
            ResultSet rs = prep.executeQuery();
            if (rs.next()) {
                ResultSetMetaData metadata = rs.getMetaData();
                if (metadata.getColumnType(1) == 2005) {
                    Clob clob = rs.getClob(1);
                    Long l = new Long(clob.length());
                    result = clob.getSubString(1L, l.intValue());
                } else {
                    byte[] bb = null;
                    if (metadata.getColumnType(1) == 2004) {
                        Blob blob = rs.getBlob(1);
                        Long l = new Long(blob.length());
                        bb = blob.getBytes(1L, l.intValue());
                    } else {
                        try {
                            result = rs.getString(1);
                        }
                        catch (Exception e) {
                            MVDLogger.Log("Exception getting long data from MXI_VALUES table: " + metadata.getColumnTypeName(1), 3);
                            result = null;
                        }
                    }
                }
            }
            rs.close();
            prep.close();
        }
        catch (SQLException se) {
            MVDLogger.Log("Exception getting long data from MXI_VALUES table: " + se, 3);
        }
        return result;
    }

    public String getAttrId(int ISID, String aAttrName) {
        String sql = "SELECT ATTR_ID FROM MXI_ATTRIBUTES where IS_ID=? AND attrname = ?";
        String result = null;
        try {
            PreparedStatement prep = this.mHidID.idstoreconnection().prepareStatement(sql);
            prep.setInt(1, ISID);
            prep.setString(2, aAttrName);
            ResultSet rs = prep.executeQuery();
            if (rs.next()) {
                try {
                    result = rs.getString(1);
                }
                catch (Exception e) {
                    result = null;
                }
            }
            rs.close();
            prep.close();
        }
        catch (SQLException se) {
            MVDLogger.Log("Exception getting attr_id for : " + aAttrName, 3);
        }
        return result;
    }
}

