/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.util;

import com.sap.idm.vds.MVDLogger;
import com.sap.idm.vds.MVDSearchResultEntry;
import com.sap.idm.vds.MVDSearchResults;
import com.sap.idm.vds.MVDUtil;
import com.sap.idm.vds.util.Base64;
import com.sap.idm.vds.util.IniFile;
import com.sap.idm.vds.util.JDBCUtil;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Vector;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;

public class PasswordUtil {
    public static boolean usePwdProvisioning(String idstore, String aDatabase, boolean bCacheConn) {
        String getPwdProvisiongQuery = "select EnablePwdProvisioning from mxi_idstores where is_id= $SCOPE$";
        getPwdProvisiongQuery = MVDUtil.replace(getPwdProvisiongQuery, "$SCOPE$", idstore);
        MVDSearchResults policyInfo = JDBCUtil.search(aDatabase, getPwdProvisiongQuery, null, bCacheConn);
        int pwdprov = 0;
        for (int i = 0; i < policyInfo.size(); ++i) {
            MVDSearchResultEntry entry = (MVDSearchResultEntry)policyInfo.get(i);
            HashMap attrAndValues = entry.getAttrAndValues();
            Vector PwdProvVector = (Vector)attrAndValues.get("enablepwdprovisioning");
            if (PwdProvVector == null) continue;
            pwdprov = Integer.parseInt((String)PwdProvVector.get(0));
        }
        return pwdprov == 1;
    }

    public static String resetPassword(String idstore, String aDatabase, boolean bCacheConn) {
        String getpolicyQuery = "select attr_id,attrname,min_len,max_len,savecopies,savedays,MixedChar,CharNumb,ConfInput,HiddenInput from mxi_attributes where is_id = $SCOPE$  and attrname='MX_PASSWORD'";
        getpolicyQuery = MVDUtil.replace(getpolicyQuery, "$SCOPE$", idstore);
        MVDSearchResults policyInfo = JDBCUtil.search(aDatabase, getpolicyQuery, null, bCacheConn);
        int minlen = 0;
        int maxlen = 0;
        int mixedchars = 0;
        int mixedLetterNumber = 0;
        for (int i = 0; i < policyInfo.size(); ++i) {
            MVDSearchResultEntry entry = (MVDSearchResultEntry)policyInfo.get(i);
            HashMap attrAndValues = entry.getAttrAndValues();
            Vector minlenVector = (Vector)attrAndValues.get("min_len");
            Vector maxlenVector = (Vector)attrAndValues.get("max_len");
            Vector mixedCharVector = (Vector)attrAndValues.get("MixedChar");
            Vector mixedLetterNumberVector = (Vector)attrAndValues.get("CharNumb");
            if (minlenVector != null) {
                minlen = Integer.parseInt((String)minlenVector.get(0));
            }
            if (maxlenVector != null) {
                maxlen = Integer.parseInt((String)maxlenVector.get(0));
            }
            if (mixedCharVector != null) {
                mixedchars = Integer.parseInt((String)mixedCharVector.get(0));
            }
            if (mixedLetterNumberVector == null) continue;
            mixedLetterNumber = Integer.parseInt((String)mixedLetterNumberVector.get(0));
        }
        return PasswordUtil.generatePassword(minlen, maxlen, mixedLetterNumber == 1, true, mixedchars == 1, false);
    }

    private static String generatePassword(int minlength, int maxlength, boolean useNumbers, boolean useLower, boolean UserUpper, boolean UseSpecialChars) {
        int i;
        int length = 0;
        SecureRandom randomGenerator = null;
        char[] numberChars = "0123456789".toCharArray();
        char[] lowerChars = "abcdefghijklmnopqrstuvwxyz".toCharArray();
        char[] upperChars = "ABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
        char[] otherSpecialChars = "`~!@#$%^&*()-_=+[{]}\\|;:'\",<.>/?".toCharArray();
        char[] allowedChars = null;
        int allowedCharlength = 0;
        if (useNumbers) {
            allowedCharlength = numberChars.length;
        }
        if (useLower) {
            allowedCharlength += lowerChars.length;
        }
        if (UserUpper) {
            allowedCharlength += upperChars.length;
        }
        if (UseSpecialChars) {
            allowedCharlength += otherSpecialChars.length;
        }
        allowedChars = new char[allowedCharlength];
        int c = 0;
        if (useNumbers) {
            i = 0;
            while (i < numberChars.length) {
                allowedChars[c] = numberChars[i];
                ++i;
                ++c;
            }
        }
        if (useLower) {
            i = 0;
            while (i < lowerChars.length) {
                allowedChars[c] = lowerChars[i];
                ++i;
                ++c;
            }
        }
        if (UserUpper) {
            i = 0;
            while (i < upperChars.length) {
                allowedChars[c] = upperChars[i];
                ++i;
                ++c;
            }
        }
        if (UseSpecialChars) {
            i = 0;
            while (i < otherSpecialChars.length) {
                allowedChars[c] = otherSpecialChars[i];
                ++i;
                ++c;
            }
        }
        if (maxlength == 0) {
            maxlength = 30;
        }
        length = minlength >= maxlength ? minlength : (int)(Math.floor(Math.random() * (double)(maxlength - minlength + 1)) + (double)minlength);
        char[] password = new char[length];
        try {
            randomGenerator = SecureRandom.getInstance("SHA1PRNG");
            byte[] byteArray = new byte[4];
            for (int i2 = 0; i2 < length; ++i2) {
                randomGenerator.nextBytes(byteArray);
                password[i2] = allowedChars[Math.abs(PasswordUtil.convertByteToInt(byteArray) % allowedChars.length)];
            }
        }
        catch (Exception nae) {
            MVDLogger.Debug("failed to generate secure password " + nae.getMessage() + " " + nae.getCause());
        }
        String pwd = new String(password);
        return pwd;
    }

    public static String md5(String password) {
        byte[] passbyte = null;
        try {
            MessageDigest md5digest = MessageDigest.getInstance("MD5");
            passbyte = md5digest.digest(password.getBytes());
        }
        catch (Exception e) {
            MVDLogger.Debug("MD5 Failed:" + e.getMessage() + " " + e.getCause());
            return "!ERROR MD5 Failed:" + e.getMessage() + " " + e.getCause();
        }
        return MVDUtil.byteToHex(passbyte).toLowerCase();
    }

    private static int convertByteToInt(byte[] bytes) {
        int returnNumber = 0;
        int pos = 0;
        returnNumber += PasswordUtil.byteToInt(bytes[pos++]) << 24;
        returnNumber += PasswordUtil.byteToInt(bytes[pos++]) << 16;
        returnNumber += PasswordUtil.byteToInt(bytes[pos++]) << 8;
        return returnNumber += PasswordUtil.byteToInt(bytes[pos++]) << 0;
    }

    private static int byteToInt(byte b) {
        return b & 0xFF;
    }

    public static String uDESEncrypt(String key, String cleartext) throws Exception {
        String result = "";
        if (MVDUtil.isEmpty(key)) {
            result = PasswordUtil.encode(cleartext, "1");
            return result;
        }
        File keys = new File(key);
        if (keys.exists()) {
            result = PasswordUtil.encryptString(cleartext, keys.getAbsolutePath());
            return result;
        }
        byte[] bKey = null;
        byte[] bClearText = null;
        if (key.startsWith("{HEX}")) {
            bKey = MVDUtil.hexToByte(key.substring(5).trim());
        } else {
            try {
                bKey = key.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException uee) {
                // empty catch block
            }
        }
        if (bKey.length != 24) {
            MVDLogger.Debug("uDESEncrypt: Key should be exactly 24 bytes long", 7);
            throw new Exception("uDESEncrypt: Key should be exactly 24 bytes long");
        }
        if (cleartext.startsWith("{HEX}")) {
            bClearText = MVDUtil.hexToByte(cleartext.substring(5).trim());
        } else {
            try {
                bClearText = cleartext.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException uee) {
                // empty catch block
            }
        }
        try {
            String algName = "DESede/ECB/PKCS5Padding";
            MVDLogger.Debug("uDESEncrypt encoding " + cleartext + " using " + algName);
            Cipher cp = Cipher.getInstance(algName);
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DESede");
            SecretKey encryptkey = keyFactory.generateSecret(new DESedeKeySpec(bKey));
            cp.init(1, encryptkey);
            byte[] bText = cp.doFinal(bClearText);
            MVDLogger.Debug("Encoded buffer:" + bText);
            result = "{HEX}" + MVDUtil.byteToHex(bText);
        }
        catch (Throwable t) {
            MVDLogger.Debug("uDESEncrypt encoding buffer" + t.getMessage() + " " + t.getCause().getMessage(), 7);
        }
        return result;
    }

    public static String encode(String aInput, String aType) {
        try {
            if (aType.equals(Integer.toString(1))) {
                String test;
                File dsehome = new File(System.getProperty("DSE_HOME", "."));
                File keys = new File(dsehome, "KEY");
                File keyfile = new File(keys, "Keys.ini");
                if (keyfile.exists() && !MVDUtil.isEmpty(test = PasswordUtil.encryptString(aInput, keyfile.getAbsolutePath()))) {
                    return test;
                }
                byte[] bTemp = aInput.getBytes();
                String algName = "DESede/ECB/PKCS5Padding";
                byte[] b = Base64.encode(algName.getBytes()).getBytes();
                Cipher cp = Cipher.getInstance(algName);
                SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DESede");
                SecretKey key = keyFactory.generateSecret(new DESedeKeySpec(b));
                cp.init(1, key);
                byte[] bText = cp.doFinal(bTemp);
                return "{DES3}" + MVDUtil.byteToHex(bText).toLowerCase();
            }
            String value = "x" + aInput;
            byte[] bTemp = value.getBytes();
            for (int i = 0; i < bTemp.length; ++i) {
                int iTmp = bTemp[i];
                iTmp = iTmp - i % 19 + 7;
                bTemp[i] = (byte)iTmp;
            }
            bTemp[0] = (byte)(value.length() % 123 + 2);
            String s = Base64.encode(bTemp, true);
            int mod = value.length() % 62;
            if (mod > 9) {
                mod += 7;
            }
            if (mod > 42) {
                mod += 6;
            }
            byte[] bb = new byte[]{(byte)(48 + mod)};
            String t = new String(bb);
            return "{CRYPT}" + s + t;
        }
        catch (Throwable t) {
            throw new UnsupportedOperationException(t.toString());
        }
    }

    public static String encryptString(String aClearText, String aKeyFile) {
        try {
            SecretKeyFactory keyFactory;
            Cipher cp;
            String algName = "DESede/ECB/PKCS5Padding";
            String rawkey = null;
            int keyix = 0;
            try {
                cp = Cipher.getInstance(algName);
                keyFactory = SecretKeyFactory.getInstance("DESede");
                IniFile aIniFile = new IniFile(aKeyFile);
                String activekey = aIniFile.getKeyValue("CURRENT", "KEY");
                if (!MVDUtil.isEmpty(activekey)) {
                    if (activekey.equalsIgnoreCase("{CRYPT}")) {
                        return PasswordUtil.encode(aClearText, "0");
                    }
                    rawkey = aIniFile.getKeyValue("KEYS", activekey).trim();
                    if (activekey.toUpperCase().startsWith("KEY")) {
                        keyix = Integer.parseInt(activekey.substring(4));
                    }
                }
            }
            catch (NoSuchAlgorithmException nsae) {
                MVDLogger.Debug("Exception initializing Triple DES" + nsae.getMessage(), 7);
                return null;
            }
            catch (Exception nspe) {
                MVDLogger.Debug("Exception initializing Triple DES" + nspe.getMessage(), 7);
                return null;
            }
            byte[] currentKey = MVDUtil.hexToByte(rawkey);
            if (keyix == 0) {
                currentKey = Base64.encode(algName.getBytes()).getBytes();
            }
            SecretKey key = keyFactory.generateSecret(new DESedeKeySpec(currentKey));
            cp.init(1, key);
            byte[] bTemp = aClearText.getBytes();
            byte[] ciphertext = cp.doFinal(bTemp);
            String prefix = "";
            if (keyix > 0) {
                prefix = Integer.toString(keyix) + ":";
            }
            return "{DES3}" + prefix + MVDUtil.byteToHex(ciphertext).toLowerCase();
        }
        catch (Throwable t) {
            MVDLogger.Debug("encryptString failed encrypting" + t.getMessage(), 7);
            return null;
        }
    }
}

