/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.util;

import com.sap.idm.vds.MVDLogger;
import com.sap.idm.vds.MVDModAttrValues;
import com.sap.idm.vds.MVDOperationResult;
import com.sap.idm.vds.MVDSearchResultEntry;
import com.sap.idm.vds.MVDSearchResults;
import com.sap.idm.vds.config.MVDProxy;
import com.sap.idm.vds.message.MxResultCodes;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;

public class OneShutJNDI {
    public static final String LDAP_ATTRIBUTES_BINARY = "java.naming.ldap.attributes.binary";
    private NamingEnumeration ne = null;
    private LdapContext mLdapContext = null;

    private void CleanUp() {
        try {
            if (this.ne != null) {
                this.ne.close();
            }
        }
        catch (NamingException e) {
            // empty catch block
        }
        try {
            if (this.mLdapContext != null) {
                this.mLdapContext.close();
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }

    public boolean TestBind(String mServer, String mPort, String mUser, String mPassword) {
        return this.TestBind(mServer, mPort, mUser, mPassword, null);
    }

    public boolean TestBind(String mServer, String mPort, String mUser, String mPassword, String aSecurityProtocol) {
        boolean bRes = false;
        try {
            this.CreateLdapContext(mServer, mPort, mUser, mPassword, aSecurityProtocol);
            bRes = true;
        }
        catch (NamingException ne) {
        }
        catch (Exception ne) {
            // empty catch block
        }
        this.CleanUp();
        return bRes;
    }

    public MVDSearchResults Search(String mServer, String mPort, String mUser, String mPassword, String startingpoint, int scope, Vector attr, String urlfilter, int szLimit, int tmLimit) {
        return this.Search(mServer, mPort, mUser, mPassword, startingpoint, scope, attr, urlfilter, szLimit, tmLimit, null);
    }

    public MVDSearchResults Search(String mServer, String mPort, String mUser, String mPassword, String startingpoint, int scope, Vector attr, String urlfilter, int szLimit, int tmLimit, String aSecurityOption) {
        MVDSearchResults result = new MVDSearchResults();
        SearchControls aConstraints = new SearchControls();
        if (attr.size() > 0) {
            String[] attrIDs = attr.toArray(new String[0]);
            aConstraints.setReturningAttributes(attrIDs);
        }
        aConstraints.setSearchScope(scope);
        aConstraints.setCountLimit(szLimit);
        aConstraints.setTimeLimit(tmLimit * 1000);
        try {
            this.CreateLdapContext(mServer, mPort, mUser, mPassword, aSecurityOption);
            this.ne = this.mLdapContext.search(startingpoint, urlfilter, aConstraints);
            result.putNamingEnumeration(this.ne, startingpoint, szLimit);
            result.setOK();
        }
        catch (NamingException e) {
            int aCode = result.PickTheNamingExceptionCode(e);
            result.setError(aCode, e.getMessage());
        }
        catch (Exception e) {
            int aCode = 1;
            result.setError(aCode, e.getMessage());
        }
        this.CleanUp();
        return result;
    }

    public MVDSearchResults searchForADObject(String mServer, String mPort, String mUser, String mPassword, String startingpoint, int scope, Vector attr, String urlfilter, int szLimit, int tmLimit) {
        MVDSearchResults result = new MVDSearchResults();
        SearchControls aConstraints = new SearchControls();
        if (attr.size() > 0) {
            String[] attrIDs = attr.toArray(new String[0]);
            aConstraints.setReturningAttributes(attrIDs);
        }
        aConstraints.setSearchScope(scope);
        aConstraints.setCountLimit(szLimit);
        aConstraints.setTimeLimit(tmLimit * 1000);
        try {
            this.CreateLdapContext(mServer, mPort, mUser, mPassword);
            String[] returnedAtts = new String[]{"*"};
            Attributes attributes = this.mLdapContext.getAttributes(startingpoint, returnedAtts);
            result.putEntryWithJNDIAttributes(attributes, startingpoint);
            result.setOK();
        }
        catch (NamingException e) {
            int aCode = result.PickTheNamingExceptionCode(e);
            result.setError(aCode, e.getMessage());
        }
        catch (Exception e) {
            int aCode = 1;
            result.setError(aCode, e.getMessage());
        }
        this.CleanUp();
        return result;
    }

    public MVDSearchResults Compare(String mServer, String mPort, String mUser, String mPassword, String startingpoint, String urlfilter) {
        MVDSearchResults result = new MVDSearchResults();
        SearchControls aConstraints = new SearchControls();
        aConstraints.setReturningAttributes(new String[0]);
        aConstraints.setSearchScope(0);
        aConstraints.setCountLimit(0L);
        aConstraints.setTimeLimit(0);
        try {
            this.CreateLdapContext(mServer, mPort, mUser, mPassword);
            this.ne = this.mLdapContext.search(startingpoint, urlfilter, aConstraints);
            result.putNamingEnumeration(this.ne, startingpoint);
            result.setOK();
        }
        catch (NamingException e) {
            int aCode = result.PickTheNamingExceptionCode(e);
            result.setError(aCode, e.getMessage());
        }
        catch (Exception e) {
            int aCode = 1;
            result.setError(aCode, e.getMessage());
        }
        this.CleanUp();
        return result;
    }

    public MVDOperationResult Modify(String mServer, String mPort, String mUser, String mPassword, String startingpoint, Vector attrNamesAndModValues) {
        MVDOperationResult result = new MVDOperationResult();
        try {
            this.CreateLdapContext(mServer, mPort, mUser, mPassword);
            BasicAttributes bas = new BasicAttributes();
            BasicAttribute baOne = null;
            String attrName = "";
            Vector<ModificationItem> modifications = new Vector<ModificationItem>();
            int ls = attrNamesAndModValues.size();
            for (int i = 0; i < ls; ++i) {
                boolean isBin = false;
                MVDModAttrValues oneMvdMod = (MVDModAttrValues)attrNamesAndModValues.elementAt(i);
                attrName = oneMvdMod.getAttrName();
                isBin = MVDProxy.IsBinaryAttribute(attrName);
                baOne = new BasicAttribute(attrName);
                int t = oneMvdMod.size();
                for (int x = 0; x < t; ++x) {
                    String oneStringValue;
                    byte[] oneByteValue = (byte[])oneMvdMod.elementAt(x);
                    if (isBin) {
                        baOne.add(oneByteValue);
                        continue;
                    }
                    try {
                        oneStringValue = new String(oneByteValue, "UTF-8");
                    }
                    catch (Exception e) {
                        oneStringValue = new String(oneByteValue);
                    }
                    baOne.add(oneStringValue);
                }
                int aType = oneMvdMod.getModType();
                if (aType == 0) {
                    aType = 1;
                } else if (aType == 1) {
                    aType = 3;
                }
                ModificationItem mi = new ModificationItem(aType, baOne);
                modifications.add(mi);
            }
            int ix = 0;
            ModificationItem[] m = new ModificationItem[modifications.size()];
            Iterator it = modifications.iterator();
            while (it.hasNext()) {
                m[ix++] = (ModificationItem)it.next();
            }
            this.mLdapContext.modifyAttributes(startingpoint, m);
            result.setOK();
        }
        catch (NamingException ne) {
            int aCode = result.PickTheNamingExceptionCode(ne);
            result.setError(aCode, ne.getMessage());
        }
        catch (Exception ne) {
            int aCode = 1;
            result.setError(aCode, ne.getMessage());
        }
        this.CleanUp();
        return result;
    }

    public MVDOperationResult SetADPassword(String aServer, String aPort, String adminUser, String adminPassword, String username, String oldPassword, String newPassword) {
        MVDOperationResult result = new MVDOperationResult();
        Hashtable<String, String> env = new Hashtable<String, String>(5, 0.75f);
        env.put("java.naming.ldap.version", "3");
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.security.protocol", "ssl");
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.provider.url", "ldap://" + aServer + ":" + aPort);
        env.put("java.naming.security.principal", adminUser);
        env.put("java.naming.security.credentials", adminPassword);
        try {
            ModificationItem[] mods;
            InitialDirContext ctx = new InitialDirContext(env);
            if (oldPassword == null || oldPassword.length() == 0) {
                mods = new ModificationItem[1];
                BasicAttribute newPwdAttr = new BasicAttribute("unicodePwd", OneShutJNDI.encodePassword(newPassword));
                mods[0] = new ModificationItem(2, newPwdAttr);
            } else {
                mods = new ModificationItem[2];
                BasicAttribute oldPwdAttr = new BasicAttribute("unicodePwd", OneShutJNDI.encodePassword(oldPassword));
                BasicAttribute newPwdAttr = new BasicAttribute("unicodePwd", OneShutJNDI.encodePassword(newPassword));
                mods[0] = new ModificationItem(3, oldPwdAttr);
                mods[1] = new ModificationItem(1, newPwdAttr);
            }
            ctx.modifyAttributes(username, mods);
            result.setOK();
        }
        catch (NamingException ne) {
            int aCode = result.PickTheNamingExceptionCode(ne);
            result.setError(aCode, ne.getMessage());
        }
        catch (Exception ne) {
            int aCode = 1;
            result.setError(aCode, ne.getMessage());
        }
        return result;
    }

    private static byte[] encodePassword(String pass) throws UnsupportedEncodingException {
        System.out.println(pass);
        String ATT_ENCODING = "Unicode";
        String pwd = "\"" + pass + "\"";
        byte[] _bytes = pwd.getBytes("Unicode");
        byte[] bytes = new byte[_bytes.length - 2];
        System.arraycopy(_bytes, 2, bytes, 0, _bytes.length - 2);
        if (!System.getProperty("os.arch").equals("x86")) {
            for (int i = 0; i < bytes.length; i += 2) {
                byte temp = bytes[i];
                bytes[i] = bytes[i + 1];
                bytes[i + 1] = temp;
            }
        }
        return bytes;
    }

    public MVDOperationResult Add(String mServer, String mPort, String mUser, String mPassword, String startingpoint, HashMap attrNamesAndValues) {
        MVDOperationResult result = new MVDOperationResult();
        try {
            this.CreateLdapContext(mServer, mPort, mUser, mPassword);
            BasicAttributes bas = new BasicAttributes();
            BasicAttribute baOne = null;
            String attrName = "";
            Vector attrValue = null;
            Iterator ii = attrNamesAndValues.keySet().iterator();
            while (ii.hasNext()) {
                boolean isBin = false;
                attrName = (String)ii.next();
                isBin = MVDProxy.IsBinaryAttribute(attrName);
                attrValue = (Vector)attrNamesAndValues.get(attrName);
                baOne = new BasicAttribute(attrName);
                int t = attrValue.size();
                for (int x = 0; x < t; ++x) {
                    String oneStringValue;
                    byte[] oneByteValue = (byte[])attrValue.elementAt(x);
                    if (isBin) {
                        baOne.add(oneByteValue);
                        continue;
                    }
                    try {
                        oneStringValue = new String(oneByteValue, "UTF-8");
                    }
                    catch (Exception e) {
                        oneStringValue = new String(oneByteValue);
                    }
                    baOne.add(oneStringValue);
                }
                bas.put(baOne);
            }
            this.mLdapContext.createSubcontext(startingpoint, (Attributes)bas);
            result.setOK();
        }
        catch (NamingException ne) {
            int aCode = result.PickTheNamingExceptionCode(ne);
            result.setError(aCode, ne.getMessage());
        }
        catch (Exception ne) {
            int aCode = 1;
            result.setError(aCode, ne.getMessage());
        }
        this.CleanUp();
        return result;
    }

    public MVDOperationResult Delete(String mServer, String mPort, String mUser, String mPassword, String startingpoint) {
        MVDOperationResult result = new MVDOperationResult();
        try {
            this.CreateLdapContext(mServer, mPort, mUser, mPassword);
            this.mLdapContext.destroySubcontext(startingpoint);
            result.setOK();
        }
        catch (NamingException ne) {
            int aCode = result.PickTheNamingExceptionCode(ne);
            result.setError(aCode, ne.getMessage());
        }
        catch (Exception ne) {
            int aCode = 1;
            result.setError(aCode, ne.getMessage());
        }
        this.CleanUp();
        return result;
    }

    public String Lookup(String mServer, String mPort, String mUser, String mPassword, String startingpoint, int scope, String attrName, String urlfilter, int returnType, String aSecurityOption) {
        return this.doLookup(mServer, mPort, mUser, mPassword, startingpoint, scope, attrName, urlfilter, returnType, aSecurityOption, false);
    }

    public String LookupFailover(String mServer, String mPort, String mUser, String mPassword, String startingpoint, int scope, String attrName, String urlfilter, int returnType, String aSecurityOption) {
        return this.doLookup(mServer, mPort, mUser, mPassword, startingpoint, scope, attrName, urlfilter, returnType, aSecurityOption, true);
    }

    private String doLookup(String mServer, String mPort, String mUser, String mPassword, String startingpoint, int scope, String attrName, String urlfilter, int returnType, String aSecurityOption, boolean aFlagUnavailable) {
        Vector<String> attr = new Vector<String>();
        if (!attrName.equalsIgnoreCase("dn")) {
            attr.add(attrName);
        }
        MVDLogger.Log("Lookup properties: " + mServer + ":" + mPort + " - " + mUser + "/" + mPassword + " - " + scope + "-" + urlfilter, 2);
        MVDSearchResults result = this.Search(mServer, mPort, mUser, mPassword, startingpoint, scope, attr, urlfilter, 2, 30, aSecurityOption);
        if (!result.isOK()) {
            int code;
            MVDLogger.Log("Lookup result: " + result.getCode() + ":" + result.getMessage(), 2);
            if (aFlagUnavailable && MxResultCodes.isUnavailable(code = result.getCode())) {
                return "-FAILOVER-";
            }
            return null;
        }
        if (result.size() != 1) {
            MVDLogger.Log("Lookup - too many results: " + result.size(), 2);
            return null;
        }
        MVDSearchResultEntry entry = (MVDSearchResultEntry)result.elementAt(0);
        if (attrName.equalsIgnoreCase("dn")) {
            return entry.getDn();
        }
        if (returnType == 1) {
            return entry.getFirstAttrValue(attrName);
        }
        Vector vvv = entry.getAttrValues(attrName);
        if (vvv != null) {
            return vvv.toString();
        }
        return "";
    }

    private void CreateLdapContext(String mServer, String mPort, String mUser, String mPassword) throws Exception {
        this.CreateLdapContext(mServer, mPort, mUser, mPassword, null);
    }

    private void CreateLdapContext(String mServer, String mPort, String mUser, String mPassword, String aSecurityProtocol) throws Exception {
        Hashtable<String, String> env = new Hashtable<String, String>(5, 0.75f);
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.provider.url", "ldap://" + mServer + ":" + mPort);
        env.put("java.naming.security.principal", mUser);
        env.put("java.naming.security.credentials", mPassword);
        if (aSecurityProtocol != null) {
            env.put("java.naming.security.protocol", aSecurityProtocol);
            if (aSecurityProtocol.equalsIgnoreCase("ssl")) {
                env.put("java.naming.ldap.factory.socket", "com.sap.idm.vds.util.MxJNDISocketFactory");
            }
        }
        env.put(LDAP_ATTRIBUTES_BINARY, MVDProxy.JNDIBinaryAttr());
        this.mLdapContext = new InitialLdapContext(env, null);
    }
}

