/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.util;

import com.sap.idm.vds.MVDLogger;
import com.sap.idm.vds.MVDUtil;
import com.sap.idm.vds.filter.MVDFilter;
import com.sap.idm.vds.filter.MVDFilterComplex;
import com.sap.idm.vds.filter.MVDFilterSimple;
import com.sap.idm.vds.filter.MVDFilterSubstring;
import com.sap.idm.vds.util.Base64;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import org.openspml.v2.msg.XMLMarshaller;
import org.openspml.v2.msg.spml.Request;
import org.openspml.v2.msg.spml.Response;
import org.openspml.v2.profiles.DSMLProfileRegistrar;
import org.openspml.v2.profiles.dsml.And;
import org.openspml.v2.profiles.dsml.ApproxMatch;
import org.openspml.v2.profiles.dsml.DSMLValue;
import org.openspml.v2.profiles.dsml.EqualityMatch;
import org.openspml.v2.profiles.dsml.Filter;
import org.openspml.v2.profiles.dsml.FilterItem;
import org.openspml.v2.profiles.dsml.GreaterOrEqual;
import org.openspml.v2.profiles.dsml.LessOrEqual;
import org.openspml.v2.profiles.dsml.Not;
import org.openspml.v2.profiles.dsml.Or;
import org.openspml.v2.profiles.dsml.Present;
import org.openspml.v2.profiles.dsml.Substrings;
import org.openspml.v2.util.xml.ObjectFactory;
import org.openspml.v2.util.xml.ReflectiveDOMXMLUnmarshaller;
import org.openspml.v2.util.xml.ReflectiveXMLMarshaller;
import org.openspml.v2.util.xml.XmlUtil;

public class MxSPMLv2_Util {
    private static String mPatchingMode = "";

    public static String getLDAPFilter(Object aFilter, String aPatchingMode) throws Exception {
        mPatchingMode = aPatchingMode;
        String filter = "";
        if (aFilter instanceof Filter) {
            Filter theFilter = (Filter)aFilter;
            if (theFilter.getItem() instanceof Or) {
                Or filterItem = (Or)theFilter.getItem();
                try {
                    int i = 0;
                    while (filterItem.getItems()[i] != null) {
                        filter = filter + MxSPMLv2_Util.getLDAPFilter(filterItem.getItems()[i], aPatchingMode);
                        ++i;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                filter = "(|" + filter + ")";
            } else if (theFilter.getItem() instanceof And) {
                And filterItem = (And)theFilter.getItem();
                try {
                    int i = 0;
                    while (filterItem.getItems()[i] != null) {
                        filter = filter + MxSPMLv2_Util.getLDAPFilter(filterItem.getItems()[i], aPatchingMode);
                        ++i;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                filter = "(&" + filter + ")";
            } else {
                filter = theFilter.getItem() instanceof Not ? MxSPMLv2_Util.getLDAPFilterItem(theFilter.getItem()) : MxSPMLv2_Util.getLDAPFilterItem(theFilter.getItem());
            }
        } else {
            filter = MxSPMLv2_Util.getLDAPFilterItem(aFilter);
            filter = "(" + filter + ")";
        }
        return filter;
    }

    private static String getLDAPFilterItem(Object aFilter) throws Exception {
        String filter = "";
        if (aFilter instanceof EqualityMatch) {
            EqualityMatch term = (EqualityMatch)aFilter;
            String termName = term.getName();
            if (MxSPMLv2_Util.containsMxDashAttrs(termName)) {
                MVDLogger.Debug("Attribute name before patching " + termName);
                termName = MVDUtil.replace(termName, "-", "_");
                termName = MVDUtil.replace(termName, "&#95", "_");
                MVDLogger.Debug("Attribute name after patching " + termName);
            }
            filter = termName + '=' + term.getValue().getValue();
        } else if (aFilter instanceof ApproxMatch) {
            ApproxMatch term = (ApproxMatch)aFilter;
            String termName = term.getName();
            if (MxSPMLv2_Util.containsMxDashAttrs(termName)) {
                MVDLogger.Debug("Attribute name before patching " + termName);
                termName = MVDUtil.replace(termName, "-", "_");
                termName = MVDUtil.replace(termName, "&#95", "_");
                MVDLogger.Debug("Attribute name after patching " + termName);
            }
            filter = termName + '=' + term.getValue();
        } else if (aFilter instanceof Not) {
            Not term = (Not)aFilter;
            filter = "!" + MxSPMLv2_Util.getLDAPFilter(term.getItem(), mPatchingMode);
        } else if (aFilter instanceof Present) {
            Present term = (Present)aFilter;
            String termName = term.getName();
            if (MxSPMLv2_Util.containsMxDashAttrs(termName)) {
                MVDLogger.Debug("Attribute name before patching " + termName);
                termName = MVDUtil.replace(termName, "-", "_");
                termName = MVDUtil.replace(termName, "&#95", "_");
                MVDLogger.Debug("Attribute name after patching " + termName);
            }
            filter = termName + "=*";
        } else if (aFilter instanceof GreaterOrEqual) {
            GreaterOrEqual term = (GreaterOrEqual)aFilter;
            String termName = term.getName();
            if (MxSPMLv2_Util.containsMxDashAttrs(termName)) {
                MVDLogger.Debug("Attribute name before patching " + termName);
                termName = MVDUtil.replace(termName, "-", "_");
                termName = MVDUtil.replace(termName, "&#95", "_");
                MVDLogger.Debug("Attribute name after patching " + termName);
            }
            filter = termName + ">=" + term.getValue();
        } else if (aFilter instanceof LessOrEqual) {
            LessOrEqual term = (LessOrEqual)aFilter;
            String termName = term.getName();
            if (MxSPMLv2_Util.containsMxDashAttrs(termName)) {
                MVDLogger.Debug("Attribute name before patching " + termName);
                termName = MVDUtil.replace(termName, "-", "_");
                termName = MVDUtil.replace(termName, "&#95", "_");
                MVDLogger.Debug("Attribute name after patching " + termName);
            }
            filter = termName + "<=" + term.getValue();
        } else if (aFilter instanceof Substrings) {
            DSMLValue finalTerm;
            Substrings term = (Substrings)aFilter;
            String filterVal = "";
            DSMLValue[] anyTerms = term.getAny();
            for (int i = 0; i < anyTerms.length; ++i) {
                DSMLValue anyTerm = anyTerms[i];
                filterVal = filterVal + "*" + anyTerm.getValue() + '*';
            }
            DSMLValue initTerm = term.getInitial();
            if (initTerm != null) {
                filterVal = filterVal + initTerm.getValue() + '*';
            }
            if ((finalTerm = term.getFinal()) != null) {
                filterVal = filterVal + '*' + finalTerm.getValue();
            }
            filterVal = MVDUtil.replace(filterVal, "**", "*");
            String termName = term.getName();
            if (MxSPMLv2_Util.containsMxDashAttrs(termName)) {
                MVDLogger.Debug("Attribute name before patching " + termName);
                termName = MVDUtil.replace(termName, "-", "_");
                termName = MVDUtil.replace(termName, "&#95", "_");
                MVDLogger.Debug("Attribute name after patching " + termName);
            }
            filter = termName + "=" + filterVal;
        }
        return filter;
    }

    private static boolean containsMxDashAttrs(String aSource) {
        if (aSource == null) {
            return false;
        }
        return mPatchingMode.equalsIgnoreCase("SAP") ? aSource.startsWith("MXREF-") || aSource.startsWith("mxref-") || aSource.startsWith("MXMEMBER-") || aSource.startsWith("mxmember-") || aSource.startsWith("MX-") || aSource.startsWith("mx-") : aSource.indexOf("-") >= 0;
    }

    public static Filter convertMVDFilterToSPMLv2Filter(MVDFilter aFilter) {
        Filter filter = new Filter();
        try {
            if (aFilter instanceof MVDFilterComplex) {
                MVDFilterComplex complex = (MVDFilterComplex)aFilter;
                Vector elements = complex.getFilters();
                switch (complex.getFilterOpType()) {
                    case 11: {
                        And andTerm = new And();
                        Iterator iter = elements.iterator();
                        while (iter.hasNext()) {
                            MVDFilter el = (MVDFilter)iter.next();
                            Filter f = MxSPMLv2_Util.convertMVDFilterToSPMLv2Filter(el);
                            andTerm.addItem(f.getItem());
                        }
                        filter.setItem((FilterItem)andTerm);
                        break;
                    }
                    case 13: {
                        Not notTerm = null;
                        Iterator iter = elements.iterator();
                        while (iter.hasNext()) {
                            MVDFilter el = (MVDFilter)iter.next();
                            Filter f = MxSPMLv2_Util.convertMVDFilterToSPMLv2Filter(el);
                            notTerm = new Not(f.getItem());
                        }
                        filter.setItem(notTerm);
                        break;
                    }
                    case 12: {
                        Or orTerm = new Or();
                        Iterator iter = elements.iterator();
                        while (iter.hasNext()) {
                            MVDFilter el = (MVDFilter)iter.next();
                            Filter f = MxSPMLv2_Util.convertMVDFilterToSPMLv2Filter(el);
                            orTerm.addItem(f.getItem());
                        }
                        filter.setItem((FilterItem)orTerm);
                    }
                }
            } else {
                MVDFilterSimple simple = (MVDFilterSimple)aFilter;
                switch (simple.getOpType()) {
                    case 0: {
                        filter.setItem((FilterItem)MxSPMLv2_Util.createEqualTerm(simple));
                        break;
                    }
                    case 2: {
                        filter.setItem((FilterItem)MxSPMLv2_Util.createGreaterOrEqualTerm(simple));
                        break;
                    }
                    case 1: {
                        filter.setItem((FilterItem)MxSPMLv2_Util.createLessOrEqualTerm(simple));
                        break;
                    }
                    case 3: {
                        filter.setItem((FilterItem)MxSPMLv2_Util.createPresentTerm(simple));
                        break;
                    }
                    case 4: {
                        filter.setItem((FilterItem)MxSPMLv2_Util.createSubstrings(simple));
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return filter;
    }

    private static EqualityMatch createEqualTerm(MVDFilterSimple aSimpleFilter) throws Exception {
        return new EqualityMatch(aSimpleFilter.getAttrName(), aSimpleFilter.getAttrValue());
    }

    private static Present createPresentTerm(MVDFilterSimple aSimpleFilter) throws Exception {
        return new Present(aSimpleFilter.getAttrName());
    }

    private static GreaterOrEqual createGreaterOrEqualTerm(MVDFilterSimple aSimpleFilter) throws Exception {
        GreaterOrEqual term = new GreaterOrEqual();
        term.setName(aSimpleFilter.getAttrName());
        term.setValue(new DSMLValue(aSimpleFilter.getAttrValue()));
        return term;
    }

    private static LessOrEqual createLessOrEqualTerm(MVDFilterSimple aSimpleFilter) throws Exception {
        LessOrEqual term = new LessOrEqual();
        term.setName(aSimpleFilter.getAttrName());
        term.setValue(new DSMLValue(aSimpleFilter.getAttrValue()));
        return term;
    }

    private static Substrings createSubstrings(MVDFilterSimple aSimpleFilter) throws Exception {
        Substrings term = new Substrings();
        term.setName(aSimpleFilter.getAttrName());
        Vector givenSubstrings = aSimpleFilter.getSubstrings();
        Iterator iter = givenSubstrings.iterator();
        while (iter.hasNext()) {
            MVDFilterSubstring sub = (MVDFilterSubstring)iter.next();
            switch (sub.getSubType()) {
                case 5: {
                    term.setInitial(new DSMLValue(sub.getAttrValue()));
                    break;
                }
                case 6: {
                    term.setFinal(new DSMLValue(sub.getAttrValue()));
                    break;
                }
                case 7: {
                    term.addAny(new DSMLValue(sub.getAttrValue()));
                }
            }
        }
        return term;
    }

    public static String getValue(Object aRetObject) {
        String value = "";
        try {
            if (aRetObject instanceof String) {
                byte[] retArray = ((String)aRetObject).getBytes();
                boolean isActuallyBinary = false;
                for (int i = 0; i < retArray.length; ++i) {
                    if (retArray[i] >= 32) continue;
                    isActuallyBinary = true;
                    break;
                }
                value = isActuallyBinary ? Base64.encode(retArray) : MxSPMLv2_Util.MapIllegalXMLChars(aRetObject.toString());
            } else {
                byte[] retArray = (byte[])aRetObject;
                value = Base64.encode(retArray);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            MVDLogger.Debug("Error getting value");
        }
        return value;
    }

    private static String MapIllegalXMLChars(String aString) {
        HashMap<String, String> mappings = new HashMap<String, String>();
        mappings.put("<", "&lt;");
        mappings.put(">", "&gt;");
        mappings.put("&", "&amp;");
        mappings.put("'", "&apos;");
        mappings.put("\"", "&quot;");
        try {
            char[] mappedStringAsChar;
            int indexCounter = 0;
            block2: do {
                mappedStringAsChar = aString.toCharArray();
                for (indexCounter = 0; indexCounter < mappedStringAsChar.length; ++indexCounter) {
                    if (mappedStringAsChar[indexCounter] != '&' || MxSPMLv2_Util.IsAmpLegal(aString, indexCounter, mappings)) continue;
                    aString = MxSPMLv2_Util.FormatLegalString(aString, indexCounter, "&", mappings);
                    continue block2;
                }
            } while (!MxSPMLv2_Util.IsStringLegal(aString, mappings));
            block4: do {
                mappedStringAsChar = aString.toCharArray();
                for (indexCounter = 0; indexCounter < mappedStringAsChar.length; ++indexCounter) {
                    if (mappedStringAsChar[indexCounter] != '<' && mappedStringAsChar[indexCounter] != '>' && !String.valueOf(mappedStringAsChar[indexCounter]).equalsIgnoreCase("'") && mappedStringAsChar[indexCounter] != '\"') continue;
                    String key = String.valueOf(mappedStringAsChar[indexCounter]);
                    aString = MxSPMLv2_Util.FormatLegalString(aString, indexCounter, key, mappings);
                    continue block4;
                }
            } while (!MxSPMLv2_Util.IsStringLegal(aString));
        }
        catch (Exception e) {
            MVDLogger.Debug("Error mapping illegal characters:" + e);
        }
        return aString;
    }

    private static String FormatLegalString(String aString, int aIndex, String aKey, HashMap aMappings) {
        if (aIndex != 0) {
            return aString.substring(0, aIndex) + aMappings.get(aKey) + aString.substring(aIndex + 1, aString.length());
        }
        return aMappings.get(aKey) + aString.substring(aIndex + 1, aString.length());
    }

    private static boolean IsStringLegal(String aMappedString) {
        return aMappedString.indexOf(60) < 0 && aMappedString.indexOf(62) < 0 && aMappedString.indexOf("'") < 0 && aMappedString.indexOf(34) < 0;
    }

    private static boolean IsStringLegal(String aMappedString, HashMap aMappings) {
        try {
            char[] mappedStringAsChar = aMappedString.toCharArray();
            for (int indexCounter = 0; indexCounter < mappedStringAsChar.length; ++indexCounter) {
                if (mappedStringAsChar[indexCounter] != '&' || MxSPMLv2_Util.IsAmpLegal(aMappedString, indexCounter, aMappings)) continue;
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    private static boolean IsAmpLegal(String aMappedString, int aIndexReached, HashMap aMappings) {
        try {
            char[] mappedStringAsChar = aMappedString.toCharArray();
            for (int indexCounter = aIndexReached; indexCounter < mappedStringAsChar.length; ++indexCounter) {
                if (mappedStringAsChar[indexCounter] != ';') continue;
                String subString = aMappedString.substring(aIndexReached, indexCounter + 1);
                return aMappings.containsValue(subString);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static Response unMarshalDSML(String aResponse) throws Exception {
        aResponse = XmlUtil.getSoapBodyContents((String)aResponse);
        ObjectFactory.getInstance().register((ObjectFactory.ProfileRegistrar)new DSMLProfileRegistrar());
        ReflectiveDOMXMLUnmarshaller unMarshaller = new ReflectiveDOMXMLUnmarshaller();
        return (Response)unMarshaller.unmarshall(aResponse);
    }

    public static String marshalDSML(Request aRequest) throws Exception {
        String response = "";
        ObjectFactory.getInstance().register((ObjectFactory.ProfileRegistrar)new DSMLProfileRegistrar());
        ReflectiveXMLMarshaller xmlMarshaller = new ReflectiveXMLMarshaller();
        try {
            response = aRequest.toXML((XMLMarshaller)xmlMarshaller);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return response;
    }

    public static Vector toVector(DSMLValue[] aValues) throws Exception {
        Vector<String> values = new Vector<String>();
        if (aValues == null || aValues.length == 0) {
            return values;
        }
        for (int i = 0; i < aValues.length; ++i) {
            DSMLValue value = aValues[i];
            values.add(value.getValue());
        }
        return values;
    }
}

