/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import org.openspml.v2.transport.RPCRouterMonitor;
import sun.misc.BASE64Encoder;

public class MxSOAPClient {
    private String _username;
    private String _password;
    private String _proxyHost;
    private int _proxyPort;
    private String _header = null;
    private String _bodyAttributes = null;
    private RPCRouterMonitor _monitor = null;

    public void setHeader(String header) {
        this._header = header;
    }

    public void setBodyAttributes(String attrs) {
        this._bodyAttributes = attrs;
    }

    public void setMonitor(RPCRouterMonitor monitor) {
        this._monitor = monitor;
    }

    public String sendAndReceive(URL url, String action, String xml) throws IOException {
        String toReturn;
        String inputLine;
        String encoding = null;
        URLConnection connection = url.openConnection();
        HttpURLConnection httpConn = (HttpURLConnection)connection;
        if (this._username != null && this._password != null && this._username.length() > 0 && this._password.length() > 0) {
            String up = this._username + ":" + this._password;
            BASE64Encoder encode = new BASE64Encoder();
            encoding = "Basic " + encode.encode(up.getBytes());
        }
        if (this._proxyHost != null) {
            String host = System.getProperty("http.proxyHost");
            if (host == null) {
                System.setProperty("http.proxyHost", this._proxyHost);
                System.setProperty("http.proxyPort", this._proxyPort + "");
            } else {
                System.out.println("WARNING: Did not override system's http.proxyHost settings.");
            }
        }
        String soapXml = this.addSOAPEnvelopeIfMissing(xml);
        byte[] xmlBytes = soapXml.getBytes();
        httpConn.setRequestProperty("Content-Length", String.valueOf(xmlBytes.length));
        httpConn.setRequestProperty("Content-Type", "text/xml; charset=UTF-8");
        if (encoding != null) {
            httpConn.setRequestProperty("Authorization", encoding);
        }
        if (action != null) {
            httpConn.setRequestProperty("SOAPAction", action);
        }
        httpConn.setRequestMethod("POST");
        httpConn.setDoOutput(true);
        httpConn.setDoInput(true);
        if (this._monitor != null) {
            this._monitor.send(soapXml);
        }
        OutputStream out = httpConn.getOutputStream();
        out.write(xmlBytes);
        out.close();
        InputStreamReader isr = new InputStreamReader(httpConn.getInputStream());
        BufferedReader in = new BufferedReader(isr);
        StringBuffer result = new StringBuffer();
        while ((inputLine = in.readLine()) != null) {
            result.append(inputLine);
        }
        in.close();
        String string = toReturn = result.length() == 0 ? null : result.toString();
        if (this._monitor != null) {
            this._monitor.receive(toReturn);
        }
        return toReturn;
    }

    private String addSOAPEnvelopeIfMissing(String xml) {
        int k;
        if (xml.indexOf("http://schemas.xmlsoap.org/soap/envelope/") > 0) {
            return xml;
        }
        StringBuffer buffer = new StringBuffer();
        if (this._header == null) {
            String[] header = new String[]{"<?xml version='1.0' encoding='UTF-8'?>", "<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\">", "<SOAP-ENV:Header/>"};
            for (k = 0; k < header.length; ++k) {
                buffer.append(header[k]);
            }
        } else {
            buffer.append(this._header);
        }
        if (this._bodyAttributes == null) {
            buffer.append("<SOAP-ENV:Body>");
        } else {
            buffer.append("<SOAP-ENV:Body ");
            buffer.append(this._bodyAttributes);
            buffer.append(">");
        }
        buffer.append(xml);
        String[] footer = new String[]{"</SOAP-ENV:Body>", "</SOAP-ENV:Envelope>"};
        for (k = 0; k < footer.length; ++k) {
            buffer.append(footer[k]);
        }
        return buffer.toString();
    }

    public MxSOAPClient(String username, String password, String proxyHost, int proxyPort) {
        this._username = username;
        this._password = password;
        this._proxyHost = proxyHost;
        this._proxyPort = proxyPort;
    }

    public MxSOAPClient(String username, String password, String proxyHost) {
        this(username, password, proxyHost, 8080);
    }

    public MxSOAPClient(String username, String password) {
        this(username, password, null);
    }

    public MxSOAPClient() {
        this(null, null, null);
    }
}

