/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.util;

import com.sap.idm.vds.MVDLogger;
import com.sap.idm.vds.config.MVDConfigException;
import com.sap.idm.vds.config.MVDKeyStore;
import com.sap.idm.vds.config.MVDKeyStoreList;
import com.sap.idm.vds.ie.op.common.util.MVDMic_Util;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.util.HashMap;
import java.util.HashSet;
import javax.net.SocketFactory;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public class MxJNDISocketFactory
extends SSLSocketFactory {
    private static HashMap sSocketFactoryMap = new HashMap();
    private static HashMap sNewSocketFactoryMap = new HashMap();
    private static HashMap sNewHostKeystoreMap = new HashMap();
    private static HashMap sNewHostTruststoreMap = new HashMap();
    private static String[] sDefaultCipherSuits = new String[0];
    private static String[] sSupportedCipherSuits = new String[0];
    private static String[] sNewDefaultCipherSuits = new String[0];
    private static String[] sNewSupportedCipherSuits = new String[0];

    public static void applyChanges() {
        sSocketFactoryMap = sNewSocketFactoryMap;
        sNewSocketFactoryMap = new HashMap();
        sNewHostKeystoreMap = new HashMap();
        sNewHostTruststoreMap = new HashMap();
        sDefaultCipherSuits = sNewDefaultCipherSuits;
        sSupportedCipherSuits = sNewSupportedCipherSuits;
        sNewDefaultCipherSuits = new String[0];
        sNewSupportedCipherSuits = new String[0];
    }

    private static boolean stringEqual(String aString1, String aString2) {
        if (aString1 == null) {
            return aString2 == null;
        }
        return aString1.equals(aString2);
    }

    public static void initializeSocketFactory(String aHost, String aPort, String aKeyStoreId, String aTrustStoreId) throws MVDConfigException {
        String key = aHost + ":" + aPort;
        if (sNewSocketFactoryMap.containsKey(key)) {
            String keyID = (String)sNewHostKeystoreMap.get(key);
            String trustID = (String)sNewHostTruststoreMap.get(key);
            if (!MxJNDISocketFactory.stringEqual(keyID, aKeyStoreId)) {
                MVDLogger.Log("Socket factory already initialized for " + key + ", but using other keystore", 6);
                return;
            }
            if (!MxJNDISocketFactory.stringEqual(trustID, aTrustStoreId)) {
                MVDLogger.Log("Socket factory already initialized for " + key + ", but using other truststore", 6);
                return;
            }
            return;
        }
        try {
            int tid;
            char[] pass;
            KeyStore ks;
            MVDKeyStore mks;
            int kid;
            SSLContext ctx = SSLContext.getInstance("TLS");
            KeyManager[] keyManager = null;
            TrustManager[] trustManager = null;
            if (aKeyStoreId != null && aKeyStoreId.length() > 0 && !aKeyStoreId.equals("-1") && (kid = Integer.parseInt(aKeyStoreId)) > 0) {
                mks = MVDKeyStoreList.getKeyStoreByID(kid);
                ks = KeyStore.getInstance(mks.getCertStoreType());
                pass = MVDMic_Util.dcString((String)mks.getCertStorePassword()).toCharArray();
                ks.load(new FileInputStream(mks.getCertStorePath()), pass);
                KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
                kmf.init(ks, pass);
                keyManager = kmf.getKeyManagers();
            }
            if (aTrustStoreId != null && aTrustStoreId.length() > 0 && !aTrustStoreId.equals("-1") && (tid = Integer.parseInt(aTrustStoreId)) > 0) {
                mks = MVDKeyStoreList.getKeyStoreByID(tid);
                ks = KeyStore.getInstance(mks.getCertStoreType());
                pass = MVDMic_Util.dcString((String)mks.getCertStorePassword()).toCharArray();
                ks.load(new FileInputStream(mks.getCertStorePath()), pass);
                TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
                tmf.init(ks);
                trustManager = tmf.getTrustManagers();
            }
            ctx.init(keyManager, trustManager, null);
            sNewHostKeystoreMap.put(key, aKeyStoreId);
            sNewHostTruststoreMap.put(key, aTrustStoreId);
            SSLSocketFactory sf = ctx.getSocketFactory();
            MxJNDISocketFactory.addCipherSuites(sf.getDefaultCipherSuites(), sf.getSupportedCipherSuites());
            sNewSocketFactoryMap.put(key, sf);
        }
        catch (Exception e) {
            MVDLogger.Log("Error creating socket factory for " + aHost + ":" + aPort + "(" + e.getMessage() + ")", 6, e);
            throw new MVDConfigException(e.getMessage());
        }
    }

    private static void addCipherSuites(String[] aDefaultCipherSuites, String[] aSupportedCipherSuites) {
        sNewDefaultCipherSuits = MxJNDISocketFactory.mergeLists(sNewDefaultCipherSuits, aDefaultCipherSuites);
        sNewSupportedCipherSuits = MxJNDISocketFactory.mergeLists(sNewSupportedCipherSuits, aSupportedCipherSuites);
    }

    private static String[] mergeLists(String[] aFirst, String[] aSecond) {
        int i;
        HashSet<String> tmp = new HashSet<String>();
        for (i = 0; i < aFirst.length; ++i) {
            tmp.add(aFirst[i]);
        }
        for (i = 0; i < aSecond.length; ++i) {
            tmp.add(aSecond[i]);
        }
        String[] x = new String[tmp.size()];
        return tmp.toArray(x);
    }

    public static SSLSocketFactory getSocketFactory(String aHost, int aPort) throws SSLException {
        SSLSocketFactory factory = (SSLSocketFactory)sSocketFactoryMap.get(aHost + ":" + aPort);
        if (factory == null) {
            MVDLogger.Log("Could not find initialized SSL socket factory for " + aHost + ":" + aPort, 7);
            throw new SSLException("Could not find initialized SSL socket factory for " + aHost + ":" + aPort);
        }
        return factory;
    }

    public static SSLSocketFactory getSocketFactory(InetAddress aHost, int aPort) throws SSLException {
        SSLSocketFactory factory = (SSLSocketFactory)sSocketFactoryMap.get(aHost.getHostName() + ":" + aPort);
        if (factory == null) {
            factory = (SSLSocketFactory)sSocketFactoryMap.get(aHost.getHostAddress() + ":" + aPort);
        }
        if (factory == null) {
            factory = (SSLSocketFactory)sSocketFactoryMap.get(aHost.getCanonicalHostName() + ":" + aPort);
        }
        if (factory == null && factory == null) {
            String host = aHost.getCanonicalHostName();
            MVDLogger.Log("Could not find initialized SSL socket factory for " + host + ":" + aPort, 7);
            throw new SSLException("Could not find initialized SSL socket factory for " + host + ":" + aPort);
        }
        return factory;
    }

    public Socket createSocket(Socket aSocket, String aHost, int aPort, boolean aAutoClose) throws IOException {
        return MxJNDISocketFactory.getSocketFactory(aHost, aPort).createSocket(aSocket, aHost, aPort, aAutoClose);
    }

    public String[] getDefaultCipherSuites() {
        return sDefaultCipherSuits;
    }

    public String[] getSupportedCipherSuites() {
        return sSupportedCipherSuits;
    }

    public Socket createSocket(String aHost, int aPort) throws IOException, UnknownHostException {
        return MxJNDISocketFactory.getSocketFactory(aHost, aPort).createSocket(aHost, aPort);
    }

    public Socket createSocket(InetAddress aHost, int aPort) throws IOException {
        return MxJNDISocketFactory.getSocketFactory(aHost.getHostName(), aPort).createSocket(aHost, aPort);
    }

    public Socket createSocket(String aHost, int aPort, InetAddress aLocalHost, int aLocalPort) throws IOException, UnknownHostException {
        return MxJNDISocketFactory.getSocketFactory(aHost, aPort).createSocket(aHost, aPort, aLocalHost, aLocalPort);
    }

    public Socket createSocket(InetAddress aAddress, int aPort, InetAddress aLocalAddress, int aLocalPort) throws IOException {
        return MxJNDISocketFactory.getSocketFactory(aAddress.getHostName(), aPort).createSocket(aAddress, aPort, aLocalAddress, aLocalPort);
    }

    public static SocketFactory getDefault() {
        return new MxJNDISocketFactory();
    }
}

