/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.util;

import com.sap.idm.vds.Globals;
import com.sap.idm.vds.MVDDebitInfo;
import com.sap.idm.vds.MVDGlobals;
import com.sap.idm.vds.MVDServer;
import com.sap.idm.vds.MVDUtil;
import com.sap.tc.logging.FileLog;
import com.sap.tc.logging.Location;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class MVDDebitLogger {
    private static HashMap myAuditLoggers = new HashMap();
    private static HashMap mLocationMapping = new HashMap();
    private static boolean mLogTraffic;
    private static boolean mLogEmptyTraffic;
    private static int mLogTrafficOperationTypes;

    public static boolean LogTraffic() {
        return mLogTraffic;
    }

    public static boolean LogEmptyTraffic() {
        return mLogEmptyTraffic;
    }

    public static int LogTrafficOperationTypes() {
        return mLogTrafficOperationTypes;
    }

    public static void SetLogTraffic(boolean b) {
        mLogTraffic = b;
    }

    public static void SetLogEmptyTraffic(boolean b) {
        mLogEmptyTraffic = b;
    }

    public static void SetLogTrafficOperationTypes(String s) {
        mLogTrafficOperationTypes = Integer.parseInt(s);
    }

    public MVDDebitLogger(Vector aLoggerKeys) {
        MVDDebitLogger.addLoggers(aLoggerKeys);
    }

    public static void addLoggers(Vector aLoggerKeys) {
        for (int i = 0; i < aLoggerKeys.size(); ++i) {
            String s = (String)aLoggerKeys.elementAt(i);
            String extension = "";
            if (s.equals(MVDGlobals.getMainGroupName())) {
                extension = "admin";
            } else if (s.startsWith("LDAP Sessions:")) {
                extension = s.substring("LDAP Sessions:".length());
            } else {
                if (!s.startsWith("Web Service:")) continue;
                extension = s.substring("Web Service:".length());
            }
            String wa = Globals.getWorkArea();
            String propf = wa + "\\standalonelog.prop";
            boolean bStandalone = true;
            String aLoc = "";
            HashMap standaloneProps = MVDUtil.readPropertyFile(propf);
            if (standaloneProps == null) {
                bStandalone = false;
            } else {
                bStandalone = true;
                aLoc = (String)standaloneProps.get("AUDITLOGLOCATION");
                if (aLoc == null) {
                    aLoc = wa + "\\logs\\audit.trc";
                }
            }
            mLocationMapping.put(s, extension);
            String sc = MVDGlobals.getConfigurationName();
            Location auditlocation = (Location)myAuditLoggers.get(s);
            if (auditlocation == null) {
                auditlocation = Location.getLocation("com.sap.idm.vds." + sc + ".audit." + extension);
            }
            if (auditlocation == null) {
                System.out.println("Can not create SAP Logging Location ... ");
                return;
            }
            if (bStandalone) {
                auditlocation.setEffectiveSeverity(300);
                Collection c = auditlocation.getLogs();
                if (c.size() > 0) {
                    Iterator iterator = c.iterator();
                    while (iterator.hasNext()) {
                        FileLog fl = (FileLog)iterator.next();
                        fl.close();
                        fl = new FileLog(aLoc);
                    }
                } else {
                    auditlocation.addLog(new FileLog(aLoc));
                }
            }
            myAuditLoggers.put(s, auditlocation);
        }
    }

    public static void removeLoggers(Vector aLoggerKeys) {
        for (int i = 0; i < aLoggerKeys.size(); ++i) {
            String s = (String)aLoggerKeys.elementAt(i);
            myAuditLoggers.remove(s);
            mLocationMapping.remove(s);
        }
    }

    private static String extractPortFromGroup(String str) {
        int ix = str.indexOf("PORT:");
        if (ix >= 0) {
            str = str.substring(ix + 5);
            return str;
        }
        return null;
    }

    public static void LogDebitInfo(MVDDebitInfo mdbi) {
        if (mdbi == null) {
            return;
        }
        if (!mLogTraffic) {
            return;
        }
        if (mdbi.OperationType().equalsIgnoreCase("SEARCH")) {
            if ((mLogTrafficOperationTypes & 1) != 1) {
                return;
            }
            if (mdbi.ReturnedEntries() == 0 && !mLogEmptyTraffic) {
                return;
            }
        }
        if (mdbi.OperationType().equalsIgnoreCase("ADD") && (mLogTrafficOperationTypes & 2) != 2) {
            return;
        }
        if (mdbi.OperationType().equalsIgnoreCase("MODIFY") && (mLogTrafficOperationTypes & 4) != 4) {
            return;
        }
        if (mdbi.OperationType().equalsIgnoreCase("DELETE") && (mLogTrafficOperationTypes & 8) != 8) {
            return;
        }
        if (mdbi.OperationType().equalsIgnoreCase("COMPARE") && (mLogTrafficOperationTypes & 0x10) != 16) {
            return;
        }
        String loggerKey = "";
        loggerKey = MVDServer.getMVDProtocol() == 0 ? Thread.currentThread().getThreadGroup().getName() : "Web Service:" + MVDServer.getUniqueInstanceID();
        Location aLoc = (Location)myAuditLoggers.get(loggerKey);
        mdbi.endOperation();
        aLoc.logT(300, mdbi.toString());
    }
}

