/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.util;

import com.sap.idm.vds.config.LicenseConstants;
import com.sap.idm.vds.config.LicenseManager;
import java.io.File;
import java.io.FileNotFoundException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;

public class LicenseUtil {
    public static final String LICENSE_VALID = "VALID";
    public static final String LICENSE_EXPIRES = "EXPIRES";
    public static final String LICENSE_MESSAGE = "MESSAGE";
    public static final String LICENSE_INFO = "INFO";
    public static final String LICENSE_PRODUCT = "PRODUCT";

    public static HashMap verifyLicense(String aLicenseFile) {
        HashMap<String, Object> responseMap = new HashMap<String, Object>();
        try {
            String product = LicenseConstants.VDS_LICENSE_STRING;
            LicenseManager lce = new LicenseManager(new File(aLicenseFile), product);
            boolean valid = lce.verify();
            if (!valid) {
                product = LicenseConstants.MVD_LICENSE_STRING;
                lce = new LicenseManager(new File(aLicenseFile), product);
                valid = lce.verify();
            }
            responseMap.put(LICENSE_PRODUCT, product);
            responseMap.put(LICENSE_VALID, valid);
            responseMap.put(LICENSE_INFO, lce.getInfo());
            HashMap tags = lce.getTags();
            String strValid = (String)tags.get(LicenseConstants.VALID_TO);
            long expires = -1L;
            if (strValid.equalsIgnoreCase(LicenseConstants.FOREVER)) {
                expires = -1L;
            } else {
                try {
                    SimpleDateFormat in = new SimpleDateFormat("ddMMyyyy");
                    Date d = in.parse(strValid);
                    long oneDay = 86400000L;
                    long exp = d.getTime();
                    if (exp + oneDay < 0L) {
                        expires = 0L;
                        responseMap.put(LICENSE_MESSAGE, "License expired");
                    } else {
                        expires = exp + oneDay - System.currentTimeMillis();
                        responseMap.put(LICENSE_MESSAGE, "");
                    }
                }
                catch (ParseException e) {
                    expires = 0L;
                    responseMap.put(LICENSE_MESSAGE, "Unable to parse date in license");
                }
            }
            responseMap.put(LICENSE_EXPIRES, new Long(expires));
        }
        catch (FileNotFoundException f) {
            responseMap.put(LICENSE_VALID, Boolean.FALSE);
            responseMap.put(LICENSE_MESSAGE, "License file not found");
        }
        catch (Exception e) {
            responseMap.put(LICENSE_VALID, Boolean.FALSE);
            responseMap.put(LICENSE_MESSAGE, e.getMessage());
        }
        return responseMap;
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("Usage:");
            System.out.println("java -cp mvd.jar <path to licensefile>");
            System.exit(1);
        }
        HashMap map = LicenseUtil.verifyLicense(args[0]);
        long exp = (Long)map.get(LICENSE_EXPIRES);
        String expStr = "";
        if (exp == -1L) {
            expStr = "NEVER";
        } else if (exp == 0L) {
            expStr = "Already expired";
        } else {
            SimpleDateFormat df = new SimpleDateFormat("yyyy.MM.dd");
            expStr = df.format(new Date(exp + System.currentTimeMillis()));
        }
        System.out.println("License is valid:                    " + map.get(LICENSE_VALID));
        System.out.println("License expires :                    " + expStr);
        System.out.println("Messages        :                    " + map.get(LICENSE_MESSAGE));
        System.out.println(map.get(LICENSE_INFO));
    }
}

