/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.util;

import com.sap.idm.vds.AbstractOperation;
import com.sap.idm.vds.MVDEngineData;
import com.sap.idm.vds.MVDHashMap;
import com.sap.idm.vds.MVDLogger;
import com.sap.idm.vds.MVDModAttrValues;
import com.sap.idm.vds.MVDOperationResult;
import com.sap.idm.vds.MVDSearchResultEntry;
import com.sap.idm.vds.MVDSearchResults;
import com.sap.idm.vds.MVDUtil;
import com.sap.idm.vds.MVDUtilities;
import com.sap.idm.vds.config.MVDDataSource;
import com.sap.idm.vds.config.MVDDataSourceList;
import com.sap.idm.vds.util.HidedJNDIOperations;
import com.sap.idm.vds.util.OneShutJNDI;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import javax.naming.AuthenticationException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.ldap.InitialLdapContext;

public class LDAPUtil {
    public static final int LOOKUP_FIRST_STRING = 1;
    public static final int LOOKUP_ALL_STRING = 2;
    public static final int BASE_OBJECT = 0;
    public static final int SINGLE_LEVEL = 1;
    public static final int WHOLE_SUBTREE = 2;

    public static void fixDNSyntaxAttributes_MOD(String aAttributes, Vector aAttrNamesAndModValues, String aVirtuelSP, String aRealSP) {
        Vector candidates = MVDUtil.splitString(aAttributes, ",");
        for (int x = 0; x < aAttrNamesAndModValues.size(); ++x) {
            MVDModAttrValues modv = (MVDModAttrValues)aAttrNamesAndModValues.elementAt(x);
            String aName = modv.getAttrName();
            if (!candidates.contains(aName)) continue;
            for (int y = 0; y < modv.size(); ++y) {
                String t = (String)modv.elementAt(y);
                try {
                    t = MVDUtil.NiceDN(t);
                }
                catch (Exception e) {
                    // empty catch block
                }
                t = MVDUtilities.fixStartingPoint(t, aRealSP, aVirtuelSP);
                modv.setElementAt(t, y);
            }
        }
    }

    public static void fixDNSyntaxAttributes_ADD(String aAttributes, HashMap aAttrNamesAndValues, String aVirtuelSP, String aRealSP) {
        Vector candidates = MVDUtil.splitString(aAttributes, ",");
        for (int x = 0; x < candidates.size(); ++x) {
            String cand = (String)candidates.elementAt(x);
            Vector v = (Vector)aAttrNamesAndValues.get(cand);
            if (v == null) continue;
            for (int y = 0; y < v.size(); ++y) {
                String t = (String)v.elementAt(y);
                try {
                    t = MVDUtil.NiceDN(t);
                }
                catch (Exception e) {
                    // empty catch block
                }
                t = MVDUtilities.fixStartingPoint(t, aRealSP, aVirtuelSP);
                v.setElementAt(t, y);
            }
        }
    }

    public static boolean compare(String aMVDUniqueDataSourceName, String aStartingPoint, String aURLFilter) {
        String pwd;
        MVDDataSource ds = MVDDataSourceList.getDSByUniqueName(aMVDUniqueDataSourceName);
        if (ds == null) {
            return false;
        }
        String server = (String)ds.ParamFields().get("DS_SERVER");
        String port = (String)ds.ParamFields().get("DS_PORT");
        String user = (String)ds.ParamFields().get("DS_USER");
        if (user == null) {
            user = "";
        }
        if ((pwd = (String)ds.ParamFields().get("DS_PASSWORD")) == null) {
            pwd = "";
        }
        return LDAPUtil.compare(server, port, user, pwd, aStartingPoint, aURLFilter);
    }

    public static boolean compare(String aServer, String aPort, String aUser, String aPassword, String aStartingPoint, String aURLFilter) {
        OneShutJNDI osj = new OneShutJNDI();
        MVDLogger.Log("Compare using: " + aServer + " - " + aPort + " - " + aUser, 2);
        MVDSearchResults ss = osj.Compare(aServer, aPort, aUser, aPassword, aStartingPoint, aURLFilter);
        if (ss.isOK()) {
            return ss.size() > 0;
        }
        MVDLogger.Log("Compare error : code: " + ss.getCode() + " - message:" + ss.getMessage(), 2);
        return false;
    }

    public static MVDOperationResult compare(String aServer, String aPort, String aUser, String aPassword, String aStartingPoint, String aURLFilter, String aSecurityProtocol, boolean aCacheConnections, MVDHashMap aEngineGlobals) {
        HidedJNDIOperations hjo = new HidedJNDIOperations();
        MVDOperationResult ss = hjo.Compare(aServer, aPort, aUser, aPassword, aStartingPoint, aURLFilter, aSecurityProtocol, aCacheConnections, aEngineGlobals);
        return ss;
    }

    public static MVDSearchResults search(String aServer, String aPort, String aUser, String aPassword, String aStartingPoint, int aScope, Vector aAttrs, String aURLFilter, int aSizeLimit, int aTimeLimit) {
        OneShutJNDI osj = new OneShutJNDI();
        return osj.Search(aServer, aPort, aUser, aPassword, aStartingPoint, aScope, aAttrs, aURLFilter, aSizeLimit, aTimeLimit);
    }

    public static MVDSearchResults searchForADObject(String aServer, String aPort, String aUser, String aPassword, String aStartingPoint, int aScope, Vector aAttrs, String aURLFilter, int aSizeLimit, int aTimeLimit) {
        OneShutJNDI osj = new OneShutJNDI();
        return osj.searchForADObject(aServer, aPort, aUser, aPassword, aStartingPoint, aScope, aAttrs, aURLFilter, aSizeLimit, aTimeLimit);
    }

    public static MVDSearchResults search(String aServer, String aPort, String aUser, String aPassword, String aStartingPoint, int aScope, Vector aAttrs, String aURLFilter, int aSizeLimit, int aTimeLimit, String aSecurityProtocol, String aAdditionalBinaryAttributes, boolean aCacheConnections, MVDHashMap aEngineGlobals) {
        HidedJNDIOperations hjo = new HidedJNDIOperations();
        return hjo.Search(aServer, aPort, aUser, aPassword, aStartingPoint, aScope, aAttrs, aURLFilter, aSizeLimit, aTimeLimit, aSecurityProtocol, aAdditionalBinaryAttributes, aCacheConnections, aEngineGlobals);
    }

    public static MVDSearchResults searchPaged(String aServer, String aPort, String aUser, String aPassword, String aStartingPoint, int aScope, Vector aAttrs, String aURLFilter, int aSizeLimit, int aTimeLimit, String aSecurityProtocol, String aAdditionalBinaryAttributes, boolean aCacheConnections, MVDHashMap aEngineGlobals, int aPageSize) {
        HidedJNDIOperations hjo = new HidedJNDIOperations();
        return hjo.PagedSearch(aServer, aPort, aUser, aPassword, aStartingPoint, aScope, aAttrs, aURLFilter, aSizeLimit, aTimeLimit, aSecurityProtocol, aAdditionalBinaryAttributes, aCacheConnections, aEngineGlobals, aPageSize);
    }

    public static MVDSearchResults search(String aMVDUniqueDataSourceName, String aLoggedinUser, String aLoggedinPwd, String aStartingPoint, int aScope, String aAttr, String aURLFilter, int aSizeLimit, int aTimeLimit) {
        HashMap params = MVDUtil.getDSParametersByDSUniqueName(aMVDUniqueDataSourceName);
        String server = (String)params.get("DS_SERVER");
        String port = (String)params.get("DS_PORT");
        String startingpoint = aStartingPoint == null ? (String)params.get("DS_REALSP") : aStartingPoint;
        String secprot = (String)params.get("DS_SECPROT");
        String username = (String)params.get("DS_USER");
        String password = (String)params.get("DS_PASSWORD");
        username = username == null ? "" : username;
        password = password == null ? "" : password;
        username = MVDUtil.replace(username, "%user%", aLoggedinUser);
        password = MVDUtil.replace(password, "%pwd%", aLoggedinPwd);
        aAttr = aAttr == null ? "" : aAttr;
        Vector attrs = MVDUtil.splitString(aAttr, ',');
        MVDSearchResults res = LDAPUtil.search(server, port, username, password, startingpoint, aScope, attrs, aURLFilter, aSizeLimit, aTimeLimit);
        return res;
    }

    public static MVDOperationResult modify(String aServer, String aPort, String aUser, String aPassword, String aStartingPoint, Vector aAttrNamesAndModValues) {
        OneShutJNDI osj = new OneShutJNDI();
        return osj.Modify(aServer, aPort, aUser, aPassword, aStartingPoint, aAttrNamesAndModValues);
    }

    public static MVDOperationResult modify(String aServer, String aPort, String aUser, String aPassword, String aStartingPoint, Vector aAttrNamesAndModValues, String aSecurityProtocol, String aAdditionalBinaryAttributes, boolean aCacheConnections, MVDHashMap aEngineGlobals) {
        HidedJNDIOperations hjo = new HidedJNDIOperations();
        return hjo.Modify(aServer, aPort, aUser, aPassword, aStartingPoint, aAttrNamesAndModValues, aSecurityProtocol, aAdditionalBinaryAttributes, aCacheConnections, aEngineGlobals);
    }

    public static MVDOperationResult add(String aServer, String aPort, String aUser, String aPassword, String aStartingPoint, HashMap aAttrNamesValues) {
        OneShutJNDI osj = new OneShutJNDI();
        return osj.Add(aServer, aPort, aUser, aPassword, aStartingPoint, aAttrNamesValues);
    }

    public static MVDOperationResult add(String aServer, String aPort, String aUser, String aPassword, String aStartingPoint, HashMap aAttrNamesAndValues, String aSecurityProtocol, String aAdditionalBinaryAttributes, boolean aCacheConnections, MVDHashMap aEngineGlobals) {
        HidedJNDIOperations hjo = new HidedJNDIOperations();
        return hjo.Add(aServer, aPort, aUser, aPassword, aStartingPoint, aAttrNamesAndValues, aSecurityProtocol, aAdditionalBinaryAttributes, aCacheConnections, aEngineGlobals);
    }

    public static MVDOperationResult delete(String aServer, String aPort, String aUser, String aPassword, String aStartingPoint) {
        OneShutJNDI osj = new OneShutJNDI();
        return osj.Delete(aServer, aPort, aUser, aPassword, aStartingPoint);
    }

    public static MVDOperationResult delete(String aServer, String aPort, String aUser, String aPassword, String aStartingPoint, String aSecurityProtocol, boolean aCacheConnections, MVDHashMap aEngineGlobals) {
        HidedJNDIOperations hjo = new HidedJNDIOperations();
        return hjo.Delete(aServer, aPort, aUser, aPassword, aStartingPoint, aSecurityProtocol, aCacheConnections, aEngineGlobals);
    }

    public static MVDOperationResult setADPassword(String aServer, String aPort, String aAdminUser, String aAdminPassword, String aUsername, String aOldPassword, String aNewPassword) {
        OneShutJNDI osj = new OneShutJNDI();
        return osj.SetADPassword(aServer, aPort, aAdminUser, aAdminPassword, aUsername, aOldPassword, aNewPassword);
    }

    public static Vector getADTokenGroups(String aServer, String aPort, String aUser, String aPassword, String aGroupAttribute) {
        String group = "tokengroups";
        Vector<String> aAttr = new Vector<String>();
        aAttr.add(group);
        MVDSearchResults result = LDAPUtil.search(aServer, aPort, aUser, aPassword, aUser, 0, aAttr, "(objectclass=*)", 1, 30);
        if (!result.isOK()) {
            MVDLogger.Debug("Could not execute base search: (" + aServer + " : " + aPort + " : " + aUser);
            return null;
        }
        if (result.size() == 0) {
            MVDLogger.Debug("No entries found. Searched: (" + aServer + " : " + aPort + " : " + aUser);
            return new Vector();
        }
        MVDSearchResultEntry e = (MVDSearchResultEntry)result.elementAt(0);
        Vector vTokenGroups = e.getAttrValues(group);
        if (vTokenGroups == null || vTokenGroups.size() == 0) {
            MVDLogger.Debug("No token groups in the entry");
            return new Vector();
        }
        aAttr.removeAllElements();
        Vector<String> vAllGroupNames = new Vector<String>();
        for (int ix = 0; ix < vTokenGroups.size(); ++ix) {
            byte[] sidBinary = (byte[])vTokenGroups.elementAt(ix);
            String sidHex = MVDUtil.byteToHex(sidBinary);
            sidHex = sidHex.toLowerCase();
            String aName = "<SID=" + sidHex + ">";
            MVDSearchResults rr1 = LDAPUtil.searchForADObject(aServer, aPort, aUser, aPassword, aName, 0, aAttr, "(objectclass=*)", 1, 30);
            if (!rr1.isOK() || rr1.size() == 0) {
                MVDLogger.Debug("Could not fetch properties for " + aName);
                continue;
            }
            MVDSearchResultEntry ee = (MVDSearchResultEntry)rr1.elementAt(0);
            String nm = ee.getFirstAttrValue(aGroupAttribute);
            vAllGroupNames.add(nm);
        }
        return vAllGroupNames;
    }

    public static String lookup(String mvdUniqueDataSourceName, int scope, String attr, String urlfilter, int returnType) {
        return LDAPUtil.lookup(mvdUniqueDataSourceName, null, scope, attr, urlfilter, returnType);
    }

    public static String lookup(String aMVDUniqueDataSourceName, String aStartingPoint, int aScope, String aAttr, String aURLFilter) {
        return LDAPUtil.lookup(aMVDUniqueDataSourceName, aStartingPoint, aScope, aAttr, aURLFilter, 1);
    }

    public static String lookup(String aServer, String aPort, String aUser, String aPassword, String aStartingPoint, int aScope, String aAttr, String aURLFilter, String aSecurityProtocol, String aAdditionalBinaryAttributes, boolean aCacheConnections, MVDHashMap aEngineGlobals) {
        HidedJNDIOperations hjo = new HidedJNDIOperations();
        return hjo.Lookup(aServer, aPort, aUser, aPassword, aStartingPoint, aScope, aAttr, aURLFilter, aSecurityProtocol, aAdditionalBinaryAttributes, aCacheConnections, aEngineGlobals);
    }

    public static String lookup(String aMVDUniqueDataSourceName, String aStartingPoint, int aScope, String aAttr, String aURLFilter, int aReturnType) {
        MVDDataSource ds = MVDDataSourceList.getDSByUniqueName(aMVDUniqueDataSourceName);
        if (ds == null) {
            return null;
        }
        String result = null;
        boolean resultok = false;
        MVDHashMap params = new MVDHashMap(ds.ParamFields());
        if (!ds.EnableMultipleServers()) {
            result = LDAPUtil.oneLookupAttempt(params, aStartingPoint, aScope, aAttr, aURLFilter, aReturnType);
            if (result != null && result.equals("-FAILOVER-")) {
                return null;
            }
        } else {
            int runs = 0;
            long bNoMoreServers = 0L;
            do {
                if ((result = LDAPUtil.oneLookupAttempt(params = ds.getTopMultiServerGroup().getMultiServerParams(ds.DSType(), params), aStartingPoint, aScope, aAttr, aURLFilter, aReturnType)) != null && result.equals("-FAILOVER-")) {
                    MVDLogger.Log("Lookup failed - starting failover", 7);
                    bNoMoreServers = ds.getTopMultiServerGroup().setNextDS(ds, true);
                    result = null;
                    continue;
                }
                resultok = true;
            } while (!resultok && bNoMoreServers < 0L && ++runs <= ds.getTopMultiServerGroup().getMultiServerGroups().size());
        }
        return result;
    }

    private static String oneLookupAttempt(MVDHashMap aParams, String aStartingPoint, int aScope, String aAttr, String aURLFilter, int aReturnType) {
        String secprot;
        String password;
        String server = (String)aParams.get("DS_SERVER");
        String port = (String)aParams.get("DS_PORT");
        String user = (String)aParams.get("DS_USER");
        if (user == null) {
            user = "";
        }
        if ((password = (String)aParams.get("DS_PASSWORD")) == null) {
            password = "";
        }
        String aSp = "";
        if (aStartingPoint == null) {
            aSp = (String)aParams.get("DS_REALSP");
            if (aSp == null) {
                aSp = "";
            }
        } else {
            aSp = aStartingPoint;
        }
        secprot = (secprot = (String)aParams.get("DS_SECPROT")) == null ? "simple" : secprot;
        MVDLogger.Log("Executing lookup in '" + server + "' on port " + port + " using secury protocol '" + secprot + "'", 2);
        OneShutJNDI osj = new OneShutJNDI();
        return osj.LookupFailover(server, port, user, password, aSp, aScope, aAttr, aURLFilter, aReturnType, secprot);
    }

    public static String lookup(String aServer, String aPort, String aUser, String aPassword, String aStartingPoint, int aScope, String aAttr, String aURLFilter) {
        return LDAPUtil.lookup(aServer, aPort, aUser, aPassword, aStartingPoint, aScope, aAttr, aURLFilter, 1, null);
    }

    public static String lookup(String aServer, String aPort, String aUser, String aPassword, String aStartingpPoint, int aScope, String aAttr, String aURLFilter, int aReturnType, String aSecurityOption) {
        MVDLogger.Log("Executing lookup in '" + aServer + "' on port " + aPort + " using secury protocol '" + aSecurityOption + "'", 2);
        OneShutJNDI osj = new OneShutJNDI();
        return osj.Lookup(aServer, aPort, aUser, aPassword, aStartingpPoint, aScope, aAttr, aURLFilter, aReturnType, aSecurityOption);
    }

    public static boolean bindByTree(String aTree, String aVirtualDN, String aPassword) {
        String dsuniquename = MVDUtil.getUniqueDSNameByDN(aTree, aVirtualDN);
        MVDLogger.Log("Obtained authenticating datasource " + dsuniquename, 2);
        String realDN = MVDUtil.getProperDN(aTree, aVirtualDN);
        MVDLogger.Log("Obtained real DN " + realDN, 2);
        return LDAPUtil.bind(dsuniquename, realDN, aPassword);
    }

    public static boolean bindByTreeByConnector(String aTree, String aVirtualDN, MVDEngineData aEngineData, MVDHashMap aEngineGs, MVDHashMap aOriginalBindparams) {
        String dsuniquename = MVDUtil.getUniqueDSNameByDN(aTree, aVirtualDN);
        MVDLogger.Log("Obtained authenticating datasource " + dsuniquename, 2);
        String virtSP = MVDUtil.getVirtualSP(aTree, aVirtualDN);
        MVDLogger.Log("Obtained virtuals SP " + virtSP, 2);
        aOriginalBindparams.put("NODE_VIRTUALSP", virtSP);
        return LDAPUtil.bindByConnector(dsuniquename, aEngineData, aEngineGs, aOriginalBindparams);
    }

    public static boolean bind(String aMVDUniqueDSName, String aRealDN, String aPassword) {
        MVDDataSource ds = MVDDataSourceList.getDSByUniqueName(aMVDUniqueDSName);
        if (ds == null) {
            return false;
        }
        boolean bindRes = false;
        int bindresult = 49;
        MVDHashMap params = new MVDHashMap(ds.ParamFields());
        if (!ds.EnableMultipleServers()) {
            bindresult = LDAPUtil.oneBindAttempt(params, aRealDN, aPassword);
            if (bindresult != 0) {
                MVDLogger.Log("Bind failed", 2);
            }
        } else {
            int runs = 0;
            long bNoMoreServers = 0L;
            do {
                if ((bindresult = LDAPUtil.oneBindAttempt(params = ds.getTopMultiServerGroup().getMultiServerParams(ds.DSType(), params), aRealDN, aPassword)) != 52) continue;
                MVDLogger.Log("Bind failed - starting failover ... ", 7);
                bNoMoreServers = ds.getTopMultiServerGroup().setNextDS(ds, true);
            } while (bindresult == 52 && bNoMoreServers < 0L && ++runs <= ds.getTopMultiServerGroup().getMultiServerGroups().size());
        }
        bindRes = bindresult == 0;
        return bindRes;
    }

    public static boolean bindByConnector(String aMVDUniqueDSName, MVDEngineData aEngineData, MVDHashMap aEngineGs, MVDHashMap aOriginalBindparams) {
        MVDDataSource ds = MVDDataSourceList.getDSByUniqueName(aMVDUniqueDSName);
        if (ds == null) {
            return false;
        }
        boolean bindRes = false;
        int bindresult = 49;
        String className = ds.SearchScript();
        AbstractOperation o = aEngineData.getInitiatedAbstractOperation(className, aEngineGs);
        if (o == null) {
            MVDLogger.Log("Can not obtain connector object for bind (className=" + className + ")", 7);
            bindRes = false;
            return bindRes;
        }
        MVDHashMap params = new MVDHashMap(ds.ParamFields());
        params.putAll(aOriginalBindparams);
        if (!ds.EnableMultipleServers()) {
            bindresult = LDAPUtil.oneBindAttemptByConnector(o, params);
            if (bindresult != 0) {
                MVDLogger.Log("Bind failed", 2);
            }
        } else {
            int runs = 0;
            long bNoMoreServers = 0L;
            do {
                if ((bindresult = LDAPUtil.oneBindAttemptByConnector(o, params = ds.getTopMultiServerGroup().getMultiServerParams(ds.DSType(), params))) != 52) continue;
                MVDLogger.Log("Bind failed - starting failover ... ", 7);
                bNoMoreServers = ds.getTopMultiServerGroup().setNextDS(ds, true);
            } while (bindresult == 52 && bNoMoreServers < 0L && ++runs <= ds.getTopMultiServerGroup().getMultiServerGroups().size());
        }
        bindRes = bindresult == 0;
        return bindRes;
    }

    private static int oneBindAttempt(MVDHashMap aParams, String aUsername, String aPassword) {
        String server = (String)aParams.get("DS_SERVER");
        String port = (String)aParams.get("DS_PORT");
        String secprot = (String)aParams.get("DS_SECPROT");
        secprot = secprot == null ? "simple" : secprot;
        MVDLogger.Log("Binding to '" + server + "' on port " + port + " using secury protocol '" + secprot + "'", 2);
        MVDLogger.Log("Binding as '" + aUsername + "'", 2);
        int res = 49;
        res = LDAPUtil.bindDirect(server, port, aUsername, aPassword, secprot);
        return res;
    }

    private static int oneBindAttemptByConnector(AbstractOperation o, MVDHashMap aParams) {
        MVDLogger.Log("Binding using connecto ...", 2);
        MVDOperationResult bindresult = new MVDOperationResult();
        bindresult.setCode(49, "Invalid credentials");
        try {
            bindresult = o.bind(aParams);
        }
        catch (Throwable ee) {
            MVDLogger.Log("Error binding using connector:" + ee, 7, ee);
        }
        return bindresult.getCode();
    }

    public static boolean bind(String mvdUniqueDataSourceName, String aPort, String aUser, String aPassword, String aSecProt) {
        MVDDataSource ds = MVDDataSourceList.getDSByUniqueName(mvdUniqueDataSourceName);
        if (ds == null) {
            return false;
        }
        boolean bindRes = false;
        int bindresult = 49;
        MVDHashMap params = new MVDHashMap(ds.ParamFields());
        if (!ds.EnableMultipleServers()) {
            bindresult = LDAPUtil.oneBindAttempt(params, aPort, aUser, aPassword, aSecProt);
            if (bindresult != 0) {
                MVDLogger.Log("Bind failed", 2);
            }
        } else {
            int runs = 0;
            long bNoMoreServers = 0L;
            do {
                if ((bindresult = LDAPUtil.oneBindAttempt(params = ds.getTopMultiServerGroup().getMultiServerParams(ds.DSType(), params), aPort, aUser, aPassword, aSecProt)) != 52) continue;
                MVDLogger.Log("Bind failed - starting failover ... ", 7);
                bNoMoreServers = ds.getTopMultiServerGroup().setNextDS(ds, true);
            } while (bindresult == 52 && bNoMoreServers < 0L && ++runs <= ds.getTopMultiServerGroup().getMultiServerGroups().size());
        }
        bindRes = bindresult == 0;
        return bindRes;
    }

    private static int oneBindAttempt(MVDHashMap aParams, String port, String aUsername, String aPassword, String secprot) {
        String server = (String)aParams.get("DS_SERVER");
        secprot = secprot == null ? "simple" : secprot;
        MVDLogger.Log("Binding to '" + server + "' port:" + port + " using secprot:" + secprot, 2);
        int res = 49;
        res = LDAPUtil.bindDirect(server, port, aUsername, aPassword, secprot);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static int bindDirect(String aServer, String aPort, String aUser, String aPassword, String aSecurityProtocol) {
        int n;
        InitialContext ctx;
        block13: {
            ctx = null;
            Hashtable<String, String> env = new Hashtable<String, String>(5, 0.75f);
            env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            env.put("java.naming.security.authentication", "simple");
            env.put("java.naming.provider.url", "ldap://" + aServer + ":" + aPort);
            env.put("java.naming.security.principal", aUser);
            env.put("java.naming.security.credentials", aPassword);
            if (aSecurityProtocol != null) {
                env.put("java.naming.security.protocol", aSecurityProtocol);
                if (aSecurityProtocol.equalsIgnoreCase("ssl")) {
                    env.put("java.naming.ldap.factory.socket", "com.sap.idm.vds.util.MxJNDISocketFactory");
                }
            }
            ctx = new InitialLdapContext(env, null);
            n = 0;
            Object var9_12 = null;
            if (ctx == null) break block13;
            try {
                ctx.close();
            }
            catch (NamingException k) {
                // empty catch block
            }
        }
        return n;
        catch (AuthenticationException ae) {
            int n2;
            block14: {
                n2 = 49;
                Object var9_13 = null;
                if (ctx == null) break block14;
                try {
                    ctx.close();
                }
                catch (NamingException k) {
                    // empty catch block
                }
            }
            return n2;
        }
        catch (NamingException e) {
            int n3;
            block15: {
                n3 = 52;
                Object var9_14 = null;
                if (ctx == null) break block15;
                {
                    catch (Throwable throwable) {
                        block16: {
                            Object var9_15 = null;
                            if (ctx == null) break block16;
                            try {
                                ctx.close();
                            }
                            catch (NamingException k) {}
                        }
                        throw throwable;
                    }
                }
                try {
                    ctx.close();
                }
                catch (NamingException k) {
                    // empty catch block
                }
            }
            return n3;
        }
    }

    public static boolean bind(String aServer, String aPort, String aUser, String aPassword) {
        return LDAPUtil.bindSecure(aServer, aPort, aUser, aPassword, null);
    }

    public static boolean bindSecure(String aServer, String aPort, String aUser, String aPassword, String aSecurityProtocol) {
        OneShutJNDI osj = new OneShutJNDI();
        return osj.TestBind(aServer, aPort, aUser, aPassword, aSecurityProtocol);
    }
}

