/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;

public class IniFile {
    File mFile;
    Hashtable sections = new Hashtable();
    private boolean isAlive = true;
    private Thread reloader;

    public IniFile() {
    }

    public IniFile(String filename) throws FileNotFoundException {
        this();
        this.load(filename);
    }

    public void setKeyValue(String section, String key, String value) {
        try {
            this.getSection(section).put(key.toLowerCase(), value);
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
    }

    public Hashtable getSections() {
        return this.sections;
    }

    public Hashtable getSection(String section) {
        return (Hashtable)this.sections.get(section.toLowerCase());
    }

    public boolean isNullOrEmpty(String section, String key) {
        String value = this.getKeyValue(section, key);
        return value == null || value.length() == 0;
    }

    public String getKeyValue(String section, String key) {
        try {
            return (String)this.getSection(section).get(key.toLowerCase());
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public String getKeyValue(String section, String key, String aDefaultValue) {
        try {
            String val = (String)this.getSection(section).get(key.toLowerCase());
            return val != null ? val : aDefaultValue;
        }
        catch (NullPointerException e) {
            return aDefaultValue;
        }
    }

    public int getKeyIntValue(String section, String key) {
        return this.getKeyIntValue(section, key, 0);
    }

    public int getKeyIntValue(String section, String key, int defaultValue) {
        String value = this.getKeyValue(section, key.toLowerCase());
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public String[][] getKeysAndValues(String aSection) {
        Hashtable section = this.getSection(aSection);
        if (section == null) {
            return null;
        }
        String[][] results = new String[section.size()][2];
        int i = 0;
        Enumeration f = section.keys();
        Enumeration g = section.elements();
        while (f.hasMoreElements()) {
            results[i][0] = (String)f.nextElement();
            results[i][1] = (String)g.nextElement();
            ++i;
        }
        return results;
    }

    public void load(String filename) throws FileNotFoundException {
        this.mFile = new File(filename);
        this.load(new FileInputStream(this.mFile));
        this.createReloader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() {
        Hashtable hashtable = this.sections;
        synchronized (hashtable) {
            Hashtable old = this.sections;
            this.sections = new Hashtable();
            try {
                this.load(this.mFile.getAbsolutePath());
            }
            catch (Exception e) {
                this.sections = old;
            }
        }
    }

    public void save(String filename) throws IOException {
        this.save(new FileOutputStream(filename));
    }

    private void load(InputStream in) {
        try {
            String read;
            BufferedReader input = new BufferedReader(new InputStreamReader(in));
            Hashtable<String, String> section = null;
            while ((read = input.readLine()) != null) {
                if (read.startsWith(";") || read.startsWith("#")) continue;
                if (read.startsWith("[")) {
                    String section_name = read.substring(1, read.indexOf("]")).toLowerCase();
                    section = (Hashtable<String, String>)this.sections.get(section_name);
                    if (section != null) continue;
                    section = new Hashtable<String, String>();
                    this.sections.put(section_name, section);
                    continue;
                }
                if (read.indexOf("=") == -1 || section == null) continue;
                String key = read.substring(0, read.indexOf("=")).trim().toLowerCase();
                String value = read.substring(read.indexOf("=") + 1).trim();
                section.put(key, value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void save(OutputStream out) {
        try {
            PrintWriter output = new PrintWriter(out);
            Enumeration e = this.sections.keys();
            while (e.hasMoreElements()) {
                String section = (String)e.nextElement();
                output.println("[" + section + "]");
                Enumeration f = this.getSection(section).keys();
                Enumeration g = this.getSection(section).elements();
                while (f.hasMoreElements()) {
                    output.println(f.nextElement() + "=" + g.nextElement());
                }
            }
            output.flush();
            output.close();
            out.flush();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addSection(String section) {
        this.sections.put(section.toLowerCase(), new Hashtable());
    }

    public void removeSection(String section) {
        this.sections.remove(section);
    }

    private void createReloader() {
        if (this.reloader != null) {
            try {
                this.reloader.interrupt();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.reloader = new Thread(){
            boolean mRunning = true;

            public void run() {
                long lastmodified = IniFile.this.mFile.lastModified();
                while (this.mRunning) {
                    try {
                        Thread.sleep(30000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (IniFile.this.mFile.lastModified() <= lastmodified) continue;
                    lastmodified = IniFile.this.mFile.lastModified();
                    IniFile.this.reload();
                }
            }

            public void interrupt() {
                this.mRunning = false;
                super.interrupt();
            }
        };
        this.reloader.start();
    }
}

