/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.util;

import com.sap.idm.vds.MVDHashMap;
import com.sap.idm.vds.MVDLogger;
import com.sap.idm.vds.MVDModAttrValues;
import com.sap.idm.vds.MVDOperationResult;
import com.sap.idm.vds.MVDSearchResultEntry;
import com.sap.idm.vds.MVDSearchResults;
import com.sap.idm.vds.MVDUtil;
import com.sap.idm.vds.config.MVDProxy;
import com.sun.jndi.ldap.ctl.PagedResultsControl;
import com.sun.jndi.ldap.ctl.PagedResultsResponseControl;
import java.io.IOException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.ServiceUnavailableException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;

public class HidedJNDIOperations {
    public static final String LDAP_ATTRIBUTES_BINARY = "java.naming.ldap.attributes.binary";
    private String mLdapVersion;
    private String mServer;
    private String mPort;
    private String mUser;
    private String mPassword;
    private String mSecurityProtocol;
    private String mAdditionalBinaryAttributes;
    boolean mCacheContexts = false;
    private String mConnectionKey;
    private MVDHashMap mCallerEngineGlobals;
    private NamingEnumeration ne = null;
    private DirContext mLdapContext = null;
    private int mBindLimit = -1;
    private NamingException mNamingException = null;

    private void CleanUp(boolean fromException) {
        try {
            if (this.ne != null) {
                this.ne.close();
            }
        }
        catch (NamingException e) {
            MVDLogger.Log("Naming exception: " + e.toString() + "/" + e.getRootCause(), 2);
        }
        try {
            if ((!this.mCacheContexts || fromException) && this.mLdapContext != null) {
                this.mLdapContext.close();
            }
        }
        catch (NamingException e) {
            MVDLogger.Log("Naming exception: " + e.toString() + "/" + e.getRootCause(), 2);
        }
    }

    private NamingEnumeration doSearch(String startingpoint, String urlfilter, SearchControls aConstraints) throws NamingException {
        NamingEnumeration<SearchResult> localNe = null;
        try {
            this.GetLdapContext();
            localNe = this.mLdapContext.search(startingpoint, urlfilter, aConstraints);
            return localNe;
        }
        catch (NamingException e) {
            MVDLogger.Log("do Search Exception: " + e.toString(), 2);
            if (e.getRootCause() instanceof IOException) {
                if (this.mCacheContexts) {
                    this.mCallerEngineGlobals.remove(this.mConnectionKey);
                }
                return null;
            }
            if (this.mCacheContexts) {
                this.mCallerEngineGlobals.remove(this.mConnectionKey);
            }
            throw e;
        }
    }

    public MVDSearchResults Search(String aServer, String aPort, String aUser, String aPassword, String startingpoint, int scope, Vector attr, String urlfilter, int szLimit, int tmLimit, String aSecurityProtocol, String aAdditionalBinaryAttributes, boolean aCacheConnections, MVDHashMap aCallerEngineGlobals) {
        int tLimit;
        this.mServer = aServer;
        this.mPort = aPort;
        this.mUser = aUser;
        this.mPassword = aPassword;
        if (aSecurityProtocol != null) {
            Vector v = MVDUtil.splitString(aSecurityProtocol, "::");
            String tmp = (String)v.elementAt(0);
            if (tmp.length() > 0) {
                this.mSecurityProtocol = tmp;
            }
            if (v.size() > 1 && (tmp = (String)v.elementAt(1)).length() > 0) {
                this.mLdapVersion = tmp;
            }
        } else {
            this.mSecurityProtocol = null;
            this.mLdapVersion = null;
        }
        this.mCacheContexts = aCacheConnections;
        this.mCallerEngineGlobals = aCallerEngineGlobals;
        this.mAdditionalBinaryAttributes = aAdditionalBinaryAttributes;
        MVDSearchResults result = new MVDSearchResults();
        SearchControls aConstraints = new SearchControls();
        if (attr.size() > 0) {
            String[] attrIDs = attr.toArray(new String[0]);
            aConstraints.setReturningAttributes(attrIDs);
        }
        aConstraints.setSearchScope(scope);
        aConstraints.setCountLimit(szLimit);
        if (tmLimit == 0) {
            tLimit = 0;
            this.mBindLimit = -1;
        } else {
            tLimit = tmLimit & 0xFFFF;
            this.mBindLimit = (tmLimit & 0xFFFF0000) >> 16;
            if (this.mBindLimit == 0) {
                this.mBindLimit = tLimit * 1000;
            }
        }
        aConstraints.setTimeLimit(tLimit * 1000);
        try {
            startingpoint = this.fixSlashInDN(startingpoint);
            this.ne = this.doSearch(startingpoint, urlfilter, aConstraints);
            if (this.ne == null) {
                if (this.mCacheContexts) {
                    this.ne = this.doSearch(startingpoint, urlfilter, aConstraints);
                    if (this.ne == null) {
                        result.setError(52, "Could not connect/reconnect to back-end");
                        this.CleanUp(true);
                        return result;
                    }
                } else {
                    result.setError(52, "Could not connect/reconnect to back-end");
                    this.CleanUp(true);
                    return result;
                }
            }
            result.putNamingEnumeration(this.ne, startingpoint, szLimit);
            result.setOK();
            this.CleanUp(false);
        }
        catch (NamingException e) {
            MVDLogger.Log("Naming exception: " + e.toString() + "/" + e.getRootCause(), 2);
            int aCode = result.PickTheNamingExceptionCode(e);
            result.setError(aCode, e.getMessage());
            this.CleanUp(true);
        }
        catch (Exception e) {
            MVDLogger.Log("Exception: " + e.getMessage(), 2);
            int aCode = 1;
            result.setError(aCode, e.getMessage());
            this.CleanUp(true);
        }
        return result;
    }

    static byte[] parseControls(Control[] controls) throws NamingException {
        byte[] cookie = null;
        if (controls != null) {
            for (int i = 0; i < controls.length; ++i) {
                PagedResultsResponseControl prrc = null;
                if (controls[i] instanceof PagedResultsResponseControl) {
                    prrc = (PagedResultsResponseControl)controls[i];
                    cookie = prrc.getCookie();
                    continue;
                }
                Control c = controls[i];
                if (!"1.2.840.113556.1.4.319".equals(c.getID())) continue;
                try {
                    prrc = new PagedResultsResponseControl(c.getID(), c.isCritical(), c.getEncodedValue());
                    cookie = prrc.getCookie();
                    continue;
                }
                catch (IOException ioe) {
                    return null;
                }
            }
        }
        return cookie == null ? new byte[]{} : cookie;
    }

    private MVDSearchResults doPagedSearch(String startingpoint, String urlfilter, SearchControls aConstraints, int aPageSize) throws NamingException {
        Object localNe = null;
        try {
            this.mLdapVersion = null;
            this.GetLdapContext();
            LdapContext localldapctx = null;
            if (!(this.mLdapContext instanceof LdapContext)) {
                MVDSearchResults res = new MVDSearchResults();
                res.setError(2, "Version not supported");
                return res;
            }
            localldapctx = (LdapContext)this.mLdapContext;
            byte[] cookie = null;
            Control[] ctls = null;
            ctls = new Control[]{new PagedResultsControl(aPageSize)};
            localldapctx.setRequestControls(ctls);
            MVDSearchResults totalResults = new MVDSearchResults();
            int totalfetched = 0;
            boolean bContinue = true;
            do {
                MVDSearchResults results = new MVDSearchResults();
                NamingEnumeration<SearchResult> ne = this.mLdapContext.search(startingpoint, urlfilter, aConstraints);
                results.putNamingEnumeration(ne, startingpoint, 0);
                totalResults.addAll(results);
                if (aConstraints.getCountLimit() > 0L && (long)(totalfetched += aPageSize) >= aConstraints.getCountLimit()) {
                    bContinue = false;
                }
                if (!bContinue) continue;
                cookie = HidedJNDIOperations.parseControls(localldapctx.getResponseControls());
                localldapctx.setRequestControls(new Control[]{new PagedResultsControl(aPageSize, cookie, true)});
            } while (cookie != null && cookie.length != 0 && bContinue);
            return totalResults;
        }
        catch (NamingException e) {
            MVDLogger.Log("do Search Exception: " + e.toString(), 2);
            if (this.mCacheContexts) {
                this.mCallerEngineGlobals.remove(this.mConnectionKey);
            }
            if (e.getRootCause() instanceof IOException) {
                return null;
            }
            throw e;
        }
        catch (Exception e) {
            MVDLogger.Log("do Search Exception: " + e.toString(), 2);
            if (this.mCacheContexts) {
                this.mCallerEngineGlobals.remove(this.mConnectionKey);
            }
            if (e instanceof IOException) {
                return null;
            }
            throw new NamingException();
        }
    }

    public MVDSearchResults PagedSearch(String aServer, String aPort, String aUser, String aPassword, String startingpoint, int scope, Vector attr, String urlfilter, int szLimit, int tmLimit, String aSecurityProtocol, String aAdditionalBinaryAttributes, boolean aCacheConnections, MVDHashMap aCallerEngineGlobals, int aPageSize) {
        int tLimit;
        this.mServer = aServer;
        this.mPort = aPort;
        this.mUser = aUser;
        this.mPassword = aPassword;
        if (aSecurityProtocol != null) {
            Vector v = MVDUtil.splitString(aSecurityProtocol, "::");
            String tmp = (String)v.elementAt(0);
            if (tmp.length() > 0) {
                this.mSecurityProtocol = tmp;
            }
            if (v.size() > 1 && (tmp = (String)v.elementAt(1)).length() > 0) {
                this.mLdapVersion = tmp;
            }
        } else {
            this.mSecurityProtocol = null;
            this.mLdapVersion = null;
        }
        this.mCacheContexts = aCacheConnections;
        this.mCallerEngineGlobals = aCallerEngineGlobals;
        this.mAdditionalBinaryAttributes = aAdditionalBinaryAttributes;
        MVDSearchResults result = new MVDSearchResults();
        SearchControls aConstraints = new SearchControls();
        if (attr.size() > 0) {
            String[] attrIDs = attr.toArray(new String[0]);
            aConstraints.setReturningAttributes(attrIDs);
        }
        aConstraints.setSearchScope(scope);
        aConstraints.setCountLimit(szLimit);
        if (tmLimit == 0) {
            tLimit = 0;
            this.mBindLimit = -1;
        } else {
            tLimit = tmLimit & 0xFFFF;
            this.mBindLimit = (tmLimit & 0xFFFF0000) >> 16;
            if (this.mBindLimit == 0) {
                this.mBindLimit = tLimit * 1000;
            }
        }
        aConstraints.setTimeLimit(tLimit * 1000);
        try {
            startingpoint = this.fixSlashInDN(startingpoint);
            MVDSearchResults sss = this.doPagedSearch(startingpoint, urlfilter, aConstraints, aPageSize);
            if (sss == null) {
                if (this.mCacheContexts) {
                    sss = this.doPagedSearch(startingpoint, urlfilter, aConstraints, aPageSize);
                    if (sss == null) {
                        result.setError(52, "Could not connect/reconnect to back-end");
                        this.CleanUp(true);
                        return result;
                    }
                } else {
                    result.setError(52, "Could not connect/reconnect to back-end");
                    this.CleanUp(true);
                    return result;
                }
            }
            result = sss;
            result.setOK();
            this.CleanUp(false);
        }
        catch (NamingException e) {
            MVDLogger.Log("Naming exception: " + e.toString() + "/" + e.getRootCause(), 2);
            int aCode = result.PickTheNamingExceptionCode(e);
            result.setError(aCode, e.getMessage());
            this.CleanUp(true);
        }
        catch (Exception e) {
            MVDLogger.Log("Exception: " + e.getMessage(), 2);
            int aCode = 1;
            result.setError(aCode, e.getMessage());
            this.CleanUp(true);
        }
        return result;
    }

    public MVDOperationResult Compare(String aServer, String aPort, String aUser, String aPassword, String startingpoint, String urlfilter, String aSecurityProtocol, boolean aCacheConnections, MVDHashMap aCallerEngineGlobals) {
        this.mServer = aServer;
        this.mPort = aPort;
        this.mUser = aUser;
        this.mPassword = aPassword;
        if (aSecurityProtocol != null) {
            Vector v = MVDUtil.splitString(aSecurityProtocol, "::");
            String tmp = (String)v.elementAt(0);
            if (tmp.length() > 0) {
                this.mSecurityProtocol = tmp;
            }
            if (v.size() > 1 && (tmp = (String)v.elementAt(1)).length() > 0) {
                this.mLdapVersion = tmp;
            }
        } else {
            this.mSecurityProtocol = null;
            this.mLdapVersion = null;
        }
        this.mCacheContexts = aCacheConnections;
        this.mCallerEngineGlobals = aCallerEngineGlobals;
        MVDOperationResult result = new MVDOperationResult();
        SearchControls aConstraints = new SearchControls();
        aConstraints.setReturningAttributes(new String[0]);
        aConstraints.setSearchScope(0);
        aConstraints.setCountLimit(0L);
        aConstraints.setTimeLimit(0);
        try {
            startingpoint = this.fixSlashInDN(startingpoint);
            this.ne = this.doSearch(startingpoint, urlfilter, aConstraints);
            if (this.ne == null) {
                if (this.mCacheContexts) {
                    this.ne = this.doSearch(startingpoint, urlfilter, aConstraints);
                    if (this.ne == null) {
                        result.setError(52, "Could not connect/reconnect to back-end");
                        this.CleanUp(true);
                        return result;
                    }
                } else {
                    result.setError(52, "Could not connect/reconnect to back-end");
                    this.CleanUp(true);
                    return result;
                }
            }
            MVDSearchResults tmpres = new MVDSearchResults();
            tmpres.putNamingEnumeration(this.ne, startingpoint);
            if (tmpres.size() > 0) {
                result.setOK();
            } else {
                result.setError(5, "");
            }
            this.CleanUp(false);
        }
        catch (NamingException e) {
            MVDLogger.Log("Naming exception: " + e.toString() + "/" + e.getRootCause(), 2);
            int aCode = result.PickTheNamingExceptionCode(e);
            result.setError(aCode, e.getMessage());
            this.CleanUp(true);
        }
        catch (Exception e) {
            MVDLogger.Log("Exception: " + e.getMessage(), 2);
            int aCode = 1;
            result.setError(aCode, e.getMessage());
            this.CleanUp(true);
        }
        return result;
    }

    private String fixSlashInDN(String startingpoint) {
        if (startingpoint.indexOf("/") >= 0) {
            startingpoint = MVDUtil.replace(startingpoint, "//", "pingeckekur");
            startingpoint = MVDUtil.replace(startingpoint, "pingeckekur/", "pajapatak");
            startingpoint = MVDUtil.replace(startingpoint, "/", "\\/");
            startingpoint = MVDUtil.replace(startingpoint, "pajapatak", "pingeckekur/");
            startingpoint = MVDUtil.replace(startingpoint, "pingeckekur", "//");
        }
        return startingpoint;
    }

    public String Lookup(String mServer, String mPort, String mUser, String mPassword, String startingpoint, int scope, String attrName, String urlfilter, String aSecurityProtocol, String aAdditionalBinaryAttributes, boolean aCacheConnections, MVDHashMap aCallerEngineGlobals) {
        MVDSearchResults result;
        Vector<String> attr = new Vector<String>();
        if (!attrName.equalsIgnoreCase("dn")) {
            attr.add(attrName);
        }
        if (!(result = this.Search(mServer, mPort, mUser, mPassword, startingpoint = this.fixSlashInDN(startingpoint), scope, attr, urlfilter, 2, 30, aSecurityProtocol, aAdditionalBinaryAttributes, aCacheConnections, aCallerEngineGlobals)).isOK()) {
            return null;
        }
        if (result.size() != 1) {
            return null;
        }
        MVDSearchResultEntry entry = (MVDSearchResultEntry)result.elementAt(0);
        if (attrName.equalsIgnoreCase("dn")) {
            return entry.getDn();
        }
        return entry.getFirstAttrValue(attrName);
    }

    public MVDOperationResult Modify(String aServer, String aPort, String aUser, String aPassword, String startingpoint, Vector attrNamesAndModValues, String aSecurityProtocol, String aAdditionalBinaryAttributes, boolean aCacheConnections, MVDHashMap aCallerEngineGlobals) {
        this.mServer = aServer;
        this.mPort = aPort;
        this.mUser = aUser;
        this.mPassword = aPassword;
        if (aSecurityProtocol != null) {
            Vector v = MVDUtil.splitString(aSecurityProtocol, "::");
            String tmp = (String)v.elementAt(0);
            if (tmp.length() > 0) {
                this.mSecurityProtocol = tmp;
            }
            if (v.size() > 1 && (tmp = (String)v.elementAt(1)).length() > 0) {
                this.mLdapVersion = tmp;
            }
        } else {
            this.mSecurityProtocol = null;
            this.mLdapVersion = null;
        }
        this.mCacheContexts = aCacheConnections;
        this.mCallerEngineGlobals = aCallerEngineGlobals;
        this.mAdditionalBinaryAttributes = aAdditionalBinaryAttributes;
        MVDOperationResult result = new MVDOperationResult();
        try {
            BasicAttributes bas = new BasicAttributes();
            BasicAttribute baOne = null;
            String attrName = "";
            Vector<ModificationItem> modifications = new Vector<ModificationItem>();
            int ls = attrNamesAndModValues.size();
            for (int i = 0; i < ls; ++i) {
                boolean isBin = false;
                MVDModAttrValues oneMvdMod = (MVDModAttrValues)attrNamesAndModValues.elementAt(i);
                attrName = oneMvdMod.getAttrName();
                baOne = new BasicAttribute(attrName);
                int t = oneMvdMod.size();
                for (int x = 0; x < t; ++x) {
                    baOne.add(oneMvdMod.elementAt(x));
                }
                int aType = oneMvdMod.getModType();
                if (aType == 0) {
                    aType = 1;
                } else if (aType == 1) {
                    aType = 3;
                }
                ModificationItem mi = new ModificationItem(aType, baOne);
                modifications.add(mi);
            }
            int ix = 0;
            ModificationItem[] m = new ModificationItem[modifications.size()];
            Iterator it = modifications.iterator();
            while (it.hasNext()) {
                m[ix++] = (ModificationItem)it.next();
            }
            String res = this.doModify(startingpoint = this.fixSlashInDN(startingpoint), m);
            if (res == null) {
                if (this.mCacheContexts) {
                    res = this.doModify(startingpoint, m);
                    if (res == null) {
                        result.setError(52, "Could not connect/reconnect to back-end");
                        return result;
                    }
                } else {
                    result.setError(52, "Could not connect/reconnect to back-end");
                    return result;
                }
            }
            result.setOK();
            this.CleanUp(false);
        }
        catch (NamingException ne) {
            MVDLogger.Log("Naming exception: " + ne.getMessage(), 2);
            int aCode = result.PickTheNamingExceptionCode(ne);
            result.setError(aCode, ne.getMessage());
            this.CleanUp(true);
        }
        catch (Exception ne) {
            MVDLogger.Log("Eexception: " + ne.getMessage(), 2);
            int aCode = 1;
            result.setError(aCode, ne.getMessage());
            this.CleanUp(true);
        }
        return result;
    }

    private String doModify(String startingpoint, ModificationItem[] m) throws NamingException {
        try {
            this.GetLdapContext();
            this.mLdapContext.modifyAttributes(startingpoint, m);
            return "whatever";
        }
        catch (NamingException e) {
            MVDLogger.Log("do Modify Exception " + e.toString(), 2);
            if (e.getRootCause() instanceof IOException) {
                if (this.mCacheContexts) {
                    this.mCallerEngineGlobals.remove(this.mConnectionKey);
                }
                return null;
            }
            if (this.mCacheContexts) {
                this.mCallerEngineGlobals.remove(this.mConnectionKey);
            }
            throw e;
        }
    }

    public MVDOperationResult Add(String aServer, String aPort, String aUser, String aPassword, String startingpoint, HashMap attrNamesAndValues, String aSecurityProtocol, String aAdditionalBinaryAttributes, boolean aCacheConnections, MVDHashMap aCallerEngineGlobals) {
        this.mServer = aServer;
        this.mPort = aPort;
        this.mUser = aUser;
        this.mPassword = aPassword;
        if (aSecurityProtocol != null) {
            Vector v = MVDUtil.splitString(aSecurityProtocol, "::");
            String tmp = (String)v.elementAt(0);
            if (tmp.length() > 0) {
                this.mSecurityProtocol = tmp;
            }
            if (v.size() > 1 && (tmp = (String)v.elementAt(1)).length() > 0) {
                this.mLdapVersion = tmp;
            }
        } else {
            this.mSecurityProtocol = null;
            this.mLdapVersion = null;
        }
        this.mCacheContexts = aCacheConnections;
        this.mCallerEngineGlobals = aCallerEngineGlobals;
        this.mAdditionalBinaryAttributes = aAdditionalBinaryAttributes;
        MVDOperationResult result = new MVDOperationResult();
        try {
            BasicAttributes bas = new BasicAttributes();
            BasicAttribute baOne = null;
            String attrName = "";
            Vector attrValue = null;
            Iterator ii = attrNamesAndValues.keySet().iterator();
            while (ii.hasNext()) {
                attrName = (String)ii.next();
                attrValue = (Vector)attrNamesAndValues.get(attrName);
                baOne = new BasicAttribute(attrName);
                int ls = attrValue.size();
                for (int x = 0; x < ls; ++x) {
                    baOne.add(attrValue.elementAt(x));
                }
                bas.put(baOne);
            }
            String res = this.doAdd(startingpoint = this.fixSlashInDN(startingpoint), bas);
            if (res == null) {
                if (this.mCacheContexts) {
                    res = this.doAdd(startingpoint, bas);
                    if (res == null) {
                        result.setError(52, "Could not connect/reconnect to back-end");
                        return result;
                    }
                } else {
                    result.setError(52, "Could not connect/reconnect to back-end");
                    return result;
                }
            }
            result.setOK();
            this.CleanUp(false);
        }
        catch (NamingException ne) {
            MVDLogger.Log("Naming exception: " + ne.getMessage(), 2);
            int aCode = result.PickTheNamingExceptionCode(ne);
            result.setError(aCode, ne.getMessage());
            this.CleanUp(true);
        }
        catch (Exception ne) {
            MVDLogger.Log("Exception: " + ne.getMessage(), 2);
            int aCode = 1;
            result.setError(aCode, ne.getMessage());
            this.CleanUp(true);
        }
        return result;
    }

    private String doAdd(String startingpoint, BasicAttributes bas) throws NamingException {
        try {
            this.GetLdapContext();
            this.mLdapContext.createSubcontext(startingpoint, (Attributes)bas);
            return "whatever";
        }
        catch (NamingException e) {
            MVDLogger.Log("do Add Exception: " + e.toString(), 2);
            if (e.getRootCause() instanceof IOException) {
                if (this.mCacheContexts) {
                    this.mCallerEngineGlobals.remove(this.mConnectionKey);
                }
                return null;
            }
            if (this.mCacheContexts) {
                this.mCallerEngineGlobals.remove(this.mConnectionKey);
            }
            throw e;
        }
    }

    public MVDOperationResult Delete(String aServer, String aPort, String aUser, String aPassword, String startingpoint, String aSecurityProtocol, boolean aCacheConnections, MVDHashMap aCallerEngineGlobals) {
        this.mServer = aServer;
        this.mPort = aPort;
        this.mUser = aUser;
        this.mPassword = aPassword;
        if (aSecurityProtocol != null) {
            Vector v = MVDUtil.splitString(aSecurityProtocol, "::");
            String tmp = (String)v.elementAt(0);
            if (tmp.length() > 0) {
                this.mSecurityProtocol = tmp;
            }
            if (v.size() > 1 && (tmp = (String)v.elementAt(1)).length() > 0) {
                this.mLdapVersion = tmp;
            }
        } else {
            this.mSecurityProtocol = null;
            this.mLdapVersion = null;
        }
        this.mCacheContexts = aCacheConnections;
        this.mCallerEngineGlobals = aCallerEngineGlobals;
        MVDOperationResult result = new MVDOperationResult();
        try {
            startingpoint = this.fixSlashInDN(startingpoint);
            String res = this.doDelete(startingpoint);
            if (res == null) {
                if (this.mCacheContexts) {
                    res = this.doDelete(startingpoint);
                    if (res == null) {
                        result.setError(52, "Could not connect/reconnect to back-end");
                        return result;
                    }
                } else {
                    result.setError(52, "Could not connect/reconnect to back-end");
                    return result;
                }
            }
            result.setOK();
            this.CleanUp(false);
        }
        catch (NamingException ne) {
            MVDLogger.Log("Naming exception: " + ne.getMessage(), 2);
            int aCode = result.PickTheNamingExceptionCode(ne);
            result.setError(aCode, ne.getMessage());
            this.CleanUp(true);
        }
        catch (Exception ne) {
            MVDLogger.Log("Exception: " + ne.getMessage(), 2);
            int aCode = 1;
            result.setError(aCode, ne.getMessage());
            this.CleanUp(true);
        }
        return result;
    }

    private String doDelete(String startingpoint) throws NamingException {
        try {
            this.GetLdapContext();
            this.mLdapContext.destroySubcontext(startingpoint);
            return "whatever";
        }
        catch (NamingException e) {
            MVDLogger.Log("do Delete Exception: " + e.toString(), 2);
            if (e.getRootCause() instanceof IOException) {
                if (this.mCacheContexts) {
                    this.mCallerEngineGlobals.remove(this.mConnectionKey);
                }
                return null;
            }
            if (this.mCacheContexts) {
                this.mCallerEngineGlobals.remove(this.mConnectionKey);
            }
            throw e;
        }
    }

    private void GetLdapContext() throws NamingException {
        if (this.mCacheContexts) {
            this.mConnectionKey = this.mServer + ":" + this.mPort + ":" + this.mUser + ":" + this.mPassword;
            MVDLogger.Log("Created connection key: " + this.mConnectionKey, 1);
            this.mLdapContext = (LdapContext)this.mCallerEngineGlobals.get(this.mConnectionKey);
            if (this.mLdapContext == null) {
                this.CreateLdapContext();
                this.mCallerEngineGlobals.put(this.mConnectionKey, this.mLdapContext);
            }
        } else {
            this.CreateLdapContext();
        }
    }

    private void CreateLdapContext() throws NamingException {
        Hashtable<String, String> env = new Hashtable<String, String>(5, 0.75f);
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.factory.control", "com.sun.jndi.ldap.ctl.ResponseControlFactory");
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.provider.url", "ldap://" + this.mServer + ":" + this.mPort);
        if (this.mUser == null) {
            this.mUser = "";
        }
        env.put("java.naming.security.principal", this.mUser);
        if (this.mPassword == null) {
            this.mPassword = "";
        }
        env.put("java.naming.security.credentials", this.mPassword);
        if (this.mSecurityProtocol != null && this.mSecurityProtocol.length() != 0 && !this.mSecurityProtocol.equalsIgnoreCase("simple")) {
            env.put("java.naming.security.protocol", this.mSecurityProtocol);
            env.put("java.naming.ldap.factory.socket", "com.sap.idm.vds.util.MxJNDISocketFactory");
        }
        if (this.mLdapVersion != null) {
            env.put("java.naming.ldap.version", this.mLdapVersion);
        }
        if (this.mAdditionalBinaryAttributes == null) {
            if (MVDProxy.JNDIBinaryAttr().length() > 0) {
                env.put(LDAP_ATTRIBUTES_BINARY, MVDProxy.JNDIBinaryAttr());
            }
        } else {
            if (this.mAdditionalBinaryAttributes.indexOf("REFFOLLOW") >= 0) {
                env.put("java.naming.referral", "follow");
            }
            if (this.mAdditionalBinaryAttributes.indexOf("DEREFALIASES_NEVER") >= 0) {
                env.put("java.naming.ldap.derefAliases", "never");
                MVDLogger.Log("Changed derefAliases to NEVER", 2);
            } else if (this.mAdditionalBinaryAttributes.indexOf("DEREFALIASES_FINDING") >= 0) {
                env.put("java.naming.ldap.derefAliases", "finding");
                MVDLogger.Log("Changed derefAliases to FINDING", 2);
            } else if (this.mAdditionalBinaryAttributes.indexOf("DEREFALIASES_SEARCHING") >= 0) {
                env.put("java.naming.ldap.derefAliases", "searching");
                MVDLogger.Log("Changed derefAliases to SEARCHING", 2);
            }
            if (MVDProxy.JNDIBinaryAttr().length() > 0) {
                env.put(LDAP_ATTRIBUTES_BINARY, MVDProxy.JNDIBinaryAttr() + " " + this.mAdditionalBinaryAttributes);
            } else {
                env.put(LDAP_ATTRIBUTES_BINARY, this.mAdditionalBinaryAttributes);
            }
        }
        if (this.mBindLimit == -1) {
            this.mLdapContext = this.mLdapVersion == null || this.mLdapVersion.equals("3") ? new InitialLdapContext(env, null) : new InitialDirContext(env);
        } else {
            this.mNamingException = null;
            TimerThread t1 = new TimerThread();
            t1.setEnv(env);
            t1.start();
            try {
                t1.join(this.mBindLimit);
                if (t1.isAlive()) {
                    t1.interrupt();
                    throw new ServiceUnavailableException("Timeout limit exceeded");
                }
                if (this.mNamingException != null) {
                    throw this.mNamingException;
                }
            }
            catch (InterruptedException e) {
                throw new ServiceUnavailableException("Timeout limit exceeded");
            }
        }
    }

    public static void main(String[] arr) {
        String startingpoint = "cn=kekur a/b, ou=koko";
        startingpoint = MVDUtil.replace(startingpoint, "//", "pingeckekur");
        startingpoint = MVDUtil.replace(startingpoint, "pingeckekur/", "pajapatak");
        startingpoint = MVDUtil.replace(startingpoint, "/", "\\/");
        startingpoint = MVDUtil.replace(startingpoint, "pajapatak", "pingeckekur/");
        startingpoint = MVDUtil.replace(startingpoint, "pingeckekur", "//");
    }

    class TimerThread
    extends Thread {
        Hashtable myEnv = null;

        TimerThread() {
        }

        public void setEnv(Hashtable env) {
            this.myEnv = env;
        }

        public void run() {
            try {
                if (HidedJNDIOperations.this.mLdapVersion == null || HidedJNDIOperations.this.mLdapVersion.equals("3")) {
                    HidedJNDIOperations.this.mLdapContext = new InitialLdapContext(this.myEnv, null);
                } else {
                    HidedJNDIOperations.this.mLdapContext = new InitialDirContext(this.myEnv);
                }
            }
            catch (NamingException e) {
                HidedJNDIOperations.this.mNamingException = e;
            }
        }
    }
}

