/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.util;

import com.sap.idm.vds.MVDGlobals;
import com.sap.idm.vds.MVDLogger;
import com.sap.idm.vds.MVDModAttrValues;
import com.sap.idm.vds.MVDUtil;
import com.sap.idm.vds.MVDUtilities;
import com.sap.idm.vds.message.MxAdd;
import com.sap.idm.vds.message.MxAttrSet;
import com.sap.idm.vds.message.MxBind;
import com.sap.idm.vds.message.MxDelete;
import com.sap.idm.vds.message.MxEntry;
import com.sap.idm.vds.message.MxModify;
import com.sap.idm.vds.message.MxRequest;
import com.sap.idm.vds.message.MxResponse;
import com.sap.idm.vds.message.MxResultCodes;
import com.sap.idm.vds.message.MxSearch;
import com.sap.idm.vds.util.Base64;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DSMLUtil {
    private static String mPatchingMode = "";

    public DSMLUtil() {
        mPatchingMode = MVDGlobals.getGlobalParameter("GLOBAL_UNDERLINE_PATCHING", "SAP");
    }

    public static MxRequest[] RequestTransform(Object aRequest, Object aSessionGlobals) {
        MxRequest[] MxReqs = null;
        Vector values = new Vector();
        HashMap sessionGlobals = (HashMap)aSessionGlobals;
        try {
            String DSMLRequest = null;
            String clientIP = null;
            if (aRequest instanceof String) {
                DSMLRequest = (String)aRequest;
            } else {
                DSMLRequest = ((HashMap)aRequest).get("MESSAGE").toString();
                clientIP = ((HashMap)aRequest).get("CLIENT_IP").toString();
            }
            if (DSMLRequest.indexOf("urn:oasis:names:tc:SPML:1:0") != -1) {
                sessionGlobals.put("TRANSFORMATIONERROR", "SPMLv1");
                MVDLogger.Log("Request type is SPML v1 and not supported by the service. To support SPML v1 requests deploy the web service with the MxSPMLTransformClass transformation class.", 7);
                return MxReqs;
            }
            if (DSMLRequest.indexOf("urn:oasis:names:tc:SPML:2:0") != -1) {
                sessionGlobals.put("TRANSFORMATIONERROR", "SPMLv2");
                MVDLogger.Log("Request type is SPML v2 and not supported by the service. To support SPML v2 requests deploy the web service with the MxSPMLv2_DSMLTranform transformation class.", 7);
                return MxReqs;
            }
            if (DSMLRequest.indexOf("urn:oasis:names:tc:DSML:2:0:core") == -1) {
                sessionGlobals.put("TRANSFORMATIONERROR", "UNDEFINED");
                MVDLogger.Log("Request type is not supported by the web service. Deploy the web service with a customized transformation class to solve the problem.", 7);
                return MxReqs;
            }
            Document DSMLRequestAsDOM = MVDUtilities.ConvertFromStringToDOM(DSMLRequest);
            Element topNode = DSMLRequestAsDOM.getDocumentElement();
            sessionGlobals.put(aRequest, values);
            Node batchRoot = topNode;
            String nodeName = null;
            nodeName = batchRoot.getLocalName();
            while (!nodeName.equalsIgnoreCase("batchRequest")) {
                batchRoot = batchRoot.getFirstChild();
                nodeName = batchRoot.getLocalName();
            }
            NodeList requestList = batchRoot.getChildNodes();
            MxReqs = new MxRequest[requestList.getLength()];
            for (int requestCounter = 0; requestCounter < requestList.getLength(); ++requestCounter) {
                Node requestNode = requestList.item(requestCounter);
                String requestName = requestNode.getLocalName();
                if (requestName == null) continue;
                if (requestName.equalsIgnoreCase("authRequest")) {
                    values = (Vector)sessionGlobals.get(aRequest);
                    values.add("AUTHREQUEST");
                    sessionGlobals.put(aRequest, values);
                    String userName = ((Element)requestNode).getAttribute("principal");
                    MxBind bind = new MxBind();
                    bind.setUserName(userName);
                    bind.setClientIP(clientIP);
                    String password = MVDGlobals.getGlobalParameter("PASSWORD", "");
                    bind.setPassword(password);
                    continue;
                }
                MxReqs[requestCounter] = DSMLUtil.RequestTransform(aRequest, requestNode, sessionGlobals);
            }
        }
        catch (Exception e) {
            MVDLogger.Debug("Error transforming request:\t" + e);
        }
        return MxReqs;
    }

    private static MxRequest RequestTransform(Object aOrgReq, Node aRequestNode, HashMap aSessionGlobals) {
        MxRequest request = null;
        try {
            Vector values = (Vector)aSessionGlobals.get(aOrgReq);
            String requestNodeName = aRequestNode.getLocalName();
            if (requestNodeName.equalsIgnoreCase("searchRequest")) {
                request = DSMLUtil.TransformSearchRequest(aRequestNode, aOrgReq, aSessionGlobals);
            } else if (requestNodeName.equalsIgnoreCase("delRequest")) {
                values.add("MxDelete");
                aSessionGlobals.put(aOrgReq, values);
                request = DSMLUtil.TransformDeleteRequest(aRequestNode);
            } else if (requestNodeName.equalsIgnoreCase("addRequest")) {
                values.add("MxAdd");
                aSessionGlobals.put(aOrgReq, values);
                request = DSMLUtil.TransformAddRequest(aRequestNode);
            } else if (requestNodeName.equalsIgnoreCase("modifyRequest")) {
                values.add("MxModify");
                aSessionGlobals.put(aOrgReq, values);
                request = DSMLUtil.TransformModifyRequest(aRequestNode);
            } else if (requestNodeName.equalsIgnoreCase("compareRequest")) {
                values.add("MxCompare");
                aSessionGlobals.put(aOrgReq, values);
                request = DSMLUtil.TransformCompareRequest(aRequestNode);
            }
        }
        catch (Exception e) {
            MVDLogger.Debug("Error transforming request:\t" + e);
        }
        return request;
    }

    private static MxSearch TransformCompareRequest(Node aCompareReqNode) {
        MxSearch modRequest = new MxSearch();
        try {
            String dn = ((Element)aCompareReqNode).getAttribute("dn");
            String string = DSMLUtil.GetLastNodeValue(aCompareReqNode, "value");
        }
        catch (Exception e) {
            MVDLogger.Debug("Error transforming compare request:\t" + e);
        }
        return null;
    }

    private static MxSearch TransformSearchRequest(Node aSearchReqNode, Object aOrgReq, HashMap aSessionGlobals) {
        String startPoint = null;
        String filter = null;
        MxSearch search = new MxSearch();
        Vector values = (Vector)aSessionGlobals.get(aOrgReq);
        Vector reqAttrs = new Vector();
        try {
            Element searchElem = (Element)aSearchReqNode;
            startPoint = searchElem.getAttribute("dn");
            String scope = searchElem.getAttribute("scope");
            String sizeLimit = searchElem.getAttribute("sizeLimit");
            String derefAliases = searchElem.getAttribute("derefAliases");
            search.setDerefAliases(DSMLUtil.MapDerefAliases(derefAliases));
            search.setStartingPoint(startPoint);
            search.setOperationScope(DSMLUtil.MapOperationScope(scope));
            try {
                search.setSizeLimit(Integer.parseInt(sizeLimit));
            }
            catch (NumberFormatException ne) {
                // empty catch block
            }
            NodeList childNodes = aSearchReqNode.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node childNode = childNodes.item(i);
                String childName = childNode.getLocalName();
                if (childName == null) continue;
                if (childName.equalsIgnoreCase("filter")) {
                    Node filterNode = childNode;
                    if (filterNode.hasChildNodes()) {
                        Node filterChildNode = filterNode.getFirstChild();
                        while (filterChildNode.getLocalName() == null) {
                            filterChildNode = filterChildNode.getNextSibling();
                        }
                        filter = DSMLUtil.GetFilterAsString(filterChildNode);
                    }
                    search.setRequestedFilter(filter);
                    continue;
                }
                if (!childName.equalsIgnoreCase("attributes")) continue;
                reqAttrs = DSMLUtil.GetReqAttrsAsVector(childNode.getChildNodes());
                search.setRequestedAttributes(reqAttrs);
            }
            if (reqAttrs != null && !reqAttrs.isEmpty()) {
                values.add(reqAttrs);
            } else {
                values.add("MxSearch");
            }
            aSessionGlobals.put(aOrgReq, values);
        }
        catch (Exception e) {
            MVDLogger.Debug("Error transforming search request:\t" + e);
        }
        return search;
    }

    private static int MapOperationScope(String aOperScope) {
        if (aOperScope.equalsIgnoreCase("baseObject")) {
            return 0;
        }
        if (aOperScope.equalsIgnoreCase("singleLevel")) {
            return 1;
        }
        return 2;
    }

    private static int MapDerefAliases(String aDerefAliases) {
        if (aDerefAliases.equalsIgnoreCase("neverDerefAliases")) {
            return 0;
        }
        if (aDerefAliases.equalsIgnoreCase("derefInSearching")) {
            return 1;
        }
        if (aDerefAliases.equalsIgnoreCase("derefFindingBaseObj")) {
            return 2;
        }
        return 3;
    }

    public static String GetFilterAsString(Node aFilterNode) {
        String filter = "";
        try {
            String filterNodeName = aFilterNode.getLocalName();
            System.out.println("filterNodeName: " + filterNodeName);
            if (filterNodeName.equalsIgnoreCase("and")) {
                NodeList filterElements = aFilterNode.getChildNodes();
                for (int filterElemCounter = 0; filterElemCounter < filterElements.getLength(); ++filterElemCounter) {
                    Node childFilterElem = filterElements.item(filterElemCounter);
                    if (childFilterElem.getNodeType() == 3) continue;
                    Node filterElement = filterElements.item(filterElemCounter);
                    String filterElemAsString = DSMLUtil.GetFilterAsString(filterElement);
                    filter = filter + filterElemAsString;
                }
                filter = "(&" + filter + ")";
            } else if (filterNodeName.equalsIgnoreCase("or")) {
                NodeList filterElements = aFilterNode.getChildNodes();
                for (int filterElemCounter = 0; filterElemCounter < filterElements.getLength(); ++filterElemCounter) {
                    Node childFilterElem = filterElements.item(filterElemCounter);
                    if (childFilterElem.getNodeType() == 3) continue;
                    Node filterElement = filterElements.item(filterElemCounter);
                    String filterElemAsString = DSMLUtil.GetFilterAsString(filterElement);
                    filter = filter + filterElemAsString;
                }
                filter = "(|" + filter + ")";
            } else if (filterNodeName.equalsIgnoreCase("not")) {
                NodeList filterElements = aFilterNode.getChildNodes();
                for (int filterElemCounter = 0; filterElemCounter < filterElements.getLength(); ++filterElemCounter) {
                    Node childFilterElem = filterElements.item(filterElemCounter);
                    if (childFilterElem.getNodeType() == 3) continue;
                    Node filterElement = filterElements.item(filterElemCounter);
                    String filterElemAsString = DSMLUtil.GetFilterAsString(filterElement);
                    filter = filter + filterElemAsString;
                }
                filter = "(!" + filter + ")";
            } else {
                filter = "(" + DSMLUtil.CreateFilterElement(aFilterNode) + ")";
            }
            return filter;
        }
        catch (Exception e) {
            MVDLogger.Debug("Error creating search filter from request:\t" + e);
            return null;
        }
    }

    private static boolean containsMxDashAttrs(String aSource) {
        if (aSource == null) {
            return false;
        }
        return mPatchingMode.equalsIgnoreCase("SAP") ? aSource.startsWith("MXREF-") || aSource.startsWith("mxref-") || aSource.startsWith("MXMEMBER-") || aSource.startsWith("mxmember-") || aSource.startsWith("MX-") || aSource.startsWith("mx-") : aSource.indexOf("-") >= 0;
    }

    private static String CreateFilterElement(Node aFilterElement) {
        String filterElem = null;
        try {
            String key = ((Element)aFilterElement).getAttribute("name");
            if (DSMLUtil.containsMxDashAttrs(key)) {
                MVDLogger.Debug("Attribute name before patching " + key);
                key = MVDUtil.replace(key, "-", "_");
                MVDLogger.Debug("Attribute name after patching " + key);
            }
            String filterElemName = aFilterElement.getLocalName();
            System.out.println("CreateFilterElemt key " + key + " filterElemName: " + filterElemName);
            if (filterElemName.equalsIgnoreCase("present")) {
                filterElem = key + "=*";
            } else if (filterElemName.equalsIgnoreCase("not")) {
                filterElem = "!(" + key + "=*)";
            } else if (filterElemName.equalsIgnoreCase("equalityMatch") || filterElemName.equalsIgnoreCase("approxMatch")) {
                filterElem = key + '=' + DSMLUtil.GetLastNodeValue(aFilterElement, "value");
            } else if (filterElemName.equalsIgnoreCase("substrings")) {
                String filterVal = "";
                NodeList lll = aFilterElement.getChildNodes();
                for (int ix = 0; ix < lll.getLength(); ++ix) {
                    Node subNode = lll.item(ix);
                    String subNodeName = subNode.getLocalName();
                    if (subNodeName == null) continue;
                    filterVal = subNodeName.equalsIgnoreCase("initial") ? filterVal + DSMLUtil.GetLastNodeValue(subNode, subNodeName) + '*' : (subNodeName.equalsIgnoreCase("final") ? filterVal + "*" + DSMLUtil.GetLastNodeValue(subNode, subNodeName) : filterVal + "*" + DSMLUtil.GetLastNodeValue(subNode, subNodeName) + '*');
                }
                filterVal = MVDUtil.replace(filterVal, "**", "*");
                filterElem = key + "=" + filterVal;
            } else if (filterElemName.equalsIgnoreCase("greaterOrEqual")) {
                filterElem = key + ">=" + DSMLUtil.GetLastNodeValue(aFilterElement, "value");
            } else if (filterElemName.equalsIgnoreCase("lessOrEqual")) {
                filterElem = key + "<=" + DSMLUtil.GetLastNodeValue(aFilterElement, "value");
            }
        }
        catch (Exception e) {
            MVDLogger.Debug("Error creating search filter from request:\t" + e);
        }
        return filterElem;
    }

    private static MxAdd TransformAddRequest(Node aAddReqNode) {
        MxAdd add = new MxAdd();
        try {
            String dn = ((Element)aAddReqNode).getAttribute("dn");
            add.setDn(dn);
            HashMap reqAttrs = new HashMap();
            NodeList childNodes = aAddReqNode.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node childNode = childNodes.item(i);
                String childName = childNode.getLocalName();
                if (childName == null || !childName.equalsIgnoreCase("attr")) continue;
                String attrName = ((Element)childNode).getAttribute("name").toLowerCase();
                System.out.println("AttrName: " + attrName);
                Vector<Object> values = new Vector<Object>();
                NodeList valueNodes = childNode.getChildNodes();
                for (int valueCounter = 0; valueCounter < valueNodes.getLength(); ++valueCounter) {
                    Node valueNode = valueNodes.item(valueCounter);
                    if (valueNode.getNodeType() == 3) continue;
                    Object value = DSMLUtil.GetValue(valueNode);
                    if (value instanceof String) {
                        value = DSMLUtil.ReverseMapIllegalXMLChars((String)value);
                    }
                    values.add(value);
                    System.out.println("value: " + value);
                }
                reqAttrs.put(attrName, values);
            }
            add.setAttrSetAndValues(new MxAttrSet(reqAttrs));
            Iterator iterator = reqAttrs.keySet().iterator();
            while (iterator.hasNext()) {
                String value = iterator.next().toString();
                Vector values = (Vector)reqAttrs.get(value);
                System.out.println("NAME IS: " + value);
                for (int j = 0; j < values.size(); ++j) {
                    System.out.println("Value: " + values.get(j).toString());
                }
            }
        }
        catch (Exception e) {
            MVDLogger.Debug("Error transforming add request:\t" + e);
        }
        return add;
    }

    private static MxModify TransformModifyRequest(Node aModReqNode) {
        MxModify modify = new MxModify();
        try {
            String dn = ((Element)aModReqNode).getAttribute("dn");
            modify.setDn(dn);
            Vector<MVDModAttrValues> modifications = new Vector<MVDModAttrValues>();
            NodeList childNodes = aModReqNode.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node childNode = childNodes.item(i);
                String childName = childNode.getLocalName();
                if (childName == null || !childName.equalsIgnoreCase("modification")) continue;
                String modName = ((Element)childNode).getAttribute("name");
                String modOperation = ((Element)childNode).getAttribute("operation");
                System.out.println("Modify attribute: " + modName + " Operation: " + modOperation);
                if (modOperation == null) {
                    modOperation = "add";
                }
                MVDModAttrValues modification = new MVDModAttrValues();
                modification.setAttrName(modName);
                modification.setModType(DSMLUtil.mapOperation(modOperation));
                NodeList modValues = childNode.getChildNodes();
                for (int subModCounter = 0; subModCounter < modValues.getLength(); ++subModCounter) {
                    Node modValue = modValues.item(subModCounter);
                    if (modValue.getNodeType() == 3) continue;
                    Object value = DSMLUtil.GetValue(modValue);
                    if (value instanceof String) {
                        value = DSMLUtil.ReverseMapIllegalXMLChars((String)value);
                    }
                    modification.add(value);
                }
                modifications.add(modification);
            }
            modify.setAttrAndModValues(modifications);
        }
        catch (Exception e) {
            MVDLogger.Debug("Error transforming modify request:\t" + e);
        }
        return modify;
    }

    private static MxDelete TransformDeleteRequest(Node aDelReqNode) {
        MxDelete delete = new MxDelete();
        try {
            String dn = ((Element)aDelReqNode).getAttribute("dn");
            delete.setDn(dn);
        }
        catch (Exception e) {
            MVDLogger.Debug("Error transforming delete request:\t" + e);
        }
        return delete;
    }

    private static String GetLastNodeValue(Node aStartNode, String aTagName) {
        String nodeValue = null;
        boolean isNodeFound = false;
        Node node = aStartNode;
        try {
            while (!isNodeFound) {
                if (node.getLocalName() == null) {
                    node = node.getNextSibling();
                    continue;
                }
                if (node.getLocalName().equalsIgnoreCase(aTagName)) {
                    isNodeFound = true;
                }
                node = node.getFirstChild();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (node == null) {
            return "";
        }
        nodeValue = node.getNodeValue();
        return nodeValue;
    }

    private static Vector GetReqAttrsAsVector(NodeList aReqAttrNodes) {
        Vector<String> reqAttrs = new Vector<String>();
        try {
            for (int i = 0; i < aReqAttrNodes.getLength(); ++i) {
                String attr;
                Node reqAttr = aReqAttrNodes.item(i);
                if (reqAttr.getNodeType() == 3 || (attr = ((Element)aReqAttrNodes.item(i)).getAttribute("name").toLowerCase()).equalsIgnoreCase("*")) continue;
                reqAttrs.add(attr);
            }
        }
        catch (Exception e) {
            MVDLogger.Debug("Error getting requeste attributes as a vector:\t" + e);
        }
        return reqAttrs;
    }

    public static Object GetValue(Node aValueNode) {
        Object value = null;
        try {
            Node firstchild = aValueNode.getFirstChild();
            if (firstchild == null) {
                value = "";
            } else {
                value = firstchild.getNodeValue();
                String type = ((Element)aValueNode).getAttribute("type");
                if (type != null && (type.equalsIgnoreCase("xsd:base64Binary") || type.equalsIgnoreCase("base64Binary"))) {
                    value = Base64.decode((String)value);
                }
            }
        }
        catch (Exception e) {
            MVDLogger.Debug("Error getting type of valuenode:\t" + e);
        }
        return value;
    }

    public static Node GetValue(Document aResponse, Object aRetObject) {
        Element valueNode = aResponse.createElement("dsml:value");
        try {
            String value = "";
            if (aRetObject instanceof String) {
                byte[] retArray = ((String)aRetObject).getBytes();
                boolean isActuallyBinary = false;
                for (int i = 0; i < retArray.length; ++i) {
                    if (retArray[i] >= 32 || retArray[i] == 10 || retArray[i] == 13) continue;
                    isActuallyBinary = true;
                    break;
                }
                if (isActuallyBinary) {
                    valueNode.setAttribute("type", "xsd:base64Binary");
                    value = Base64.encode(retArray);
                } else {
                    value = DSMLUtil.MapIllegalXMLChars(value);
                    valueNode.setAttribute("type", "xsd:string");
                    value = aRetObject.toString();
                }
            } else {
                valueNode.setAttribute("type", "xsd:base64Binary");
                byte[] retArray = (byte[])aRetObject;
                value = Base64.encode(retArray);
            }
            valueNode.appendChild(aResponse.createTextNode(value));
        }
        catch (Exception e) {
            MVDLogger.Debug("Error getting type of valuenode:\t" + e);
        }
        return valueNode;
    }

    public static String ReverseMapIllegalXMLChars(String aString) {
        HashMap<String, String> mappings = new HashMap<String, String>();
        mappings.put("&lt;", "<");
        mappings.put("&gt;", ">");
        mappings.put("&amp;", "&");
        mappings.put("&apos;", "'");
        mappings.put("&quot;", "\"");
        char[] mappedStringAsChar = aString.toCharArray();
        int indexCounter = 0;
        for (indexCounter = mappedStringAsChar.length - 1; indexCounter >= 0; --indexCounter) {
            if (mappedStringAsChar[indexCounter] != '&') continue;
            String key = "";
            for (int i = indexCounter; i < mappedStringAsChar.length; ++i) {
                String mapval;
                if (mappedStringAsChar[i] != ';' || (mapval = (String)mappings.get(key = aString.substring(indexCounter, i + 1))) == null) continue;
                aString = aString.substring(0, indexCounter) + mapval + aString.substring(indexCounter + key.length(), aString.length());
                mappedStringAsChar = aString.toCharArray();
            }
        }
        return aString;
    }

    public static String MapIllegalXMLChars(String aString) {
        HashMap<String, String> mappings = new HashMap<String, String>();
        mappings.put("<", "&lt;");
        mappings.put(">", "&gt;");
        mappings.put("&", "&amp;");
        mappings.put("'", "&apos;");
        mappings.put("\"", "&quot;");
        try {
            char[] mappedStringAsChar;
            int indexCounter = 0;
            block2: do {
                mappedStringAsChar = aString.toCharArray();
                for (indexCounter = 0; indexCounter < mappedStringAsChar.length; ++indexCounter) {
                    if (mappedStringAsChar[indexCounter] != '&' || DSMLUtil.IsAmpLegal(aString, indexCounter, mappings)) continue;
                    aString = DSMLUtil.FormatLegalString(aString, indexCounter, "&", mappings);
                    continue block2;
                }
            } while (!DSMLUtil.IsStringLegal(aString, mappings));
            block4: do {
                mappedStringAsChar = aString.toCharArray();
                for (indexCounter = 0; indexCounter < mappedStringAsChar.length; ++indexCounter) {
                    if (mappedStringAsChar[indexCounter] != '<' && mappedStringAsChar[indexCounter] != '>' && !String.valueOf(mappedStringAsChar[indexCounter]).equalsIgnoreCase("'") && mappedStringAsChar[indexCounter] != '\"') continue;
                    String key = String.valueOf(mappedStringAsChar[indexCounter]);
                    aString = DSMLUtil.FormatLegalString(aString, indexCounter, key, mappings);
                    continue block4;
                }
            } while (!DSMLUtil.IsStringLegal(aString));
        }
        catch (Exception e) {
            MVDLogger.Debug("Error mapping illegal characters:" + e);
        }
        return aString;
    }

    private static String FormatLegalString(String aString, int aIndex, String aKey, HashMap aMappings) {
        if (aIndex != 0) {
            return aString.substring(0, aIndex) + aMappings.get(aKey) + aString.substring(aIndex + 1, aString.length());
        }
        return aMappings.get(aKey) + aString.substring(aIndex + 1, aString.length());
    }

    private static boolean IsStringLegal(String aMappedString) {
        return aMappedString.indexOf(60) < 0 && aMappedString.indexOf(62) < 0 && aMappedString.indexOf("'") < 0 && aMappedString.indexOf(34) < 0;
    }

    private static boolean IsStringLegal(String aMappedString, HashMap aMappings) {
        try {
            char[] mappedStringAsChar = aMappedString.toCharArray();
            for (int indexCounter = 0; indexCounter < mappedStringAsChar.length; ++indexCounter) {
                if (mappedStringAsChar[indexCounter] != '&' || DSMLUtil.IsAmpLegal(aMappedString, indexCounter, aMappings)) continue;
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    private static boolean IsAmpLegal(String aMappedString, int aIndexReached, HashMap aMappings) {
        try {
            char[] mappedStringAsChar = aMappedString.toCharArray();
            for (int indexCounter = aIndexReached; indexCounter < mappedStringAsChar.length; ++indexCounter) {
                if (mappedStringAsChar[indexCounter] != ';') continue;
                String subString = aMappedString.substring(aIndexReached, indexCounter + 1);
                return aMappings.containsValue(subString);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static Object ResponseTransform(MxResponse[] aResponses, Object aOrgReq, Object aSessionGlobals) {
        HashMap sessionGlobals = (HashMap)aSessionGlobals;
        if (sessionGlobals.containsKey("TRANSFORMATIONERROR")) {
            return "TRANSFORMATIONERROR_DSML";
        }
        Vector values = (Vector)sessionGlobals.get(aOrgReq);
        Node respNode = null;
        try {
            Document DSMLRespons = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element respRoot = DSMLRespons.createElement("dsml:batchResponse");
            for (int i = 0; i < aResponses.length; ++i) {
                MxResponse respons = aResponses[i];
                Object reqObj = values.get(i);
                respNode = DSMLUtil.ResponseTransform(respons, aOrgReq, reqObj, DSMLRespons);
                respRoot.appendChild(respNode);
            }
            respRoot.setAttribute("elementFormDefault", "qualified");
            respRoot.setAttribute("xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
            respRoot.setAttribute("xmlns:dsml", "urn:oasis:names:tc:DSML:2:0:core");
            DSMLRespons.appendChild(respRoot);
            sessionGlobals.remove(aResponses);
            return MVDUtilities.ConvertFromDOMToString(DSMLRespons);
        }
        catch (Exception e) {
            MVDLogger.Debug("Error transforming response:\t" + e);
            return null;
        }
    }

    private static Node ResponseTransform(MxResponse aResponse, Object aOrgReq, Object aReqObj, Document aDSMLRequest) {
        Node respNode = null;
        try {
            if (aReqObj instanceof Vector) {
                Vector reqAttr = (Vector)aReqObj;
                if (reqAttr.size() == 1) {
                    reqAttr = new Vector();
                }
                respNode = DSMLUtil.TransformSearchRespons(aResponse, reqAttr, aDSMLRequest);
            } else {
                String reqTypeName = (String)aReqObj;
                int reqType = -1;
                if (reqTypeName.equalsIgnoreCase("MxSearch")) {
                    return DSMLUtil.TransformSearchRespons(aResponse, new Vector(), aDSMLRequest);
                }
                if (reqTypeName.equalsIgnoreCase("MxAdd")) {
                    reqType = 0;
                } else if (reqTypeName.equalsIgnoreCase("MxDelete")) {
                    reqType = 1;
                } else if (reqTypeName.equalsIgnoreCase("MxModify")) {
                    reqType = 2;
                } else if (reqTypeName.equalsIgnoreCase("MxCompare")) {
                    reqType = 3;
                }
                respNode = DSMLUtil.TransformRespons(aResponse, reqType, aDSMLRequest);
            }
        }
        catch (Exception e) {
            MVDLogger.Debug("Error transforming response:\t" + e);
            return null;
        }
        return respNode;
    }

    private static Node TransformSearchRespons(MxResponse aRespons, Vector aReqAttrs, Document aDSMLRequest) {
        Element topNode;
        block11: {
            topNode = null;
            try {
                topNode = aDSMLRequest.createElement("dsml:searchResponse");
                Element searchResultNode = aDSMLRequest.createElement("searchResultDone");
                Element resultCode = aDSMLRequest.createElement("resultCode");
                resultCode.setAttribute("code", Integer.toString(aRespons.getCode()));
                resultCode.setAttribute("desc", MxResultCodes.toString(aRespons.getCode()));
                searchResultNode.appendChild(resultCode);
                String errorMessage = aRespons.getMessage();
                if (errorMessage != null && !errorMessage.equalsIgnoreCase("")) {
                    Element errorMessageNode = aDSMLRequest.createElement("errorMessage");
                    errorMessageNode.appendChild(aDSMLRequest.createTextNode(errorMessage));
                    searchResultNode.appendChild(errorMessageNode);
                }
                topNode.appendChild(searchResultNode);
                if (!aRespons.isOK()) break block11;
                for (int entryCounter = 0; entryCounter < aRespons.size(); ++entryCounter) {
                    Node valueNode;
                    Object retObj;
                    int valueCount;
                    Vector returnedValues;
                    Element attrNode;
                    String key;
                    MxEntry entry = aRespons.getEntry(entryCounter);
                    Element entryTopNode = aDSMLRequest.createElement("searchResultEntry");
                    topNode.appendChild(entryTopNode);
                    entryTopNode.setAttribute("dn", entry.getDn());
                    HashMap returnedAttrs = entry.getAttrAndValues();
                    if (returnedAttrs == null || returnedAttrs.isEmpty()) continue;
                    if (aReqAttrs != null && !aReqAttrs.isEmpty()) {
                        for (int attrCounter = 0; attrCounter < aReqAttrs.size(); ++attrCounter) {
                            key = aReqAttrs.get(attrCounter).toString();
                            attrNode = aDSMLRequest.createElement("dsml:attr");
                            attrNode.setAttribute("name", key);
                            if (returnedAttrs.containsKey(key) && !(returnedValues = (Vector)returnedAttrs.get(key)).isEmpty()) {
                                for (valueCount = 0; valueCount < returnedValues.size(); ++valueCount) {
                                    retObj = returnedValues.get(valueCount);
                                    valueNode = DSMLUtil.GetValue(aDSMLRequest, retObj);
                                    attrNode.appendChild(valueNode);
                                }
                            }
                            entryTopNode.appendChild(attrNode);
                        }
                        continue;
                    }
                    Iterator attrCounter = returnedAttrs.keySet().iterator();
                    while (attrCounter.hasNext()) {
                        key = attrCounter.next().toString();
                        attrNode = aDSMLRequest.createElement("dsml:attr");
                        attrNode.setAttribute("name", key);
                        if (returnedAttrs.containsKey(key) && !(returnedValues = (Vector)returnedAttrs.get(key)).isEmpty()) {
                            for (valueCount = 0; valueCount < returnedValues.size(); ++valueCount) {
                                retObj = returnedValues.get(valueCount);
                                valueNode = DSMLUtil.GetValue(aDSMLRequest, retObj);
                                attrNode.appendChild(valueNode);
                                attrNode.appendChild(valueNode);
                            }
                        }
                        entryTopNode.appendChild(attrNode);
                    }
                }
            }
            catch (Exception e) {
                MVDLogger.Debug("Error mapping respons to DOM object: " + e);
            }
        }
        return topNode;
    }

    private static Node TransformRespons(MxResponse aRespons, int aReqType, Document aDSMLRequest) {
        Element topNode = null;
        try {
            switch (aReqType) {
                case 0: {
                    topNode = aDSMLRequest.createElement("dsml:addResponse");
                    break;
                }
                case 1: {
                    topNode = aDSMLRequest.createElement("dsml:deleteResponse");
                    break;
                }
                case 2: {
                    topNode = aDSMLRequest.createElement("dsml:modifyResponse");
                    break;
                }
                case 3: {
                    topNode = aDSMLRequest.createElement("dsml:compareResponse");
                }
            }
            Element resultCode = aDSMLRequest.createElement("resultCode");
            resultCode.setAttribute("code", Integer.toString(aRespons.getCode()));
            resultCode.setAttribute("desc", MxResultCodes.toString(aRespons.getCode()));
            topNode.appendChild(resultCode);
            String errorMessage = aRespons.getMessage();
            if (errorMessage != null && !errorMessage.equalsIgnoreCase("")) {
                Element errorMessageNode = aDSMLRequest.createElement("errorMessage");
                errorMessageNode.appendChild(aDSMLRequest.createTextNode(errorMessage));
                topNode.appendChild(errorMessageNode);
            }
        }
        catch (Exception e) {
            MVDLogger.Debug("Error mapping respons to DOM object: " + e);
        }
        return topNode;
    }

    private static int mapOperation(String aOperation) {
        if (aOperation.equalsIgnoreCase("add")) {
            return 0;
        }
        if (aOperation.equalsIgnoreCase("delete")) {
            return 1;
        }
        if (aOperation.equalsIgnoreCase("replace")) {
            return 2;
        }
        return -1;
    }

    public static void main(String[] args) {
        String testString = "&'<>\"";
        String testString2 = "&gt;&<&lt;";
        String testString3 = "&g<t;&<&\"lt;&";
        System.out.println(testString2 + " -> " + DSMLUtil.ReverseMapIllegalXMLChars(testString2));
        System.out.println(testString3 + " -> " + DSMLUtil.ReverseMapIllegalXMLChars(testString3));
    }
}

