/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.snmp;

import com.sap.idm.vds.snmp.Asn1Object;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;

class Asn1Sequence
extends Asn1Object {
    private Vector mChildren;

    Asn1Sequence() {
        this(48);
    }

    Asn1Sequence(byte aTag) {
        this.setTag(aTag);
        this.mChildren = new Vector(1, 1);
    }

    public String toString() {
        return "";
    }

    Asn1Object add(Asn1Object aChild) {
        this.mChildren.addElement(aChild);
        return aChild;
    }

    int size() {
        Enumeration childList = this.mChildren.elements();
        int sz = 0;
        while (childList.hasMoreElements()) {
            int cnt = ((Asn1Object)childList.nextElement()).size();
            cnt += 1 + this.getLengthBytes(cnt);
            sz += cnt;
        }
        return sz;
    }

    void write(OutputStream aOutputStream) throws IOException {
        this.write(aOutputStream, 0);
    }

    void write(OutputStream aOutputStream, int aOffset) throws IOException {
        int length = this.size();
        this.setStartPos(aOffset);
        this.Asn1BuildHeader(aOutputStream, this.getTag(), length);
        aOffset += this.getHeaderLength();
        Enumeration childList = this.mChildren.elements();
        while (childList.hasMoreElements()) {
            Asn1Object child = (Asn1Object)childList.nextElement();
            child.write(aOutputStream, aOffset);
            child.setStartPos(aOffset);
            aOffset += child.getHeaderLength() + child.getContentsLength();
        }
    }

    Asn1Object getObj(int aOffset) {
        Asn1Object res = null;
        try {
            res = (Asn1Object)this.mChildren.elementAt(aOffset);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return res;
    }

    int getObjCount() {
        return this.mChildren.size();
    }
}

