/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.snmp;

import com.sap.idm.vds.snmp.Asn1Object;
import com.sap.idm.vds.snmp.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Asn1OctetString
extends Asn1Object {
    private byte[] mValue;

    public Asn1OctetString(char[] aChars) {
        this.mValue = new byte[aChars.length];
        this.setTag((byte)4);
        for (int idx = 0; idx < aChars.length; ++idx) {
            this.mValue[idx] = (byte)aChars[idx];
        }
    }

    public Asn1OctetString(String aString) {
        this(aString.toCharArray());
    }

    public Asn1OctetString(byte[] aBytes) {
        this(aBytes, 4);
    }

    public Asn1OctetString(byte[] aBytes, byte aTag) throws IllegalArgumentException {
        this.mValue = aBytes;
        this.setTag(aTag);
        if (this.mValue == null) {
            throw new IllegalArgumentException("Value is null");
        }
    }

    public Asn1OctetString(InputStream aInputStream, int aLength) throws IOException {
        this.mValue = new byte[aLength];
        if (aLength != 0) {
            if (aLength == aInputStream.read(this.mValue, 0, aLength)) {
                String str = "";
                String string = new String(this.mValue);
            } else {
                throw new IOException("Asn1OctetString(): Not enough data");
            }
        }
    }

    public String getValue() {
        return this.toString();
    }

    public byte[] getBytes() {
        return this.mValue;
    }

    public String toString() {
        String str = "";
        int length = this.mValue.length;
        byte b = 32;
        byte e = 126;
        boolean isPrintable = true;
        for (int i = 0; i < length && isPrintable; ++i) {
            isPrintable = this.mValue[i] >= b && this.mValue[i] <= e || Character.isWhitespace((char)this.mValue[i]) || this.mValue[i] == 0;
        }
        str = isPrintable ? new String(this.mValue) : "0x" + this.toHex();
        return str;
    }

    int size() {
        return this.mValue.length;
    }

    void write(OutputStream aOutputStream, int aPosition) throws IOException {
        this.Asn1BuildHeader(aOutputStream, this.getTag(), this.mValue.length);
        for (int idx = 0; idx < this.mValue.length; ++idx) {
            aOutputStream.write(this.mValue[idx]);
        }
    }

    public String toHex() {
        String str = "";
        int length = this.mValue.length;
        if (length > 0) {
            for (int i = 0; i < length - 1; ++i) {
                str = str + Util.byteToHex(this.mValue[i]) + ":";
            }
            str = str + Util.byteToHex(this.mValue[length - 1]);
        }
        return str;
    }

    public String toDisplayString() {
        String str = "";
        int length = this.mValue.length;
        if (length > 0) {
            str = new String(this.mValue);
        }
        return str;
    }
}

