/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.sldreg;

import com.sap.idm.vds.MVDLogger;
import com.sap.idm.vds.MVDVersion;
import com.sap.idm.vds.sldreg.VDSSLDReg;
import com.sap.idm.vds.sldreg.common.SLDInfoUploaderStandalone;
import com.sap.idm.vds.sldreg.common.SoftwareComponentVersion;
import com.sap.idm.vds.sldreg.common.Util;
import com.sap.idm.vds.sldreg.vds.standalone.SLDInfoForStandaloneVDS;
import java.net.InetAddress;
import java.util.Properties;
import java.util.Vector;

public class VDSSLDRegStandalone
extends VDSSLDReg {
    private static final String TEMPLATE_XML_VDS_LDAP_PORT = "com/sap/idm/vds/sldreg/vds/standalone/template_vds_ldap_port.xml";
    static SLDInfoForStandaloneVDS vdsInfo = null;
    static String sldURL = null;
    static String sldUser = null;
    static String sldPassword = null;
    static String xmlForSLD = "";
    static Vector sldReportedPorts = null;
    static boolean mIsConfigured = false;

    private VDSSLDRegStandalone() {
    }

    public static boolean isConfigured() {
        return mIsConfigured;
    }

    public static void doConfigure(String url, String uname, String pwd, Vector vPorts) {
        mIsConfigured = false;
        try {
            if (sldReportedPorts != null && sldReportedPorts.size() == vPorts.size() && sldReportedPorts.containsAll(vPorts)) {
                return;
            }
            sldURL = url;
            sldUser = uname;
            sldPassword = pwd;
            String verinfo = MVDVersion.getVersionInfo();
            verinfo = verinfo.substring(0, verinfo.indexOf("Copyright"));
            int[] locPorts = new int[vPorts.size()];
            for (int i = 0; i < vPorts.size(); ++i) {
                locPorts[i] = Integer.parseInt((String)vPorts.elementAt(i));
            }
            try {
                vdsInfo = new SLDInfoForStandaloneVDS(InetAddress.getLocalHost(), locPorts, SoftwareComponentVersion.VDS_71, 2, verinfo);
            }
            catch (Exception e) {
                MVDLogger.Log("Error while creating SLDInfoForStandaloneVDS:" + e, 7);
                return;
            }
            try {
                xmlForSLD = VDSSLDRegStandalone.generateXMLForSLD(vdsInfo);
            }
            catch (Exception e) {
                MVDLogger.Log("Error while creating data for SLD:" + e, 7);
                return;
            }
            sldReportedPorts = vPorts;
            mIsConfigured = true;
        }
        catch (Exception exc) {
            MVDLogger.Log("Error while creating configuration for SLD:" + exc, 7);
        }
    }

    public static void doPublish() {
        try {
            if (mIsConfigured) {
                new SLDInfoUploaderStandalone(sldURL, sldUser, sldPassword).sendXMLToSLD(xmlForSLD);
            }
        }
        catch (Exception exc) {
            MVDLogger.Log("Error while publishing SLD info:" + exc, 7);
            return;
        }
    }

    private static String generateXMLForSLD(SLDInfoForStandaloneVDS vdsInfo) throws Exception {
        String cimSystemInstanceName = "VDSSystem.SystemHome." + vdsInfo._host.getHostName() + ".SAP_ApplicationSystemIPServicePort." + vdsInfo._lowestPort;
        StringBuffer xmlFragmentForLDAPPorts = new StringBuffer();
        if (vdsInfo._ldapPorts != null && vdsInfo._ldapPorts.length > 0) {
            String xmlTemplateForDispatcher = Util.readXMLTemplate(TEMPLATE_XML_VDS_LDAP_PORT);
            for (int i = 0; i < vdsInfo._ldapPorts.length; ++i) {
                int ldapPort = vdsInfo._ldapPorts[i];
                Properties portVariables = new Properties();
                portVariables.setProperty("VDS_CIM_SYSTEM_INSTANCE_NAME", cimSystemInstanceName);
                portVariables.setProperty("VDS_HOSTNAME_WITHOUT_DOMAIN", vdsInfo._host.getHostName());
                portVariables.setProperty("VDS_LDAP_PORT", Integer.toString(ldapPort));
                xmlFragmentForLDAPPorts.append(Util.processTemplate(xmlTemplateForDispatcher, portVariables));
            }
        }
        return VDSSLDRegStandalone.generateMainXMLForSLD(vdsInfo, cimSystemInstanceName, xmlFragmentForLDAPPorts.toString());
    }
}

