/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.sldreg;

import com.sap.idm.vds.sldreg.common.ProductVersion;
import com.sap.idm.vds.sldreg.common.SoftwareComponentVersion;
import com.sap.idm.vds.sldreg.common.Util;
import com.sap.idm.vds.sldreg.vds.SLDInfoForVDSBase;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import javax.servlet.http.HttpServlet;

public abstract class VDSSLDReg
extends HttpServlet {
    protected static final int CURR_SERVICE_PACK = 2;
    private static final String TEMPLATE_XML_VDS_MAIN = "com/sap/idm/vds/sldreg/vds/template_vds_main.xml";

    protected static String generateMainXMLForSLD(SLDInfoForVDSBase vdsInfo, String cimSystemInstanceName, String xmlFragmentForPorts) throws UnsupportedEncodingException, IOException, Exception {
        String xmlForSLD = Util.readXMLTemplate(TEMPLATE_XML_VDS_MAIN);
        String spVersion = Util.getSupportPackageVersion(vdsInfo._vdsSupportPackage);
        SoftwareComponentVersion swCompVersion = vdsInfo._vdsVersion;
        ProductVersion productVersion = swCompVersion.getProductVersion();
        Properties xmlVariables = new Properties();
        xmlVariables.setProperty("IDM_PRODUCT_VERSION", productVersion.getVersion());
        xmlVariables.setProperty("IDM_PRODUCT_ID_NUMBER", productVersion.ProductIdentifyingNumber());
        xmlVariables.setProperty("VDS_SWCOMP_VERSION", swCompVersion.getVersion());
        xmlVariables.setProperty("VDS_SWCOMP_NAME", swCompVersion.getSoftwareComponentName());
        xmlVariables.setProperty("VDS_SWCOMP_ELEMENT_TYPE_ID", swCompVersion.getElementTypeID());
        xmlVariables.setProperty("VDS_SWCOMP_SP_NAME", Util.getSupportPackageName(spVersion));
        xmlVariables.setProperty("VDS_SWCOMP_SP_VERSION", spVersion);
        xmlVariables.setProperty("VDS_CIM_SYSTEM_INSTANCE_NAME", cimSystemInstanceName);
        xmlVariables.setProperty("VDS_HOSTNAME_WITHOUT_DOMAIN", vdsInfo._host.getHostName());
        xmlVariables.setProperty("VDS_HOSTNAME_FQDN", vdsInfo._host.getCanonicalHostName());
        xmlVariables.setProperty("VDS_BUILD_NUMBER", vdsInfo._buildNumber);
        xmlVariables.setProperty("VDS_ALL_PORTS_XML", xmlFragmentForPorts);
        return Util.processTemplate(xmlForSLD, xmlVariables);
    }
}

