/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.queue;

import com.sap.idm.vds.MVDLogger;
import com.sap.idm.vds.MVDOrderedHashMap;
import com.sap.idm.vds.config.MVDPriorityObject;
import com.sap.idm.vds.queue.MVDCandidateGoSync;
import com.sap.idm.vds.queue.MVDEngineCounter;
import com.sap.idm.vds.queue.QueueClassCallable;
import com.sap.idm.vds.queue.QueueClassConfig;
import java.util.Random;

public class MVDPriorityQueue {
    private boolean mEnabled = false;
    private int mNumberofPriorityLevels = 4;
    private int mQueueSizeLimit = 100;
    private int mEngineLimit = 12;
    private MVDOrderedHashMap[] mCandQueues;
    private int mCurrentNumberOfElementsInQueue = 0;
    private int mMillisecondsToWaitWhenQueueIsFull = 5000;
    private int mWaitForGo = 5000;
    private int[] mPriorityValues;
    private MVDEngineCounter mEngineCounter = null;
    private Random rRnd;
    private int mBusyLDAPCode = 50;
    private String mBusyMessage = "The system is at very high load at this moment. Your request could not be served. Please, try later";
    private QueueClassCallable mCallable = null;
    private static int mLargestAchievedNumberOfElementsInQueue = 0;
    private static int mNumberOfWaitsDueToFullQueue = 0;
    private static int mNumberOfRejectionsDueToFullQueue = 0;
    private static int mNumberOfDirectExecutions = 0;
    private static int mNumberOfWaitsDueToEngineLimit = 0;
    private static int mNumberOfRejectionsWaitForExecute = 0;
    private static int mNumberOfRequests = 0;

    public QueueClassCallable getCallable() {
        return this.mCallable;
    }

    public boolean getEnabled() {
        return this.mEnabled;
    }

    public static int getEngineWaits() {
        return mNumberOfWaitsDueToEngineLimit;
    }

    public void setEngineWaits(int engineWaits) {
        mNumberOfWaitsDueToEngineLimit = engineWaits;
    }

    public static int getNumberOfRejectionsWaitForExecute() {
        return mNumberOfRejectionsWaitForExecute;
    }

    public static void increaseNumberOfRejectionsWaitForExecute() {
        ++mNumberOfRejectionsWaitForExecute;
    }

    public static int getNumberOfRequests() {
        return mNumberOfRequests;
    }

    public static void increaseNumberOfRequests() {
        ++mNumberOfRequests;
    }

    public static int getMaxNumberOfElementsInQueue() {
        return mLargestAchievedNumberOfElementsInQueue;
    }

    public void setMaxNumberOfElementsInQueue(int maxNumberOfElementsInQueue) {
        mLargestAchievedNumberOfElementsInQueue = maxNumberOfElementsInQueue;
    }

    public static int getFullQueueWaits() {
        return mNumberOfWaitsDueToFullQueue;
    }

    public void setFullQueueWaits(int queueWaits) {
        mNumberOfWaitsDueToFullQueue = queueWaits;
    }

    public static int getWaitForQueueRejections() {
        return mNumberOfRejectionsDueToFullQueue;
    }

    public void setWaitForQueueRejections(int waitForQueueRejections) {
        mNumberOfRejectionsDueToFullQueue = waitForQueueRejections;
    }

    public static int getNumberOfDirectExecutions() {
        return mNumberOfDirectExecutions;
    }

    public void setNumberOfDirectExecutions(int numberOfDirectExecutions) {
        mNumberOfDirectExecutions = numberOfDirectExecutions;
    }

    public MVDPriorityQueue() throws Exception {
        this(MVDPriorityObject.getEnabled(), MVDPriorityObject.getNumberofPriorityLevels(), MVDPriorityObject.getQueueSizeLimit(), MVDPriorityObject.getEngineLimit(), MVDPriorityObject.getWaitWhenQueueIsFull(), MVDPriorityObject.getWaitForGo(), MVDPriorityObject.getPriorityValues(), MVDPriorityObject.getBusyLDAPCode(), MVDPriorityObject.getBusyMessage(), MVDPriorityObject.getLevelClass());
    }

    public MVDPriorityQueue(boolean aEnabled, int aNumberOfPrioLevels, int aQueueSizeLimit, int aEngineLimit, int aWaitForQueue, int aWaitForGo, int[] aPrioLevels, int aBusyLDAPCode, String aBusyMessage, QueueClassConfig aLevelClass) throws Exception {
        this.mEnabled = aEnabled;
        this.mNumberofPriorityLevels = aNumberOfPrioLevels;
        this.mQueueSizeLimit = aQueueSizeLimit;
        this.mEngineLimit = aEngineLimit;
        this.mMillisecondsToWaitWhenQueueIsFull = aWaitForQueue;
        this.mWaitForGo = aWaitForGo;
        this.mBusyLDAPCode = aBusyLDAPCode;
        this.mBusyMessage = aBusyMessage;
        if (aLevelClass.getClassName().length() == 0 || aLevelClass.getClassName().equalsIgnoreCase("none")) {
            this.mCallable = null;
        } else {
            this.mCallable = aLevelClass.getExecutable();
            if (this.mCallable == null) {
                throw new Exception("Could not instantiate priority class:" + aLevelClass.getClassName());
            }
        }
        this.rRnd = new Random();
        this.mPriorityValues = aPrioLevels;
        this.mCandQueues = new MVDOrderedHashMap[this.mNumberofPriorityLevels];
        for (int ix = 0; ix < this.mCandQueues.length; ++ix) {
            this.mCandQueues[ix] = new MVDOrderedHashMap();
        }
        this.mEngineCounter = new MVDEngineCounter();
    }

    public String getBusyMessage() {
        return this.mBusyMessage;
    }

    public void setBusyMessage(String busyMessage) {
        this.mBusyMessage = busyMessage;
    }

    public int getBusyLDAPCode() {
        return this.mBusyLDAPCode;
    }

    public void setBusyLDApCode(int busyCode) {
        this.mBusyLDAPCode = busyCode;
    }

    public MVDEngineCounter getEngineCounter() {
        return this.mEngineCounter;
    }

    public void setEngineCounter(MVDEngineCounter engineCounter) {
        this.mEngineCounter = engineCounter;
    }

    public int getNumberofPriorityLevels() {
        return this.mNumberofPriorityLevels;
    }

    public void setNumberofPriorityLevels(int numberofPriorityLevels) {
        this.mNumberofPriorityLevels = numberofPriorityLevels;
    }

    public int getQueueSizeLimit() {
        return this.mQueueSizeLimit;
    }

    public void setQueueSizeLimit(int queueSizeLimit) {
        this.mQueueSizeLimit = queueSizeLimit;
    }

    public int getEngineLimit() {
        return this.mEngineLimit;
    }

    public void setEngineLimit(int engineLimit) {
        this.mEngineLimit = engineLimit;
    }

    public int getWaitForGo() {
        return this.mWaitForGo;
    }

    public void setWaitForGo(int waitForGo) {
        this.mWaitForGo = waitForGo;
    }

    public int getWaitWhenQueueIsFull() {
        return this.mMillisecondsToWaitWhenQueueIsFull;
    }

    public void setWaitWhenQueueIsFull(int waitWhenQueueIsFull) {
        this.mMillisecondsToWaitWhenQueueIsFull = waitWhenQueueIsFull;
    }

    public int[] getPriorityValues() {
        return this.mPriorityValues;
    }

    public void setPriorityValues(int[] priorityValues) {
        this.mPriorityValues = priorityValues;
    }

    private MVDCandidateGoSync selectNextBestCandidate() {
        int mTotalSumPriority = 0;
        for (int ix = 0; ix < this.mPriorityValues.length; ++ix) {
            if (this.mCandQueues[ix].size() <= 0) continue;
            mTotalSumPriority += this.mPriorityValues[ix];
        }
        int iSelectedQueue = -1;
        int rSelectedRandom = this.rRnd.nextInt(mTotalSumPriority);
        int accum = 0;
        for (int ix = 0; ix < this.mPriorityValues.length; ++ix) {
            if (this.mCandQueues[ix].size() <= 0 || (accum += this.mPriorityValues[ix]) < rSelectedRandom) continue;
            iSelectedQueue = ix;
            break;
        }
        if (iSelectedQueue > -1) {
            String aThreadName = "Not selected";
            aThreadName = (String)this.mCandQueues[iSelectedQueue].keyElementAt(0);
            MVDLogger.Log("getNext: SELECTED prio=" + iSelectedQueue + " + (weight=" + this.mPriorityValues[iSelectedQueue] + ")", 0);
            MVDCandidateGoSync o = (MVDCandidateGoSync)this.mCandQueues[iSelectedQueue].get(aThreadName);
            this.mCandQueues[iSelectedQueue].remove(aThreadName);
            --this.mCurrentNumberOfElementsInQueue;
            return o;
        }
        MVDLogger.Log("SELECTED NONE - SOMETHING IS WRONG", 7);
        return null;
    }

    public synchronized void signalThatCandidateIsDone(String aThreadName) {
        MVDLogger.Log("putDone: Thread " + aThreadName + " reports that it is done ....", 0);
        if (this.mCurrentNumberOfElementsInQueue <= 0) {
            this.mEngineCounter.decrease();
            MVDLogger.Log("putDone: Number of engines in work decreased to: " + this.mEngineCounter.getCounter(), 0);
            return;
        }
        MVDLogger.Log("getNextCandidate: About to fetch element from queue. Current queue size = " + this.mCurrentNumberOfElementsInQueue + ")", 0);
        MVDCandidateGoSync lockingObject = this.selectNextBestCandidate();
        if (lockingObject == null) {
            this.mEngineCounter.decrease();
            MVDLogger.Log("putDone: Number of engines in work decreased to: " + this.mEngineCounter.getCounter(), 0);
            return;
        }
        MVDLogger.Log("getNextCandidate: Picked one thread Current queue size = " + this.mCurrentNumberOfElementsInQueue + ")", 0);
        lockingObject.givePermission2Execute();
    }

    public synchronized int putCandidate(String aThreadName, int aPriorityBucket, MVDCandidateGoSync aSyncObject) {
        if (this.mEngineCounter.getCounter() < this.mEngineLimit) {
            MVDLogger.Log("putCandidate (thread=" + aThreadName + " got immediate GO", 0);
            ++mNumberOfDirectExecutions;
            this.mEngineCounter.increase();
            return 2222;
        }
        if (this.mQueueSizeLimit > 0 && this.mCurrentNumberOfElementsInQueue >= this.mQueueSizeLimit) {
            ++mNumberOfWaitsDueToFullQueue;
            MVDLogger.Log("putCandidate (thread=" + aThreadName + ";bucket=" + aPriorityBucket + "): " + "The queue is full - waiting to add new request", 0);
            try {
                this.wait(this.mMillisecondsToWaitWhenQueueIsFull);
                if (this.mCurrentNumberOfElementsInQueue >= this.mQueueSizeLimit) {
                    ++mNumberOfRejectionsDueToFullQueue;
                    MVDLogger.Log("putCandidate (thread=" + aThreadName + ";bucket=" + aPriorityBucket + "): " + "Waiting too long - Timed Out", 0);
                    return 3333;
                }
                if (this.mEngineCounter.getCounter() < this.mEngineLimit) {
                    MVDLogger.Log("putCandidate (thread=" + aThreadName + " got GO after wait for queue", 0);
                    this.mEngineCounter.increase();
                    return 2222;
                }
            }
            catch (InterruptedException e) {
                MVDLogger.Log("putCandidate (thread=" + aThreadName + ";bucket=" + aPriorityBucket + "): " + "Interrupted ", 7);
                return 4444;
            }
            catch (Exception e) {
                MVDLogger.Log("putCandidate (thread=" + aThreadName + ";bucket=" + aPriorityBucket + "): " + "Exception " + e.getMessage(), 7);
                return 5555;
            }
        }
        MVDLogger.Log("putCandidate (thread=" + aThreadName + ";bucket=" + aPriorityBucket + "): " + "About to add element in queue. Current queue size = " + this.mCurrentNumberOfElementsInQueue, 0);
        this.mCandQueues[aPriorityBucket].put(aThreadName, aSyncObject);
        ++this.mCurrentNumberOfElementsInQueue;
        if (this.mCurrentNumberOfElementsInQueue > mLargestAchievedNumberOfElementsInQueue) {
            mLargestAchievedNumberOfElementsInQueue = this.mCurrentNumberOfElementsInQueue;
        }
        ++mNumberOfWaitsDueToEngineLimit;
        MVDLogger.Log("putCandidate (thread=" + aThreadName + ";bucket=" + aPriorityBucket + "): " + "Added candidate to the queue Current queue size = " + this.mCurrentNumberOfElementsInQueue, 0);
        return 1111;
    }

    public synchronized boolean removeCandidate(String aThreadName, int aPriorityBucket, MVDCandidateGoSync aSync) {
        if (aSync.getSyncState() == 2222) {
            return true;
        }
        MVDPriorityQueue.increaseNumberOfRejectionsWaitForExecute();
        MVDLogger.Log("removeItem; Thread " + aThreadName + " leaves - system is too BUSY for me", 0);
        this.mCandQueues[aPriorityBucket].remove(aThreadName);
        --this.mCurrentNumberOfElementsInQueue;
        this.notify();
        return false;
    }
}

