/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.queue;

import com.sap.idm.vds.MVDLogger;
import com.sap.idm.vds.queue.MVDPriorityQueue;

public class MVDCandidateGoSync {
    public static final int UNTOUCHED = 0;
    public static final int ADDED_TO_QUEUE = 1111;
    public static final int SELECTED_TO_RUN = 2222;
    public static final int TIMED_OUT = 3333;
    public static final int INTERRUPTED = 4444;
    public static final int ERROR = 5555;
    private int mSyncState = 0;
    private int mTime2WaitForPermission2Execute = 5000;
    private String mThreadName = "";
    private MVDPriorityQueue mCandQueue = null;

    public int getSyncState() {
        return this.mSyncState;
    }

    public MVDCandidateGoSync(MVDPriorityQueue aCandQueue) {
        this.mCandQueue = aCandQueue;
        this.mTime2WaitForPermission2Execute = aCandQueue.getWaitForGo();
    }

    public synchronized int getPermission2Execute(String aThreadName, int aPriorityBucket) {
        this.mThreadName = aThreadName;
        MVDCandidateGoSync mVDCandidateGoSync = this;
        mVDCandidateGoSync.mCandQueue.increaseNumberOfRequests();
        try {
            int addStatus = this.mCandQueue.putCandidate(aThreadName, aPriorityBucket, this);
            if (addStatus == 1111) {
                MVDLogger.Log("getPermission2Execute: Thread " + this.mThreadName + " waiting for permission to execute", 0);
                this.wait(this.mTime2WaitForPermission2Execute);
                if (this.mSyncState == 0) {
                    this.mSyncState = 3333;
                    MVDLogger.Log("getPermission2Execute: Thread " + this.mThreadName + " TIMED out", 2);
                    return 3333;
                }
                return 2222;
            }
            return addStatus;
        }
        catch (InterruptedException e) {
            MVDLogger.Log("getPermission2Execute: Thread " + this.mThreadName + " INTERRUPTED", 0);
            return 4444;
        }
    }

    public synchronized boolean givePermission2Execute() {
        if (this.mSyncState == 0 || this.mSyncState == 3333) {
            MVDLogger.Log("givePermission2Execute: Thread " + this.mThreadName + " given permission to execute", 0);
            this.mSyncState = 2222;
            this.notify();
            return true;
        }
        return false;
    }
}

