/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.protocols.ldap;

import com.sap.idm.vds.AbstractPostProcessing;
import com.sap.idm.vds.AbstractPreProcessing;
import com.sap.idm.vds.AbstractTransformation;
import com.sap.idm.vds.Globals;
import com.sap.idm.vds.MVDEngineData;
import com.sap.idm.vds.MVDHashMap;
import com.sap.idm.vds.MVDLogger;
import com.sap.idm.vds.config.MVDProxy;
import com.sap.idm.vds.message.MxAdd;
import com.sap.idm.vds.message.MxCompare;
import com.sap.idm.vds.message.MxDelete;
import com.sap.idm.vds.message.MxModify;
import com.sap.idm.vds.message.MxRequest;
import com.sap.idm.vds.message.MxResponse;
import com.sap.idm.vds.message.MxSearch;

public class MxProtoTransform {
    private MVDEngineData mEngineData;
    private MVDHashMap mEngineGs;

    public MxProtoTransform(MVDEngineData aEngineData, MVDHashMap aEGs) {
        this.mEngineGs = aEGs;
        this.mEngineData = aEngineData;
    }

    public Object transformResponseIfNeeded(MxResponse[] aMxr, Object aOrgRequest, MxRequest[] aMxRequestArr) {
        if (!MVDProxy.AllowProtocolTransform()) {
            return aMxr;
        }
        AbstractTransformation o = this.mEngineData.getInitiatedTransformationObject(MVDProxy.TransformationClass(), this.mEngineGs);
        if (o == null) {
            MVDLogger.Log("Missing transformation class:'" + MVDProxy.TransformationClass() + "' - transformation not carried out", 3);
            return null;
        }
        try {
            o.setRequests(aMxRequestArr);
            return o.transformResponse(aMxr, aOrgRequest);
        }
        catch (Exception e) {
            MVDLogger.Log("Error on '" + MVDProxy.TransformationClass() + " 'Result transformation': " + e, 7, e);
            return null;
        }
        catch (VirtualMachineError vte) {
            Globals.blownAwayByThrowable(vte);
            return null;
        }
        catch (Throwable ee) {
            MVDLogger.Log("Error on '" + MVDProxy.TransformationClass() + " 'Result transformation': " + ee, 7, ee);
            return null;
        }
    }

    public MxRequest[] transformRequestIfNeeded(Object aReq) {
        if (!MVDProxy.AllowProtocolTransform()) {
            MVDLogger.Log("Transformation called, but no class defined for transformation", 2);
            try {
                if (aReq instanceof MxRequest) {
                    return new MxRequest[]{(MxRequest)aReq};
                }
                return (MxRequest[])aReq;
            }
            catch (ClassCastException cce) {
                MVDLogger.Log("Exception on transformation, expected MxRequest or MxRequest[], found: " + aReq.getClass() + "/" + cce.getMessage(), 2);
                return null;
            }
        }
        AbstractTransformation o = this.mEngineData.getInitiatedTransformationObject(MVDProxy.TransformationClass(), this.mEngineGs);
        if (o == null) {
            MVDLogger.Log("Missing transformation class:'" + MVDProxy.TransformationClass() + "' - transformation not carried out", 3);
            return null;
        }
        try {
            try {
                MVDLogger.LogDataToFile("TRANSFORM", aReq.toString());
            }
            catch (Exception qwertye) {
                // empty catch block
            }
            return o.transformRequest(aReq);
        }
        catch (Exception e) {
            MVDLogger.Log("Error on '" + MVDProxy.TransformationClass() + " 'Request transformation': " + e, 7, e);
            return null;
        }
        catch (VirtualMachineError vte) {
            Globals.blownAwayByThrowable(vte);
            return null;
        }
        catch (Throwable ee) {
            MVDLogger.Log("Error on '" + MVDProxy.TransformationClass() + " 'Request transformation': " + ee, 7, ee);
            return null;
        }
    }

    public MxRequest preRequestIfNeeded(MxRequest aRequest, String opString) {
        if (MVDProxy.ValidPreProcessClassName() && MVDProxy.isPreTransOp(opString)) {
            try {
                AbstractPreProcessing o = this.mEngineData.getInitiatedPreProcessingObject(MVDProxy.PreProcessClass(), this.mEngineGs);
                if (o == null) {
                    MVDLogger.Log("Missing Pre processing class:'" + MVDProxy.PreProcessClass() + "' - transformation not carried out", 3);
                    return null;
                }
                MVDLogger.Log("Executing PreProcess operation", 2);
                switch (aRequest.getChoiceID()) {
                    case 3: {
                        MxSearch mxSearchReq = o.search((MxSearch)aRequest);
                        return mxSearchReq;
                    }
                    case 8: {
                        MxAdd mxAddReq = o.add((MxAdd)aRequest);
                        return mxAddReq;
                    }
                    case 6: {
                        MxModify mxModReq = o.modify((MxModify)aRequest);
                        return mxModReq;
                    }
                    case 10: {
                        MxDelete mxDelReq = o.delete((MxDelete)aRequest);
                        return mxDelReq;
                    }
                    case 14: {
                        MxCompare mxCompReq = o.compare((MxCompare)aRequest);
                        return mxCompReq;
                    }
                }
                MVDLogger.Log("Invalid operation type - pre transformation not carried out", 2);
                return aRequest;
            }
            catch (Exception e) {
                MVDLogger.Log("Error on '" + MVDProxy.PreProcessClass() + " 'Pre operation': " + e, 7, e);
                return null;
            }
            catch (VirtualMachineError vte) {
                Globals.blownAwayByThrowable(vte);
                return null;
            }
            catch (Throwable ee) {
                MVDLogger.Log("Error on '" + MVDProxy.PreProcessClass() + " 'Pre operation': " + ee, 7, ee);
                return null;
            }
        }
        return aRequest;
    }

    public MxResponse postRequestIfNeeded(MxResponse aResponse, String opString, MxRequest aRequest) {
        if (MVDProxy.ValidPostProcessClassName() && MVDProxy.isPostTransOp(opString)) {
            try {
                AbstractPostProcessing o = this.mEngineData.getInitiatedPostProcessingObject(MVDProxy.PostProcessClass(), this.mEngineGs);
                if (o == null) {
                    MVDLogger.Log("Missing Post processing class:'" + MVDProxy.PostProcessClass() + "' - transformation not carried out", 3);
                    return null;
                }
                MVDLogger.Log("Executing PostProcess operation", 2);
                MxResponse mxResp = null;
                if (aRequest instanceof MxSearch) {
                    mxResp = o.search(aResponse, (MxSearch)aRequest);
                } else if (aRequest instanceof MxAdd) {
                    mxResp = o.add(aResponse, (MxAdd)aRequest);
                } else if (aRequest instanceof MxModify) {
                    mxResp = o.modify(aResponse, (MxModify)aRequest);
                } else if (aRequest instanceof MxDelete) {
                    mxResp = o.delete(aResponse, (MxDelete)aRequest);
                } else if (aRequest instanceof MxCompare) {
                    mxResp = o.compare(aResponse, (MxCompare)aRequest);
                } else {
                    MVDLogger.Log("Invalid operation type '" + opString + "' - post transformation not carried out", 2);
                    return aResponse;
                }
                return mxResp;
            }
            catch (Exception e) {
                MVDLogger.Log("Error on '" + MVDProxy.PostProcessClass() + " 'Post operation': " + e, 7, e);
                return null;
            }
            catch (VirtualMachineError vte) {
                Globals.blownAwayByThrowable(vte);
                return null;
            }
            catch (Throwable ee) {
                MVDLogger.Log("Error on '" + MVDProxy.PostProcessClass() + " 'Post operation': " + ee, 7, ee);
                return null;
            }
        }
        return aResponse;
    }
}

