/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.protocols.ldap;

import com.sap.idm.vds.Engine;
import com.sap.idm.vds.EnginePool;
import com.sap.idm.vds.Globals;
import com.sap.idm.vds.MVDLogger;
import com.sap.idm.vds.asn1.ASN1Exception;
import com.sap.idm.vds.ldapv3.LDAPMessage;
import com.sap.idm.vds.protocols.ldap.MxLdapConnection;
import java.net.Socket;

public class MxLdapMessageHandler {
    private MxLdapConnection mConnection = null;
    private Engine mEngine = null;
    private String mSerialId;
    private LDAPMessage mCurrentRequest;

    public MxLdapMessageHandler(Socket client, String parentSessionID) throws Exception {
        this.mSerialId = parentSessionID;
        MVDLogger.Log("LDAP Message Handler for Session id=" + this.mSerialId + ": Creating new ... ", 0);
        try {
            this.mEngine = EnginePool.checkOut();
            this.mEngine.setMessageHandler(this);
        }
        catch (Exception e) {
            this.mEngine = null;
        }
        this.mConnection = new MxLdapConnection(client);
        if (this.mEngine != null) {
            this.mConnection.setEngineData(this.mEngine.getEngineData());
        }
        MVDLogger.Log("LDAP Message Handler for Session id=" + this.mSerialId + ": Created", 0);
    }

    public Engine getEngine() {
        return this.mEngine;
    }

    public void setEngine(Engine e) {
        this.mEngine = e;
    }

    public MxLdapConnection getConnection() {
        return this.mConnection;
    }

    public LDAPMessage getNextRequest() {
        LDAPMessage request = null;
        try {
            request = this.mConnection.getNextRequest();
        }
        catch (ASN1Exception e) {
            String s = e.getMessage();
            if (s != null && s.startsWith(" (VDS interrupted) ")) {
                Globals.IncTimeOutErrorReqCount();
                MVDLogger.Log("LDAP Message Handler for Session id=" + this.mSerialId + ": Connection timeout! - " + e.getMessage(), 2);
            } else {
                Globals.IncErrorReqCount();
                MVDLogger.Log("LDAP Message Handler for Session id=" + this.mSerialId + ": Connection error: " + e.getMessage(), 6);
            }
        }
        catch (Exception e) {
            MVDLogger.Log("LDAP Message Handler for Session id=" + this.mSerialId + ": exception: " + e.getMessage(), 6, e);
            Globals.IncErrorReqCount();
        }
        this.mCurrentRequest = request;
        return request;
    }

    public void close() {
        MVDLogger.Log("LDAP Message Handler for Session id=" + this.mSerialId + ": Closing", 4);
        if (this.mConnection != null) {
            this.mConnection.close();
        }
        try {
            if (this.mEngine != null) {
                this.mEngine.clearMessageHandler();
                EnginePool.checkIn(this.mEngine);
            }
        }
        catch (Exception e) {
            MVDLogger.Log("LDAP Message Handler for Session id=" + this.mSerialId + ": could not check in engine", 7);
        }
        MVDLogger.Log("LDAP Message Handler for Session id=" + this.mSerialId + ": Closed", 4);
    }

    public void sendResponse(LDAPMessage response) throws Exception {
        try {
            this.mConnection.sendResponse(response);
        }
        catch (Exception e) {
            throw new Exception("LDAP Message Handler for Session id=" + this.mSerialId + ": Error Communicating with Client: " + e.getMessage());
        }
    }

    public void sendRawResponse(byte[] rawresponse) throws Exception {
        try {
            this.mConnection.sendRawResponse(rawresponse);
        }
        catch (Exception e) {
            throw new Exception("LDAP Message Handler for Session id=" + this.mSerialId + ": Error Communicating with Client: " + e.getMessage());
        }
    }

    public void setConnection(MxLdapConnection connection) {
        this.mConnection = connection;
    }

    public LDAPMessage getCurrentRequest() {
        return this.mCurrentRequest;
    }
}

