/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.protocols.ldap;

import com.sap.idm.vds.MVDEngineData;
import com.sap.idm.vds.MVDLogger;
import com.sap.idm.vds.asn1.ASN1Exception;
import com.sap.idm.vds.asn1.BERDecoder;
import com.sap.idm.vds.asn1.BEREncoder;
import com.sap.idm.vds.config.MVDLDAPDeploymentList;
import com.sap.idm.vds.config.MVDProxy;
import com.sap.idm.vds.ldapv3.LDAPMessage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.security.cert.Certificate;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.security.cert.X509Certificate;

public class MxLdapConnection {
    private Socket mClient = null;
    private MVDEngineData mLinkToEngineData = null;
    private BufferedInputStream bufIn = null;
    private BufferedOutputStream bufOut = null;
    private BEREncoder mBerEncoder = null;
    private BERDecoder mBerDecoder = null;

    public MxLdapConnection(Socket client) throws Exception {
        this.mClient = client;
        this.initClient();
        MVDLogger.Log("LDAP Connection: Created new one - with client " + client.getLocalPort() + " " + client.getPort(), 0);
    }

    public void setEngineData(MVDEngineData aSessionGlobals) {
        this.mLinkToEngineData = aSessionGlobals;
        this.mLinkToEngineData.ExternalSessionGs().put("LISTENER_PORT", "" + this.mClient.getLocalPort());
    }

    public void initClient() throws IOException {
        if (this.mBerEncoder == null) {
            this.mBerEncoder = new BEREncoder();
        }
        this.bufOut = new BufferedOutputStream(this.mClient.getOutputStream());
        this.bufIn = new BufferedInputStream(this.mClient.getInputStream());
        if (this.mBerDecoder == null) {
            this.mBerDecoder = new BERDecoder(this.bufIn);
        } else {
            this.mBerDecoder.setInputStream(this.bufIn);
        }
    }

    public Socket getClient() {
        return this.mClient;
    }

    public void close() {
        try {
            if (this.mClient != null) {
                MVDLogger.Log("LDAP Connection: Closed " + this.mClient.getPort(), 0);
                this.mClient.close();
            }
        }
        catch (IOException e) {
            MVDLogger.Log("Error closing socket:" + e.getMessage(), 2);
        }
        this.mClient = null;
        this.bufIn = null;
        this.bufOut = null;
    }

    public Object getClientCertificates() {
        if (!MVDLDAPDeploymentList.getMainLDAPDeployment().getSecureServer()) {
            MVDLogger.Log("Not running as secure server, no client certificates available", 2);
            return null;
        }
        if (!MVDLDAPDeploymentList.getMainLDAPDeployment().getClientAuthentication()) {
            MVDLogger.Log("Not running server with client authentication, no client certificates available", 2);
            return null;
        }
        if (!(this.mClient instanceof SSLSocket)) {
            MVDLogger.Log("Could not retrieve client certificate, not a SSLSocket", 0);
            return null;
        }
        SSLSocket s = (SSLSocket)this.mClient;
        SSLSession sss = s.getSession();
        try {
            Certificate[] certArr = sss.getPeerCertificates();
            return certArr;
        }
        catch (Throwable t) {
            MVDLogger.Log("Could not retrieve client certificate acording to Java 1.4, trying 1.3: " + t, 0);
            try {
                X509Certificate[] certArr = sss.getPeerCertificateChain();
                return certArr;
            }
            catch (Throwable tt) {
                MVDLogger.Log("Could not retrieve client certificate: " + tt, 2);
                return null;
            }
        }
    }

    public LDAPMessage getNextRequest() throws ASN1Exception {
        boolean bGetASNString = false;
        LDAPMessage request = new LDAPMessage();
        MVDLogger.Log("About to decode incoming on client: " + this.mClient.getPort(), 0);
        request.decode(this.mBerDecoder);
        bGetASNString = false;
        if (MVDLogger.isWriteASNFiles()) {
            bGetASNString = true;
        } else if (MVDProxy.TransparentAuth()) {
            if (request.protocolOp.choiceId == 0) {
                bGetASNString = true;
            } else if (request.protocolOp.choiceId == 3) {
                bGetASNString = true;
            }
        }
        if (bGetASNString) {
            this.mBerEncoder.init();
            request.encode(this.mBerEncoder);
            this.mBerEncoder.finish();
            byte[] s = this.mBerEncoder.toByteArray();
            byte nbts = s[1];
            long res = 0L;
            if ((nbts & 0x80) == 128) {
                int lbts = nbts & 0x7F;
                res = 0L;
                for (int x = 0; x < lbts; ++x) {
                    int ddd = s[2 + x];
                    if (ddd < 0) {
                        ddd += 256;
                    }
                    res = 256L * res + (long)ddd;
                }
                res += 2L;
                res += (long)lbts;
            } else {
                res = s[1] + 2;
            }
            this.mLinkToEngineData.SetLastASNString(s, res);
            if (MVDLogger.isWriteASNFiles()) {
                MVDLogger.LogDataToFile("ToMVD", this.mLinkToEngineData.LastASNString());
            }
        }
        return request;
    }

    public void sendResponse(LDAPMessage response) throws Exception {
        this.mBerEncoder.init();
        response.encode(this.mBerEncoder);
        this.mBerEncoder.finish();
        if (MVDLogger.isWriteASNFiles()) {
            MVDLogger.LogDataToFile("FromMVD", this.mBerEncoder.toByteArray());
        }
        if (MVDLogger.IsLogging(0)) {
            MVDLogger.Log("Sending response to socket: " + this.mClient.getPort(), 0);
        }
        this.mBerEncoder.writeTo(this.bufOut);
        this.bufOut.flush();
    }

    public void sendRawResponse(byte[] rawresponse) throws Exception {
        MVDLogger.LogDataToFile("FromMVD", rawresponse);
        this.bufOut.write(rawresponse, 0, rawresponse.length);
        this.bufOut.flush();
    }
}

