/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.operations;

import com.sap.idm.vds.MVDException;
import com.sap.idm.vds.MVDHashMap;
import com.sap.idm.vds.MVDLogger;
import com.sap.idm.vds.MVDSearchResultEntry;
import com.sap.idm.vds.MVDSearchResults;
import com.sap.idm.vds.MVDUtil;
import com.sap.idm.vds.MVDUtilities;
import com.sap.idm.vds.PartialResultCallbackHandler;
import com.sap.idm.vds.PartialResultSender;
import com.sap.idm.vds.util.MxJNDISocketFactory;
import java.util.Vector;
import javax.net.ssl.SSLException;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.LDAPSocketFactory;
import netscape.ldap.factory.JSSESocketFactory;

public class NSDKOperations {
    private int mBufferSize;
    private int mBufferCount;

    public NSDKOperations() {
        this(50, 10);
    }

    public NSDKOperations(int aBufferSize, int aBufferCount) {
        this.mBufferCount = aBufferCount;
        this.mBufferSize = aBufferSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public MVDSearchResults search(String aHost, int aPort, String aUsername, String aPassword, String aStartingpoint, int aScope, String[] aReturnAttributes, String aFilter, int aSzLimit, int aTmLimit, String aSecurityProtocol, String aNotUsed, boolean aCacheConnections, MVDHashMap aEngineGlobals, String aRealSp, String aVirtSp, boolean aSendPartialResults) {
        Exception e2222;
        MVDSearchResults mVDSearchResults;
        LDAPConnection connection;
        MVDSearchResults results;
        PartialResultSender sender;
        block33: {
            sender = null;
            if (aSendPartialResults) {
                PartialResultCallbackHandler callback = (PartialResultCallbackHandler)aEngineGlobals.get("#MX_CALLBACK_HANDLER#");
                if (callback != null) {
                    MVDLogger.Log("Starting partial result sender", 2);
                    sender = new PartialResultSender(callback, aRealSp, aVirtSp, aScope, aReturnAttributes);
                    sender.setPackets(this.mBufferCount);
                    sender.start();
                } else {
                    aSendPartialResults = false;
                }
            }
            results = new MVDSearchResults();
            LDAPSearchResults res = null;
            connection = null;
            String securityprotocol = "simple";
            String ldapVersion = "3";
            if (aSecurityProtocol != null) {
                Vector v = MVDUtil.splitString(aSecurityProtocol, "::");
                String tmp = (String)v.elementAt(0);
                if (tmp.length() > 0) {
                    securityprotocol = tmp;
                }
                if (v.size() > 1 && (tmp = (String)v.elementAt(1)).length() > 0) {
                    ldapVersion = tmp;
                }
            } else {
                securityprotocol = null;
                ldapVersion = null;
            }
            connection = this.getConnection(aHost, aPort, aUsername, aPassword, aCacheConnections, aEngineGlobals, securityprotocol, ldapVersion);
            LDAPSearchConstraints cons = connection.getSearchConstraints();
            cons.setDereference(3);
            cons.setMaxResults(aSzLimit);
            cons.setServerTimeLimit(aTmLimit);
            cons.setReferrals(false);
            res = connection.search(aStartingpoint, aScope, aFilter, aReturnAttributes, false, cons);
            while (res.hasMoreElements()) {
                LDAPEntry entry = res.next();
                results.putEntry(this.convertToMVDEntry(entry));
                if (!aSendPartialResults || sender == null || results.size() < this.mBufferSize) continue;
                results.setOK();
                int size = results.size() + results.getCallbackEntries();
                sender.queue(results);
                results = new MVDSearchResults();
                results.setPartialResult();
                results.setCallbackEntries(size);
                while (sender.shouldWait()) {
                    Thread.sleep(300L);
                }
            }
            if (aSendPartialResults && sender != null) {
                sender.kill();
                sender = null;
            }
            results.setOK();
            mVDSearchResults = results;
            Object var28_33 = null;
            if (sender == null) break block33;
            try {
                sender.interrupt();
            }
            catch (Exception e2222) {
                e2222.printStackTrace();
            }
        }
        if (!aCacheConnections && connection != null) {
            try {
                connection.disconnect();
            }
            catch (Exception e2222) {
                MVDLogger.Log("Exception disconnecting from server", 6, e2222);
            }
        }
        return mVDSearchResults;
        catch (LDAPException e3) {
            Exception e2222;
            MVDSearchResults mVDSearchResults2;
            block35: {
                int code = e3.getLDAPResultCode();
                String message = e3.errorCodeToString();
                String string = message = message == null ? "" : message;
                if (code == 4 || code == 3 || code == 11 || code == 9) {
                    results.setOK(code, message);
                } else {
                    results.setError(code, message);
                }
                if (aSendPartialResults && sender != null) {
                    sender.kill();
                    sender = null;
                }
                mVDSearchResults2 = results;
                Object var28_34 = null;
                if (sender == null) break block35;
                try {
                    sender.interrupt();
                }
                catch (Exception e2222) {
                    e2222.printStackTrace();
                }
            }
            if (!aCacheConnections && connection != null) {
                try {
                    connection.disconnect();
                }
                catch (Exception e2222) {
                    MVDLogger.Log("Exception disconnecting from server", 6, e2222);
                }
            }
            return mVDSearchResults2;
        }
        catch (Exception e4) {
            Exception e2222;
            MVDSearchResults mVDSearchResults3;
            block37: {
                results.setError(2, e4.getMessage());
                mVDSearchResults3 = results;
                Object var28_35 = null;
                if (sender == null) break block37;
                {
                    catch (Throwable throwable) {
                        block39: {
                            Exception e2222;
                            Object var28_36 = null;
                            if (sender != null) {
                                try {
                                    sender.interrupt();
                                }
                                catch (Exception e2222) {
                                    e2222.printStackTrace();
                                }
                            }
                            if (aCacheConnections || connection == null) break block39;
                            try {
                                connection.disconnect();
                            }
                            catch (Exception e2222) {
                                MVDLogger.Log("Exception disconnecting from server", 6, e2222);
                            }
                        }
                        throw throwable;
                    }
                }
                try {
                    sender.interrupt();
                }
                catch (Exception e2222) {
                    e2222.printStackTrace();
                }
            }
            if (!aCacheConnections && connection != null) {
                try {
                    connection.disconnect();
                }
                catch (Exception e2222) {
                    MVDLogger.Log("Exception disconnecting from server", 6, e2222);
                }
            }
            return mVDSearchResults3;
        }
    }

    public LDAPConnection createConnection(String aHost, int aPort, String aUsername, String aPassword, String aSecurityProtocol, String aLDAPVersion) throws LDAPException {
        LDAPConnection client = new LDAPConnection();
        if (aSecurityProtocol != null && aSecurityProtocol.equalsIgnoreCase("SSL")) {
            try {
                client.setSocketFactory((LDAPSocketFactory)new JSSESocketFactory(null, MxJNDISocketFactory.getSocketFactory(aHost, aPort)));
            }
            catch (SSLException e) {
                throw new LDAPException(e.getMessage());
            }
        }
        if (aLDAPVersion != null && aLDAPVersion.equals("2")) {
            client.setOption(17, (Object)new Integer(2));
        } else {
            client.setOption(17, (Object)new Integer(3));
        }
        client.connect(aHost, aPort);
        client.authenticate(aUsername, aPassword);
        return client;
    }

    public LDAPConnection getConnection(String aHost, int aPort, String aUsername, String aPassword, boolean aCacheConnections, MVDHashMap aEngineGlobals, String aSecurityProtocol, String aLDAPVersion) throws LDAPException {
        LDAPConnection connection;
        if (aCacheConnections) {
            String connectionKey = "NSDK:" + aHost + ":" + aPort + ":" + aUsername + ":" + aPassword;
            MVDLogger.Log("Created connection key: " + connectionKey, 1);
            connection = (LDAPConnection)aEngineGlobals.get(connectionKey);
            if (connection == null) {
                connection = this.createConnection(aHost, aPort, aUsername, aPassword, aSecurityProtocol, aLDAPVersion);
                aEngineGlobals.put(connectionKey, connection);
            }
        } else {
            connection = this.createConnection(aHost, aPort, aUsername, aPassword, aSecurityProtocol, aLDAPVersion);
        }
        return connection;
    }

    private MVDSearchResultEntry convertToMVDEntry(LDAPEntry aEntry) {
        MVDSearchResultEntry entry = new MVDSearchResultEntry();
        String namewegot = aEntry.getDN();
        try {
            namewegot = MVDUtil.NiceDN(namewegot);
        }
        catch (MVDException ee) {
            // empty catch block
        }
        entry.setDn(namewegot);
        LDAPAttributeSet attrset = aEntry.getAttributeSet();
        for (int i = 0; i < attrset.size(); ++i) {
            LDAPAttribute attr = attrset.elementAt(i);
            String name = attr.getBaseName();
            byte[][] temp = attr.getByteValueArray();
            if (MVDUtilities.IsBinaryAttribute(name)) {
                byte[][] values = temp;
                for (int j = 0; j < values.length; ++j) {
                    byte[] bs = values[j];
                    entry.setAttrValue(name, true, bs);
                }
                continue;
            }
            for (int j = 0; j < temp.length; ++j) {
                String val = MVDUtil.FromUTF8(temp[j]);
                entry.setAttrValue(name, true, val);
            }
        }
        return entry;
    }
}

