/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.operations;

import com.sap.idm.vds.AbstractOperation;
import com.sap.idm.vds.Engine;
import com.sap.idm.vds.Globals;
import com.sap.idm.vds.MVDDebitInfo;
import com.sap.idm.vds.MVDEngineData;
import com.sap.idm.vds.MVDError;
import com.sap.idm.vds.MVDException;
import com.sap.idm.vds.MVDHashMap;
import com.sap.idm.vds.MVDLogger;
import com.sap.idm.vds.MVDOperationResult;
import com.sap.idm.vds.MVDUtil;
import com.sap.idm.vds.cache.MVDCachePool;
import com.sap.idm.vds.config.FailoverGroupContainer;
import com.sap.idm.vds.config.LoadBalancingGroupContainer;
import com.sap.idm.vds.config.MVDAcl;
import com.sap.idm.vds.config.MVDDataSource;
import com.sap.idm.vds.config.MVDDataSourceSequentialGroup;
import com.sap.idm.vds.config.MVDDynamicAddGroup;
import com.sap.idm.vds.config.MVDJoinGroup;
import com.sap.idm.vds.config.MVDProvisioningGroup;
import com.sap.idm.vds.config.MVDProxy;
import com.sap.idm.vds.config.MVDRule;
import com.sap.idm.vds.config.MVDUserGroup;
import com.sap.idm.vds.config.MVDUserGroupList;
import com.sap.idm.vds.event.EventHandler;
import com.sap.idm.vds.event.EventTriggerConfig;
import com.sap.idm.vds.message.MxAdd;
import com.sap.idm.vds.message.MxCompare;
import com.sap.idm.vds.message.MxDelete;
import com.sap.idm.vds.message.MxModify;
import com.sap.idm.vds.message.MxRequest;
import com.sap.idm.vds.message.MxResultCodes;
import com.sap.idm.vds.util.MVDOpUtilities;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class MVDCommonAMDOperation {
    protected String mAMDType;
    protected BigInteger mMessageID;
    protected String mDNOfTheOriginalRequest;
    protected MVDHashMap mEngineGs;
    protected MVDEngineData mEngineData;
    protected Engine mEngine;
    protected String mResultMessage;
    protected int mResultCode;
    protected MVDRule mRule;
    protected MVDAcl mAcl;
    protected MVDDataSource mDataSource;
    protected MVDDataSourceSequentialGroup mDataSourceSequentialGroup;
    protected MVDProvisioningGroup mProvisioningGroup;
    protected MVDDynamicAddGroup mDynamicAddGroup;
    protected MVDJoinGroup mJoinGroup;
    protected LoadBalancingGroupContainer mLoadBalancingGroup;
    protected FailoverGroupContainer mFailoverGroup;
    protected int mNodeType;
    protected String logPrefix;
    protected MVDOperationResult mGeneralResult;
    private MxRequest mOriginalRequest;
    protected int mErrorNumber;
    protected String mErrorMessage;

    public MVDAcl getAcl() {
        return this.mAcl;
    }

    protected MVDRule getRule() {
        return this.mRule;
    }

    public String getDNOfTheOriginalRequest() {
        return this.mDNOfTheOriginalRequest;
    }

    public MVDOperationResult getGeneralResult() {
        return this.mGeneralResult;
    }

    public MVDDataSource getDataSource() {
        return this.mDataSource;
    }

    public LoadBalancingGroupContainer getLoadBalancingGroup() {
        return this.mLoadBalancingGroup;
    }

    public MVDJoinGroup getJoinGroup() {
        return this.mJoinGroup;
    }

    public MVDDynamicAddGroup getDynamicAddGroup() {
        return this.mDynamicAddGroup;
    }

    public MVDDataSourceSequentialGroup getDataSourceSequentialGroup() {
        return this.mDataSourceSequentialGroup;
    }

    public MVDProvisioningGroup getProvisioningGroup() {
        return this.mProvisioningGroup;
    }

    public FailoverGroupContainer getFailoverGroup() {
        return this.mFailoverGroup;
    }

    public int getNodeType() {
        return this.mNodeType;
    }

    public String getErrorMessage() {
        return this.mErrorMessage;
    }

    public int getErrorNumber() {
        return this.mErrorNumber;
    }

    public String getAMDType() {
        return this.mAMDType;
    }

    public MVDEngineData getEngineData() {
        return this.mEngineData;
    }

    public MVDHashMap EngineGs() {
        return this.mEngineGs;
    }

    public void setDynamicAddGroup(MVDDynamicAddGroup aProvGroup) {
        this.mDynamicAddGroup = aProvGroup;
    }

    public void SetLoadBalancingGroup(LoadBalancingGroupContainer aLoadBalancingGroup) {
        this.mLoadBalancingGroup = aLoadBalancingGroup;
    }

    public void SetJoinGroup(MVDJoinGroup aJoinGroup) {
        this.mJoinGroup = aJoinGroup;
    }

    public void SetDataSource(MVDDataSource m) {
        this.mDataSource = m;
    }

    public void SetDataSourceSequentialGroup(MVDDataSourceSequentialGroup m) {
        this.mDataSourceSequentialGroup = m;
    }

    public void setProvisioningGroup(MVDProvisioningGroup m) {
        this.mProvisioningGroup = m;
    }

    public void SetFailoverGroup(FailoverGroupContainer aFailoverGroup) {
        this.mFailoverGroup = aFailoverGroup;
    }

    public MVDCommonAMDOperation(MVDCommonAMDOperation kkk) {
        this.mGeneralResult = new MVDOperationResult(kkk.getGeneralResult());
        this.mEngineData = kkk.getEngineData();
        this.mEngineGs = kkk.EngineGs();
        this.mAcl = kkk.getAcl();
        this.mRule = kkk.getRule();
        this.mDataSource = kkk.getDataSource();
        this.mDataSourceSequentialGroup = kkk.getDataSourceSequentialGroup();
        this.mProvisioningGroup = kkk.getProvisioningGroup();
        this.mLoadBalancingGroup = kkk.getLoadBalancingGroup();
        this.mFailoverGroup = kkk.getFailoverGroup();
        this.mJoinGroup = kkk.getJoinGroup();
        this.mDynamicAddGroup = kkk.getDynamicAddGroup();
        this.mNodeType = kkk.getNodeType();
        this.mErrorNumber = kkk.getErrorNumber();
        this.mErrorMessage = kkk.getErrorMessage();
        this.mEngineData.MvdDebit().SetOperationType(kkk.getAMDType());
        this.mEngineData.MvdDebit().SetOperationSubType("");
        this.mEngineData.MvdDebit().SetReturnedEntries(0);
        this.mEngineData.MvdDebit().SetNumberOfBytes(0);
        this.mDNOfTheOriginalRequest = kkk.getDNOfTheOriginalRequest();
    }

    public MVDCommonAMDOperation(MxRequest mxReq, Engine aEng) {
        this.mGeneralResult = new MVDOperationResult();
        this.mEngineData = aEng.getEngineData();
        this.mEngineGs = aEng.getEngineGs();
        this.mEngine = aEng;
        this.mAcl = null;
        this.mRule = null;
        this.mDataSource = null;
        this.mDataSourceSequentialGroup = null;
        this.mProvisioningGroup = null;
        this.mJoinGroup = null;
        this.mDynamicAddGroup = null;
        this.mLoadBalancingGroup = null;
        this.mFailoverGroup = null;
        this.mNodeType = 22;
        this.mErrorNumber = -1;
        this.mErrorMessage = "";
        this.mEngineData.MvdDebit().SetOperationType(this.mAMDType);
        this.mEngineData.MvdDebit().SetOperationSubType("");
        this.mEngineData.MvdDebit().SetReturnedEntries(0);
        this.mEngineData.MvdDebit().SetNumberOfBytes(0);
        if (mxReq instanceof MxDelete) {
            this.mAMDType = "DELETE";
            this.mDNOfTheOriginalRequest = ((MxDelete)mxReq).getDn();
            this.mOriginalRequest = (MxRequest)((MxDelete)mxReq).clone();
        } else if (mxReq instanceof MxAdd) {
            this.mAMDType = "ADD";
            this.mDNOfTheOriginalRequest = ((MxAdd)mxReq).getDn();
            this.mOriginalRequest = (MxRequest)((MxAdd)mxReq).clone();
        } else if (mxReq instanceof MxModify) {
            this.mAMDType = "MODIFY";
            this.mDNOfTheOriginalRequest = ((MxModify)mxReq).getDn();
            this.mOriginalRequest = (MxRequest)((MxModify)mxReq).clone();
        } else if (mxReq instanceof MxCompare) {
            this.mAMDType = "COMPARE";
            this.mDNOfTheOriginalRequest = ((MxCompare)mxReq).getStartingPoint();
            this.mOriginalRequest = (MxRequest)((MxCompare)mxReq).clone();
        }
    }

    protected void DSDependantProhibitionTests() throws MVDException {
        if (this.mDataSource != null) {
            if (this.mAMDType.equals("DELETE")) {
                if (this.mDataSource.DeleteScript().equalsIgnoreCase("None")) {
                    MVDLogger.Log("Script not defined", 2);
                    throw new MVDException(-1044);
                }
            } else if (this.mAMDType.equals("ADD")) {
                if (this.mDataSource.AddScript().equalsIgnoreCase("None")) {
                    MVDLogger.Log("Script not defined", 2);
                    throw new MVDException(-1044);
                }
            } else if (this.mAMDType.equals("MODIFY")) {
                if (this.mDataSource.ModifyScript().equalsIgnoreCase("None")) {
                    MVDLogger.Log("Script not defined", 2);
                    throw new MVDException(-1044);
                }
            } else if (this.mDataSource.CompareScript().equalsIgnoreCase("None")) {
                MVDLogger.Log("Script not defined", 2);
                throw new MVDException(-1044);
            }
        }
    }

    protected void BasicProhibitionTests() throws MVDException {
        if (this.mAcl == null) {
            throw new MVDException(-1071);
        }
        this.mDataSource = this.mAcl.getDataSource();
        this.mDataSourceSequentialGroup = this.mAcl.getDataSourceSequentialGroup();
        this.mProvisioningGroup = this.mAcl.getProvisioningGroup();
        this.mDynamicAddGroup = this.mAcl.getDynamicAddGroup();
        this.mJoinGroup = this.mAcl.getJoinGroup();
        this.mLoadBalancingGroup = this.mAcl.getLoadBalancingGroup();
        this.mFailoverGroup = this.mAcl.getFailoverGroup();
        if (this.mDataSource == null && this.mDataSourceSequentialGroup == null && this.mProvisioningGroup == null && this.mDynamicAddGroup == null && this.mJoinGroup == null && this.mLoadBalancingGroup == null && this.mFailoverGroup == null) {
            MVDLogger.Log("Data source(s) not properly defined (missing)", 2);
            throw new MVDException(-1022);
        }
        boolean bProceed = false;
        bProceed = this.mDynamicAddGroup != null ? this.mDynamicAddGroup.isEnabled() : (this.mJoinGroup != null ? this.mJoinGroup.isEnabled() : (this.mDataSourceSequentialGroup != null ? this.mDataSourceSequentialGroup.IsAllowed() : (this.mProvisioningGroup != null ? this.mProvisioningGroup.IsAllowed() : (this.mLoadBalancingGroup != null ? this.mLoadBalancingGroup.isEnabled() : (this.mFailoverGroup != null ? this.mFailoverGroup.isEnabled() : this.mDataSource.IsAllowed())))));
        if (!bProceed) {
            MVDLogger.Log("Mapping is not enabled", 2);
            throw new MVDException(-1031);
        }
        this.mRule = this.mAcl.FindProperRule(this.mEngineData.MvdDebit().UserName(), this.mDNOfTheOriginalRequest, this.mEngineData.MvdSessionsUserGroup(), this.mEngineData.ExternalSessionGs());
        if (this.mRule == null) {
            MVDUserGroup tempUG;
            MVDUserGroup ug = this.mEngineData.MvdSessionsUserGroup();
            if (!ug.equals(tempUG = MVDUserGroupList.getUGByID(ug.ID()))) {
                this.mEngineData.RefreshUserGroup();
                this.mRule = this.mAcl.FindProperRule(this.mEngineData.MvdDebit().UserName(), this.mDNOfTheOriginalRequest, this.mEngineData.MvdSessionsUserGroup(), this.mEngineData.ExternalSessionGs());
            }
            if (this.mRule == null) {
                MVDLogger.Log("Proper rule couldn't be found", 2);
                throw new MVDException(-1063);
            }
        }
        if (!this.mRule.IsAllowed()) {
            MVDLogger.Log("Proper rule couldn't be found", 2);
            throw new MVDException(-1062);
        }
        if (MVDOpUtilities.IsOperationProhibited(this.mRule, this.mAMDType)) {
            MVDLogger.Log("The operation is not alowed for this user", 2);
            throw new MVDException(-1022);
        }
    }

    protected void GetOperationAcl() throws MVDException {
        String tempStartingPoint = "";
        try {
            tempStartingPoint = MVDUtil.NiceDN(this.mDNOfTheOriginalRequest);
        }
        catch (MVDException ee) {
            MVDLogger.Log("Invalid starting point:" + this.mDNOfTheOriginalRequest, 2);
            throw new MVDException(-1087);
        }
        this.mDNOfTheOriginalRequest = tempStartingPoint;
        this.mEngineData.MvdDebit().SetStartingPoint(this.mDNOfTheOriginalRequest);
        if (MVDProxy.EnforceDNRelation()) {
            this.mEngineData.MvdDebit().SetStartingPoint(this.mDNOfTheOriginalRequest);
            MVDAcl bindNameNode = MVDAcl.getChild(MVDOpUtilities.reverseDN(this.mEngineData.MvdDebit().UserName()), this.mEngineData.MvdSessionsUserGroup().ID());
            if (bindNameNode != null || !MVDUtil.isBellowMe(this.mEngineData.MvdDebit().UserName(), this.mDNOfTheOriginalRequest)) {
                if (MVDLogger.IsLogging(3)) {
                    MVDLogger.Log("Bind DN: '" + this.mEngineData.MvdDebit().UserName() + "' and starting point for " + "operation: '" + this.mDNOfTheOriginalRequest + "' are not related properly", 3);
                }
                throw new MVDException(-1080);
            }
        }
        if (MVDLogger.IsLogging(4)) {
            String tempS = this.mDNOfTheOriginalRequest.length() == 0 ? this.mAMDType + " request: <empty>, " : this.mAMDType + " request: " + this.mDNOfTheOriginalRequest;
            MVDLogger.Log(tempS, 2);
        }
        this.mEngineData.MvdDebit().SetOperationType(this.mAMDType);
        this.mEngineData.MvdDebit().SetOperationSubType("");
        this.mAcl = MVDAcl.getChild(MVDOpUtilities.reverseDN(this.mDNOfTheOriginalRequest), this.mEngineData.MvdSessionsUserGroup().ID());
    }

    public void ExpandHashMap(HashMap h) {
        if (h.toString().indexOf("%") == -1) {
            return;
        }
        MVDDebitInfo tmpD = this.mEngineData.MvdDebit();
        Iterator it = h.keySet().iterator();
        while (it.hasNext()) {
            String sss = (String)it.next();
            String sValue = (String)h.get(sss);
            if (sValue.equalsIgnoreCase("%avail%")) {
                sValue = MVDUtil.replace(sValue, "%avail%", this.mDataSource.ConfiguredAvailableFieldsKeys());
            } else if (sValue.equalsIgnoreCase("%indexed%")) {
                sValue = MVDUtil.replace(sValue, "%indexed%", this.mDataSource.ConfiguredIndexedFieldsKeys());
            } else if (sValue.equalsIgnoreCase("%user%")) {
                sValue = MVDUtil.replace(sValue, "%user%", tmpD.UserName());
            } else if (sValue.equalsIgnoreCase("%pwd%")) {
                sValue = MVDUtil.replace(sValue, "%pwd%", tmpD.UserPwd());
            }
            h.put(sss, sValue);
        }
    }

    protected int CarryOutMVDNodeOperation(Object additionalParam) {
        String str;
        String initScr;
        MVDLogger.Log("*** Starting operation execution phase ***", 2);
        if (MVDLogger.IsLogging(2)) {
            this.logPrefix = "(Node:" + this.mAcl.getQName() + "): ";
            MVDLogger.Log(this.logPrefix + "DN to " + this.mAMDType + ":" + this.mDNOfTheOriginalRequest, 2);
        }
        if ((this.mAMDType.equals("DELETE") || this.mAMDType.equals("MODIFY")) && MVDCachePool.instance().isCacheEnabled()) {
            MVDCachePool.instance().deleteFromCache(this.mDNOfTheOriginalRequest, this.mDataSource.IID());
        }
        if (!(initScr = this.mDataSource.PreOpScript()).equalsIgnoreCase("none")) {
            AbstractOperation o = this.mEngineData.getInitiatedAbstractOperation(initScr, this.mEngineGs);
            if (o == null) {
                this.mGeneralResult.setError(-1044, "");
                return 0;
            }
            MVDHashMap param = new MVDHashMap();
            param.putAll((HashMap)this.mAcl.getParamFields().get("-1"));
            param.putAll(this.mDataSource.ParamFields());
            param.put("DS_UNIQUENAME", this.mDataSource.getUniqueName());
            param.put("DS_DSID", new Integer(this.mDataSource.IID()));
            if (this.mDataSource.EnableMultipleServers()) {
                param = this.mDataSource.getTopMultiServerGroup().getMultiServerParams(this.mDataSource.DSType(), param);
            }
            this.ExpandHashMap(param);
            MVDDebitInfo tmpD = this.mEngineData.MvdDebit();
            param.put("LDAP_USERNAME", tmpD.UserName());
            param.put("LDAP_USERPWD", tmpD.UserPwd());
            param.put("LDAP_CLIENTIP", tmpD.ClientIPAddress());
            param.put("LDAP_VERSION", new Integer(tmpD.Version()));
            try {
                MVDOperationResult res = o.initialize(param);
                if (!res.isOK()) {
                    MVDLogger.Log("Initialize failed !!", 6);
                    this.mGeneralResult.setError(-1044, "");
                    return 0;
                }
            }
            catch (VirtualMachineError vte) {
                Globals.blownAwayByThrowable(vte);
                return 121;
            }
            catch (Throwable ee) {
                MVDLogger.Log("Exception on Initialize:" + ee.getMessage(), 6);
                this.mGeneralResult.setError(-1044, "");
                return 0;
            }
        }
        MVDHashMap param = new MVDHashMap();
        param.putAll(MVDProxy.MVDGlobals());
        HashMap mypf = (HashMap)this.mAcl.getParamFields().get("" + this.mDataSource.IID());
        if (mypf == null) {
            mypf = (HashMap)this.mAcl.getParamFields().get("-1");
        }
        param.putAll(mypf);
        param.putAll((HashMap)this.mAcl.getParamFields().get("-1"));
        param.putAll(this.mDataSource.ParamFields());
        param.put("DS_UNIQUENAME", this.mDataSource.getUniqueName());
        param.put("DS_DSID", new Integer(this.mDataSource.IID()));
        if (this.mDataSource.EnableMultipleServers()) {
            param = this.mDataSource.getTopMultiServerGroup().getMultiServerParams(this.mDataSource.DSType(), param);
        }
        this.ExpandHashMap(param);
        param.put("LDAP_DN", this.mDNOfTheOriginalRequest);
        param.put("NODE__QNAME", MVDOpUtilities.reverseDN(this.mAcl.getQName()));
        param.put("NODE__OBJECTCLASS", this.mAcl.getObjectClass());
        if (this.mAMDType.equals("DELETE")) {
            str = this.mDataSource.DeleteScript();
        } else if (this.mAMDType.equals("ADD")) {
            param.put("LDAP_DATA", additionalParam);
            str = this.mDataSource.AddScript();
        } else if (this.mAMDType.equals("MODIFY")) {
            param.put("LDAP_DATA", additionalParam);
            str = this.mDataSource.ModifyScript();
        } else {
            param.putAll((HashMap)additionalParam);
            str = this.mDataSource.CompareScript();
        }
        AbstractOperation opObject = this.mEngineData.getInitiatedAbstractOperation(str, this.mEngineGs);
        if (opObject == null) {
            return 0;
        }
        try {
            this.mGeneralResult = this.mAMDType.equals("DELETE") ? opObject.delete(param) : (this.mAMDType.equals("ADD") ? opObject.add(param) : (this.mAMDType.equals("MODIFY") ? opObject.modify(param) : opObject.compare(param)));
        }
        catch (Throwable ee) {
            MVDLogger.Log("Exception when executing '" + str + "'(" + this.mAMDType + "): " + ee.getMessage(), 7, ee);
        }
        if (this.mDataSource.EnableMultipleServers()) {
            boolean bDataSourceIsUnavailable = MxResultCodes.isUnavailable(this.mGeneralResult.getCode());
            if (this.mDataSource.getTopMultiServerGroup().setNextDS(this.mDataSource, bDataSourceIsUnavailable) < 0L) {
                return -999;
            }
        }
        return 0;
    }

    protected void handleEvents() {
        if (this.mDataSource == null) {
            return;
        }
        Vector triggers = this.mDataSource.getTriggers();
        for (int i = 0; i < triggers.size(); ++i) {
            EventTriggerConfig trigger = (EventTriggerConfig)triggers.elementAt(i);
            MVDUserGroup ug = this.mEngineData.MvdSessionsUserGroup();
            if (ug.isInternal()) {
                ug = this.mEngineData.getOnBehalfOf();
            }
            if (!trigger.isEnabled() || !trigger.doEvaluation(ug.ID(), this.mOriginalRequest, this.mGeneralResult.isOK())) continue;
            EventHandler.evaluateTrigger(this.mOriginalRequest, trigger, 0, this.mGeneralResult);
        }
    }

    private void SetLdapErrorCode() {
        String tmpName = "STATIC";
        tmpName = this.mDataSourceSequentialGroup != null ? this.mDataSourceSequentialGroup.NiceName() : (this.mDynamicAddGroup != null ? this.mDynamicAddGroup.getName() : (this.mJoinGroup != null ? this.mJoinGroup.getName() : (this.mProvisioningGroup != null ? this.mProvisioningGroup.getName() : (this.mLoadBalancingGroup != null ? this.mLoadBalancingGroup.getName() : (this.mFailoverGroup != null ? this.mFailoverGroup.getName() : this.mDataSource.NiceName())))));
        if (!this.mGeneralResult.isOK()) {
            int opRes = this.mGeneralResult.getCode();
            if (opRes > -1000) {
                this.mErrorNumber = opRes;
                this.mErrorMessage = "(" + tmpName + ":" + this.mErrorNumber + ":" + this.mGeneralResult.getMessage() + ")";
            } else {
                this.mErrorNumber = MVDError.GetMapping(opRes);
                this.mErrorMessage = "(" + tmpName + ":" + this.mErrorNumber + ":" + MVDError.GetAdditionalInfo(opRes) + ")";
            }
        } else {
            int opRes = this.mGeneralResult.getCode();
            if (opRes > -1000) {
                this.mErrorNumber = opRes;
                this.mErrorMessage = "(" + tmpName + ":" + this.mErrorNumber + ":" + this.mGeneralResult.getMessage() + ")";
            } else {
                this.mErrorNumber = 0;
                this.mErrorMessage = "";
            }
        }
    }

    protected void FetchResultCode() throws MVDException {
        MVDLogger.Log("*** Fetch result code ***", 2);
        if (this.mErrorNumber != 0) {
            this.SetLdapErrorCode();
            MVDLogger.Log("Operation result: " + this.mErrorNumber, 4);
            throw new MVDException(this.mErrorNumber, this.mErrorMessage);
        }
        MVDLogger.Log("Operation result: 0", 4);
    }
}

