/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.operations;

import com.sap.idm.vds.Engine;
import com.sap.idm.vds.MVDException;
import com.sap.idm.vds.MxLDAPBindException;
import com.sap.idm.vds.message.MxBind;
import com.sap.idm.vds.message.MxRequest;
import com.sap.idm.vds.message.MxResponse;
import com.sap.idm.vds.operations.MVDBindOperation;

public class BindOperation {
    int mAuthType = 0;
    MVDBindOperation mvdBindOperation = null;

    public BindOperation(MxRequest mxrequest, Engine aEng, String aIPAddress) {
        if (mxrequest != null) {
            this.mvdBindOperation = new MVDBindOperation(mxrequest, aEng);
            this.mAuthType = ((MxBind)mxrequest).getAuthType();
        } else {
            this.mvdBindOperation = new MVDBindOperation(aEng, aIPAddress);
        }
    }

    public MxResponse mxperform() throws MxLDAPBindException {
        int aCode = 49;
        String aMessage = "Invalid credentials";
        MxResponse lm = new MxResponse();
        try {
            MxResponse br = this.mvdBindOperation.MxBindAttempt();
            return br;
        }
        catch (MVDException e) {
            int opRes = e.errNumber();
            if (e.errNumber() == -1055) {
                throw new MxLDAPBindException(opRes, e.errMessage());
            }
            aCode = 49;
            aMessage = "Invalid credentials:" + e.errMessage();
            lm.setError(aCode, aMessage);
        }
        catch (Exception e) {
            aCode = 49;
            aMessage = "Invalid credentials:" + e.getMessage();
            lm.setError(aCode, aMessage);
        }
        return lm;
    }

    public MxResponse mximplicitperform() throws MxLDAPBindException {
        int aCode = 49;
        String aMessage = "Invalid credentials";
        MxResponse lm = new MxResponse();
        try {
            MxResponse br = this.mvdBindOperation.MxBindAttempt();
            return br;
        }
        catch (MVDException e) {
            int opRes = e.errNumber();
            if (e.errNumber() == -1055) {
                throw new MxLDAPBindException(opRes, e.errMessage());
            }
            aCode = 49;
            aMessage = "Invalid credentials:" + e.errMessage();
            lm.setError(aCode, aMessage);
        }
        catch (Exception e) {
            aCode = 49;
            aMessage = "Invalid credentials:" + e.getMessage();
            lm.setError(aCode, aMessage);
        }
        return lm;
    }
}

