/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.message;

import com.sap.idm.vds.MVDUtil;
import com.sap.idm.vds.MVDUtilities;
import com.sap.idm.vds.config.MVDProxy;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class MxAttrSet
implements Cloneable {
    protected HashMap mAttrAndValues;

    public MxAttrSet() {
        this.mAttrAndValues = new HashMap();
    }

    public MxAttrSet(HashMap aHashMap) {
        this.mAttrAndValues = aHashMap;
    }

    public Object clone() throws CloneNotSupportedException {
        MxAttrSet clonedHashMap = (MxAttrSet)super.clone();
        clonedHashMap.mAttrAndValues = (HashMap)this.mAttrAndValues.clone();
        Iterator iter = clonedHashMap.mAttrAndValues.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            Vector v = (Vector)clonedHashMap.mAttrAndValues.get(key);
            if (v.size() == 0) {
                clonedHashMap.mAttrAndValues.put(key, new Vector(1, 1));
                continue;
            }
            if (v.elementAt(0) instanceof String) {
                clonedHashMap.mAttrAndValues.put(key, new Vector(v));
                continue;
            }
            Vector<byte[]> att = new Vector<byte[]>(v.size());
            for (int i = 0; i < v.size(); ++i) {
                byte[] src = (byte[])v.elementAt(i);
                byte[] b = new byte[src.length];
                System.arraycopy(src, 0, b, 0, src.length);
                att.add(b);
            }
            clonedHashMap.mAttrAndValues.put(key, att);
        }
        return clonedHashMap;
    }

    public void appendAttrAndValues(HashMap aHash) {
        if (aHash != null) {
            this.mAttrAndValues.putAll(aHash);
        }
    }

    public HashMap getAttrAndValues() {
        return this.mAttrAndValues;
    }

    public void setAttrAndValues(HashMap aHash) {
        this.mAttrAndValues = aHash;
    }

    public boolean containsKey(String aString) {
        return this.mAttrAndValues.containsKey(aString);
    }

    public Vector getAttrValues(String aAttrName) {
        return (Vector)this.mAttrAndValues.get(aAttrName.toLowerCase());
    }

    public void setAttrValue(String aAttrName, boolean aAppend, Vector aAttrValue) {
        aAttrName = aAttrName.toLowerCase();
        if (aAppend) {
            this.appendAttrValue(aAttrName, aAttrValue);
        } else {
            this.mAttrAndValues.put(aAttrName, aAttrValue);
        }
    }

    public void setAttrValue(String aAttrName, boolean aAppend, String aMultiAttrValue, String aSeparator) {
        Vector<Object> toAdd = new Vector<Object>(3, 1);
        Vector split = MVDUtil.splitString(aMultiAttrValue, aSeparator);
        int ls = split.size();
        for (int i = 0; i < ls; ++i) {
            String oneValue = (String)split.elementAt(i);
            if (oneValue.startsWith("{HEX}")) {
                toAdd.add(MVDUtil.hexToByte(oneValue.substring(5)));
                continue;
            }
            toAdd.add(oneValue);
        }
        this.setAttrValue(aAttrName, aAppend, toAdd);
    }

    public void setAttrValue(String aAttrName, boolean aAppend, byte[] aAttrValue) {
        Vector<byte[]> temp = new Vector<byte[]>(1, 1);
        temp.add(aAttrValue);
        this.setAttrValue(aAttrName, aAppend, temp);
    }

    public void setAttrValue(String aAttrName, boolean aAppend, String aAttrValue) {
        Vector<Object> temp = new Vector<Object>(1, 1);
        if (aAttrValue.startsWith("{HEX}")) {
            temp.add(MVDUtil.hexToByte(aAttrValue.substring(5)));
        } else {
            temp.add(aAttrValue);
        }
        this.setAttrValue(aAttrName, aAppend, temp);
    }

    public void replaceAttrValue(String aAttrName, String aOldValue, String aNewValue) {
        Object oneA = null;
        Vector v = this.getAttrValues(aAttrName);
        MVDUtil.replaceVectorValue(v, aOldValue, aNewValue);
    }

    public void replaceAttrValue(String aAttrName, HashMap aTheValues) {
        Object oneA = null;
        Iterator it = aTheValues.keySet().iterator();
        while (it.hasNext()) {
            String oldValue = (String)it.next();
            String newValue = (String)aTheValues.get(oldValue);
            this.replaceAttrValue(aAttrName, oldValue, newValue);
        }
    }

    public String getFirstAttrValue(String aAttrName) {
        Vector v = this.getAttrValues(aAttrName);
        if (v == null) {
            return null;
        }
        Object temp = v.elementAt(0);
        if (temp instanceof String) {
            return (String)temp;
        }
        return null;
    }

    private void appendAttrValue(String aAttrName, Vector aAttrValue) {
        Vector<String> temp = (Vector<String>)this.mAttrAndValues.get(aAttrName);
        if (temp == null) {
            temp = new Vector<String>(aAttrValue.size(), 1);
            temp.addAll(aAttrValue);
            this.mAttrAndValues.put(aAttrName, temp);
        } else if (!MVDProxy.IsBinaryAttribute(aAttrName)) {
            String a = "";
            String b = "";
            int origSize = temp.size();
            for (int i = 0; i < aAttrValue.size(); ++i) {
                a = (String)aAttrValue.elementAt(i);
                boolean bFound = false;
                for (int j = 0; j < origSize; ++j) {
                    b = (String)temp.elementAt(j);
                    if (!b.equalsIgnoreCase(a)) continue;
                    bFound = true;
                    break;
                }
                if (bFound) continue;
                temp.add(a);
            }
        } else {
            temp.addAll(aAttrValue);
        }
    }

    public void constructAttrValue(String aAttrName, Vector aAttrToUse, String aDelimiter) {
        int ls = aAttrToUse.size();
        String aValue = "";
        for (int x = 0; x < ls; ++x) {
            if (aValue.length() > 0) {
                aValue = aValue + aDelimiter;
            }
            aValue = aValue + aAttrToUse.elementAt(x);
        }
        this.setAttrValue(aAttrName, true, aValue);
    }

    public Vector getAttributes() {
        return new Vector(this.mAttrAndValues.keySet());
    }

    public void fixDNSyntaxAttributes(Vector aAttributes, String aVirtSP, String aRealSP) {
        HashMap hm = this.mAttrAndValues;
        for (int x = 0; x < aAttributes.size(); ++x) {
            String candidate = ((String)aAttributes.elementAt(x)).toLowerCase();
            Vector v = (Vector)hm.get(candidate);
            if (v == null) continue;
            for (int y = 0; y < v.size(); ++y) {
                String t = (String)v.elementAt(y);
                try {
                    t = MVDUtil.NiceDN(t);
                }
                catch (Exception e) {
                    // empty catch block
                }
                t = MVDUtilities.fixStartingPoint(t, aVirtSP, aRealSP);
                v.setElementAt(t, y);
            }
        }
    }

    public static void main(String[] aArgs) {
        MxAttrSet m1 = new MxAttrSet();
        Object m2 = null;
        MxAttrSet m3 = null;
        m1.setAttrValue("misa", true, "abc,def", ",");
        Vector<byte[]> v = new Vector<byte[]>();
        v.add(MVDUtil.ToUTF8("jokic"));
        v.add(MVDUtil.ToUTF8("bytesar"));
        m1.setAttrValue("jokic", true, v);
        try {
            m3 = (MxAttrSet)m1.clone();
        }
        catch (Exception e) {
            // empty catch block
        }
        boolean x = true;
    }
}

