/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.ldapv3;

import com.sap.idm.vds.MVDUtil;
import com.sap.idm.vds.asn1.ASN1Decoder;
import com.sap.idm.vds.asn1.ASN1Encoder;
import com.sap.idm.vds.asn1.ASN1Exception;
import com.sap.idm.vds.ldapv3.LDAPv3;
import com.sap.idm.vds.ldapv3.SubstringFilterSeqOfChoice;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Vector;

public class SubstringFilterSeqOf
extends Vector
implements LDAPv3 {
    public SubstringFilterSeqOf() {
    }

    public SubstringFilterSeqOf(SubstringFilterSeqOf arg) {
        int ls = arg.size();
        for (int x = 0; x < ls; ++x) {
            this.addElement(new SubstringFilterSeqOfChoice((SubstringFilterSeqOfChoice)arg.elementAt(x)));
        }
    }

    public SubstringFilterSeqOf(String mal) {
        Vector v3 = MVDUtil.splitString(mal, "*");
        int ls = v3.size();
        int uselast = ls - 1;
        String thePart = (String)v3.elementAt(0);
        if (thePart.length() > 0) {
            this.addElement(new SubstringFilterSeqOfChoice(thePart + "*"));
        }
        for (int x = 1; x < ls - 1; ++x) {
            thePart = (String)v3.elementAt(x);
            if (thePart.length() <= 0) continue;
            this.addElement(new SubstringFilterSeqOfChoice("*" + thePart + "*"));
        }
        thePart = (String)v3.elementAt(ls - 1);
        if (thePart.length() > 0) {
            this.addElement(new SubstringFilterSeqOfChoice("*" + thePart));
        }
    }

    public void decode(ASN1Decoder dec) throws ASN1Exception {
        int seq_of_nr = dec.decodeSequenceOf();
        while (!dec.endOf(seq_of_nr)) {
            SubstringFilterSeqOfChoice tmp = new SubstringFilterSeqOfChoice();
            tmp.decode(dec);
            this.addElement(tmp);
        }
    }

    public void encode(ASN1Encoder enc) throws ASN1Exception {
        int seq_of_nr = enc.encodeSequenceOf();
        int ls = this.size();
        for (int x = 0; x < ls; ++x) {
            ((SubstringFilterSeqOfChoice)this.elementAt(x)).encode(enc);
        }
        enc.endOf(seq_of_nr);
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public void print(PrintStream os, int indent) {
        boolean nonePrinted = true;
        os.println("{ -- SEQUENCE OF --");
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            if (!nonePrinted) {
                os.println(',');
            }
            nonePrinted = false;
            for (int ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            ((SubstringFilterSeqOfChoice)e.nextElement()).print(os, indent + 2);
            if (e.hasMoreElements()) continue;
            os.println();
        }
        for (int ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }
}

