/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.ldapv3;

import com.sap.idm.vds.asn1.ASN1Decoder;
import com.sap.idm.vds.asn1.ASN1Encoder;
import com.sap.idm.vds.asn1.ASN1Exception;
import com.sap.idm.vds.asn1.util.HexOutputStream;
import com.sap.idm.vds.ldapv3.LDAPv3;
import com.sap.idm.vds.ldapv3.PartialAttributeList;
import java.io.IOException;
import java.io.PrintStream;

public class SearchResultEntry
implements LDAPv3 {
    public byte[] objectName;
    public PartialAttributeList attributes = new PartialAttributeList();

    public SearchResultEntry() {
    }

    public SearchResultEntry(SearchResultEntry arg) {
        this.objectName = new byte[arg.objectName.length];
        System.arraycopy(arg.objectName, 0, this.objectName, 0, arg.objectName.length);
        this.attributes = new PartialAttributeList(arg.attributes);
    }

    public void decode(ASN1Decoder dec) throws ASN1Exception {
        dec.nextIsImplicit(ASN1Decoder.makeTag(1, 4));
        int seq_nr = dec.decodeSequence();
        this.objectName = dec.decodeOctetString();
        this.attributes.decode(dec);
        dec.endOf(seq_nr);
    }

    public void encode(ASN1Encoder enc) throws ASN1Exception {
        enc.nextIsImplicit(ASN1Encoder.makeTag(1, 4));
        int seq_nr = enc.encodeSequence();
        enc.encodeOctetString(this.objectName);
        this.attributes.encode(enc);
        enc.endOf(seq_nr);
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (int ii2 = 0; ii2 < indent + 2; ++ii2) {
            os.print(' ');
        }
        os.print("objectName = ");
        try {
            new HexOutputStream(os).write(this.objectName);
        }
        catch (IOException ex) {
            os.print("( unprintable OCTET STRING value )");
        }
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("attributes = ");
        this.attributes.print(os, indent + 2);
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }
}

