/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.ldapv3;

import com.sap.idm.vds.asn1.ASN1Decoder;
import com.sap.idm.vds.asn1.ASN1Encoder;
import com.sap.idm.vds.asn1.ASN1Exception;
import com.sap.idm.vds.asn1.util.HexOutputStream;
import com.sap.idm.vds.ldapv3.AttributeDescriptionList;
import com.sap.idm.vds.ldapv3.Filter;
import com.sap.idm.vds.ldapv3.LDAPv3;
import com.sap.idm.vds.ldapv3.SearchRequestEnum;
import com.sap.idm.vds.ldapv3.SearchRequestEnum1;
import java.io.IOException;
import java.io.PrintStream;
import java.math.BigInteger;

public class SearchRequest
implements LDAPv3 {
    public byte[] baseObject;
    public SearchRequestEnum scope = new SearchRequestEnum();
    public SearchRequestEnum1 derefAliases = new SearchRequestEnum1();
    public BigInteger sizeLimit;
    public BigInteger timeLimit;
    public boolean typesOnly;
    public Filter filter = new Filter();
    public AttributeDescriptionList attributes = new AttributeDescriptionList();

    public SearchRequest() {
    }

    public SearchRequest(SearchRequest arg) {
        this.baseObject = new byte[arg.baseObject.length];
        System.arraycopy(arg.baseObject, 0, this.baseObject, 0, arg.baseObject.length);
        this.scope = new SearchRequestEnum(arg.scope);
        this.derefAliases = new SearchRequestEnum1(arg.derefAliases);
        this.sizeLimit = arg.sizeLimit;
        this.timeLimit = arg.timeLimit;
        this.typesOnly = arg.typesOnly;
        this.filter = new Filter(arg.filter);
        this.attributes = new AttributeDescriptionList(arg.attributes);
    }

    public void decode(ASN1Decoder dec) throws ASN1Exception {
        dec.nextIsImplicit(ASN1Decoder.makeTag(1, 3));
        int seq_nr = dec.decodeSequence();
        this.baseObject = dec.decodeOctetString();
        this.scope.decode(dec);
        this.derefAliases.decode(dec);
        this.sizeLimit = dec.decodeInteger();
        this.timeLimit = dec.decodeInteger();
        this.typesOnly = dec.decodeBoolean();
        this.filter.decode(dec);
        this.attributes.decode(dec);
        dec.endOf(seq_nr);
    }

    public void encode(ASN1Encoder enc) throws ASN1Exception {
        enc.nextIsImplicit(ASN1Encoder.makeTag(1, 3));
        int seq_nr = enc.encodeSequence();
        enc.encodeOctetString(this.baseObject);
        this.scope.encode(enc);
        this.derefAliases.encode(enc);
        enc.encodeInteger(this.sizeLimit);
        enc.encodeInteger(this.timeLimit);
        enc.encodeBoolean(this.typesOnly);
        this.filter.encode(enc);
        this.attributes.encode(enc);
        enc.endOf(seq_nr);
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (int ii2 = 0; ii2 < indent + 2; ++ii2) {
            os.print(' ');
        }
        os.print("baseObject = ");
        try {
            new HexOutputStream(os).write(this.baseObject);
        }
        catch (IOException ex) {
            os.print("( unprintable OCTET STRING value )");
        }
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("scope = ");
        this.scope.print(os, indent + 2);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("derefAliases = ");
        this.derefAliases.print(os, indent + 2);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("sizeLimit = ");
        os.print(this.sizeLimit.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("timeLimit = ");
        os.print(this.timeLimit.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("typesOnly = ");
        os.print(this.typesOnly);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("filter = ");
        this.filter.print(os, indent + 2);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("attributes = ");
        this.attributes.print(os, indent + 2);
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }
}

