/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.ldapv3;

import com.sap.idm.vds.asn1.ASN1Decoder;
import com.sap.idm.vds.asn1.ASN1Encoder;
import com.sap.idm.vds.asn1.ASN1Exception;
import com.sap.idm.vds.asn1.util.HexOutputStream;
import com.sap.idm.vds.ldapv3.LDAPv3;
import java.io.IOException;
import java.io.PrintStream;

public class SaslCredentials
implements LDAPv3 {
    public byte[] mechanism;
    public byte[] credentials = null;

    public SaslCredentials() {
    }

    public SaslCredentials(SaslCredentials arg) {
        this.mechanism = new byte[arg.mechanism.length];
        System.arraycopy(arg.mechanism, 0, this.mechanism, 0, arg.mechanism.length);
        this.credentials = new byte[arg.credentials.length];
        System.arraycopy(arg.credentials, 0, this.credentials, 0, arg.credentials.length);
    }

    public void decode(ASN1Decoder dec) throws ASN1Exception {
        int seq_nr = dec.decodeSequence();
        this.mechanism = dec.decodeOctetString();
        if (!dec.nextIsOptional(ASN1Decoder.makeTag(0, 4))) {
            this.credentials = dec.decodeOctetString();
        }
        dec.endOf(seq_nr);
    }

    public void encode(ASN1Encoder enc) throws ASN1Exception {
        int seq_nr = enc.encodeSequence();
        enc.encodeOctetString(this.mechanism);
        if (this.credentials != null) {
            enc.encodeOctetString(this.credentials);
        }
        enc.endOf(seq_nr);
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public void print(PrintStream os, int indent) {
        os.println("{ -- SEQUENCE --");
        for (int ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("mechanism = ");
        try {
            new HexOutputStream(os).write(this.mechanism);
        }
        catch (IOException ex) {
            os.print("( unprintable OCTET STRING value )");
        }
        os.println(',');
        if (this.credentials != null) {
            for (int ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("credentials = ");
            try {
                new HexOutputStream(os).write(this.credentials);
            }
            catch (IOException ex) {
                os.print("( unprintable OCTET STRING value )");
            }
        }
        os.println();
        for (int ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }
}

