/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.ldapv3;

import com.sap.idm.vds.asn1.ASN1Decoder;
import com.sap.idm.vds.asn1.ASN1Encoder;
import com.sap.idm.vds.asn1.ASN1Exception;
import com.sap.idm.vds.asn1.util.HexOutputStream;
import com.sap.idm.vds.ldapv3.LDAPv3;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Vector;

public class PartialAttributeListSeqSetOf
extends Vector
implements LDAPv3 {
    public PartialAttributeListSeqSetOf() {
    }

    public PartialAttributeListSeqSetOf(Vector arg) {
        super(arg);
    }

    public PartialAttributeListSeqSetOf(PartialAttributeListSeqSetOf arg) {
        int ls = arg.size();
        for (int x = 0; x < ls; ++x) {
            byte[] tmp = (byte[])arg.elementAt(x);
            byte[] newOne = new byte[tmp.length];
            System.arraycopy(tmp, 0, newOne, 0, tmp.length);
            this.addElement(newOne);
        }
    }

    public void decode(ASN1Decoder dec) throws ASN1Exception {
        int set_of_nr = dec.decodeSetOf();
        while (!dec.endOf(set_of_nr)) {
            byte[] tmp = dec.decodeOctetString();
            this.add(tmp);
        }
    }

    public void encode(ASN1Encoder enc) throws ASN1Exception {
        int set_of_nr = enc.encodeSetOf();
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            enc.encodeOctetString((byte[])e.nextElement());
        }
        enc.endOf(set_of_nr);
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public void print(PrintStream os, int indent) {
        boolean nonePrinted = true;
        os.println("{ -- SET OF --");
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            if (!nonePrinted) {
                os.println(',');
            }
            nonePrinted = false;
            for (int ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            try {
                new HexOutputStream(os).write((byte[])e.nextElement());
            }
            catch (IOException ex) {
                os.print("( unprintable OCTET STRING value )");
            }
            if (e.hasMoreElements()) continue;
            os.println();
        }
        for (int ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }
}

