/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.ldapv3;

import com.sap.idm.vds.MVDUtil;
import com.sap.idm.vds.asn1.ASN1Decoder;
import com.sap.idm.vds.asn1.ASN1Encoder;
import com.sap.idm.vds.asn1.ASN1Exception;
import com.sap.idm.vds.asn1.util.HexOutputStream;
import com.sap.idm.vds.ldapv3.LDAPv3;
import com.sap.idm.vds.ldapv3.PartialAttributeListSeqSetOf;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class PartialAttributeList
extends HashMap
implements LDAPv3 {
    public PartialAttributeList() {
    }

    public PartialAttributeList(HashMap arg) {
        super(arg);
    }

    public PartialAttributeList(HashMap arg, boolean typesOnly) {
        if (typesOnly) {
            Iterator ae = arg.keySet().iterator();
            while (ae.hasNext()) {
                this.put(ae.next(), null);
            }
        }
    }

    public void decode(ASN1Decoder dec) throws ASN1Exception {
        int seq_of_nr = dec.decodeSequenceOf();
        while (!dec.endOf(seq_of_nr)) {
            int seq_nr = dec.decodeSequence();
            byte[] type = dec.decodeOctetString();
            int set_of_nr = dec.decodeSetOf();
            Vector<byte[]> vals = (Vector<byte[]>)this.get(type);
            if (vals == null) {
                vals = new Vector<byte[]>();
            }
            while (!dec.endOf(set_of_nr)) {
                byte[] tmp = dec.decodeOctetString();
                vals.add(tmp);
            }
            dec.endOf(seq_nr);
            this.put(type, vals);
        }
    }

    public void encode(ASN1Encoder enc) throws ASN1Exception {
        int seq_of_nr = enc.encodeSequenceOf();
        Iterator ae = this.keySet().iterator();
        while (ae.hasNext()) {
            int seq_nr = enc.encodeSequence();
            Object type = ae.next();
            if (type instanceof String) {
                enc.encodeOctetString(MVDUtil.ToUTF8((String)type));
            } else {
                enc.encodeOctetString((byte[])type);
            }
            int attrValuesSeqNr = enc.encodeSetOf();
            Vector vals = (Vector)this.get(type);
            if (vals != null) {
                int ls = vals.size();
                for (int x = 0; x < ls; ++x) {
                    Object temp = vals.elementAt(x);
                    if (temp instanceof String) {
                        try {
                            enc.encodeOctetString(((String)temp).getBytes("UTF-8"));
                        }
                        catch (UnsupportedEncodingException e) {
                            enc.encodeOctetString(MVDUtil.ToUTF8((String)temp));
                        }
                        continue;
                    }
                    enc.encodeOctetString((byte[])temp);
                }
            }
            enc.endOf(attrValuesSeqNr);
            enc.endOf(seq_nr);
        }
        enc.endOf(seq_of_nr);
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public void print(PrintStream os, int indent) {
        boolean nonePrinted = true;
        os.println("{ -- SEQUENCE OF --");
        Iterator e = this.keySet().iterator();
        while (e.hasNext()) {
            int ii;
            byte[] type = (byte[])e.next();
            PartialAttributeListSeqSetOf vals = (PartialAttributeListSeqSetOf)this.get(type);
            if (!nonePrinted) {
                os.println(',');
            }
            nonePrinted = false;
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.println("{ -- SEQUENCE --");
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("type = ");
            try {
                new HexOutputStream(os).write(type);
            }
            catch (IOException ex) {
                os.print("( unprintable OCTET STRING value )");
            }
            os.println(',');
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("vals = ");
            vals.print(os, indent + 2);
            os.println();
            for (ii = 0; ii < indent; ++ii) {
                os.print(' ');
            }
            os.print('}');
            if (e.hasNext()) continue;
            os.println();
        }
        for (int ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }
}

