/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.ldapv3;

import com.sap.idm.vds.asn1.ASN1Decoder;
import com.sap.idm.vds.asn1.ASN1Encoder;
import com.sap.idm.vds.asn1.ASN1Exception;
import com.sap.idm.vds.asn1.util.HexOutputStream;
import com.sap.idm.vds.ldapv3.LDAPv3;
import java.io.IOException;
import java.io.PrintStream;

public class ModifyDNRequest
implements LDAPv3 {
    public byte[] entry;
    public byte[] newrdn;
    public boolean deleteoldrdn;
    public byte[] newSuperior = null;

    public ModifyDNRequest() {
    }

    public ModifyDNRequest(ModifyDNRequest arg) {
        this.entry = new byte[arg.entry.length];
        System.arraycopy(arg.entry, 0, this.entry, 0, arg.entry.length);
        this.newrdn = new byte[arg.newrdn.length];
        System.arraycopy(arg.newrdn, 0, this.newrdn, 0, arg.newrdn.length);
        this.deleteoldrdn = arg.deleteoldrdn;
        this.newSuperior = new byte[arg.newSuperior.length];
        System.arraycopy(arg.newSuperior, 0, this.newSuperior, 0, arg.newSuperior.length);
    }

    public void decode(ASN1Decoder dec) throws ASN1Exception {
        dec.nextIsImplicit(ASN1Decoder.makeTag(1, 12));
        int seq_nr = dec.decodeSequence();
        this.entry = dec.decodeOctetString();
        this.newrdn = dec.decodeOctetString();
        this.deleteoldrdn = dec.decodeBoolean();
        if (!dec.nextIsOptional(ASN1Decoder.makeTag(2, 0))) {
            dec.nextIsImplicit(ASN1Decoder.makeTag(2, 0));
            this.newSuperior = dec.decodeOctetString();
        }
        dec.endOf(seq_nr);
    }

    public void encode(ASN1Encoder enc) throws ASN1Exception {
        enc.nextIsImplicit(ASN1Encoder.makeTag(1, 12));
        int seq_nr = enc.encodeSequence();
        enc.encodeOctetString(this.entry);
        enc.encodeOctetString(this.newrdn);
        enc.encodeBoolean(this.deleteoldrdn);
        if (this.newSuperior != null) {
            enc.nextIsImplicit(ASN1Encoder.makeTag(2, 0));
            enc.encodeOctetString(this.newSuperior);
        }
        enc.endOf(seq_nr);
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (int ii2 = 0; ii2 < indent + 2; ++ii2) {
            os.print(' ');
        }
        os.print("entry = ");
        try {
            new HexOutputStream(os).write(this.entry);
        }
        catch (IOException ex) {
            os.print("( unprintable OCTET STRING value )");
        }
        os.println(',');
        for (int ii3 = 0; ii3 < indent + 2; ++ii3) {
            os.print(' ');
        }
        os.print("newrdn = ");
        try {
            new HexOutputStream(os).write(this.newrdn);
        }
        catch (IOException ex) {
            os.print("( unprintable OCTET STRING value )");
        }
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("deleteoldrdn = ");
        os.print(this.deleteoldrdn);
        os.println(',');
        if (this.newSuperior != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("newSuperior = ");
            try {
                new HexOutputStream(os).write(this.newSuperior);
            }
            catch (IOException ex) {
                os.print("( unprintable OCTET STRING value )");
            }
        }
        os.println();
        for (int ii4 = 0; ii4 < indent; ++ii4) {
            os.print(' ');
        }
        os.print('}');
    }
}

