/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.ldapv3;

import com.sap.idm.vds.asn1.ASN1Decoder;
import com.sap.idm.vds.asn1.ASN1Encoder;
import com.sap.idm.vds.asn1.ASN1Exception;
import com.sap.idm.vds.ldapv3.Controls;
import com.sap.idm.vds.ldapv3.LDAPMessageChoice;
import com.sap.idm.vds.ldapv3.LDAPv3;
import java.io.PrintStream;
import java.math.BigInteger;

public class LDAPMessage
implements LDAPv3 {
    public BigInteger messageID;
    public LDAPMessageChoice protocolOp = new LDAPMessageChoice();
    public Controls controls = null;

    public LDAPMessage() {
    }

    public LDAPMessage(LDAPMessage arg) {
        this.messageID = arg.messageID;
        this.protocolOp = new LDAPMessageChoice(arg.protocolOp);
        this.controls = new Controls(arg.controls);
    }

    public void decode(ASN1Decoder dec) throws ASN1Exception {
        int seq_nr = dec.decodeSequence();
        this.messageID = dec.decodeInteger();
        this.protocolOp.decode(dec);
        int tag = ASN1Decoder.makeTag(2, 0);
        if (!dec.nextIsOptional(tag)) {
            this.controls = new Controls();
            dec.nextIsImplicit(tag);
            this.controls.decode(dec);
        }
        dec.endOf(seq_nr);
    }

    public void encode(ASN1Encoder enc) throws ASN1Exception {
        int seq_nr = enc.encodeSequence();
        enc.encodeInteger(this.messageID);
        this.protocolOp.encode(enc);
        if (this.controls != null) {
            enc.nextIsImplicit(ASN1Encoder.makeTag(2, 0));
            this.controls.encode(enc);
        }
        enc.endOf(seq_nr);
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("messageID = ");
        os.print(this.messageID.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("protocolOp = ");
        this.protocolOp.print(os, indent + 2);
        os.println(',');
        if (this.controls != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("controls = ");
            this.controls.print(os, indent + 2);
        }
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }
}

