/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.ldapv3;

import com.sap.idm.vds.MVDUtil;
import com.sap.idm.vds.asn1.ASN1Decoder;
import com.sap.idm.vds.asn1.ASN1Encoder;
import com.sap.idm.vds.asn1.ASN1Exception;
import com.sap.idm.vds.asn1.util.HexOutputStream;
import com.sap.idm.vds.config.MVDDataSource;
import com.sap.idm.vds.config.MVDProxy;
import com.sap.idm.vds.ldapv3.AttributeValueAssertion;
import com.sap.idm.vds.ldapv3.FilterSetOf;
import com.sap.idm.vds.ldapv3.FilterSetOf1;
import com.sap.idm.vds.ldapv3.LDAPv3;
import com.sap.idm.vds.ldapv3.MatchingRuleAssertion;
import com.sap.idm.vds.ldapv3.SubstringFilter;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Vector;

public class Filter
implements LDAPv3 {
    public static final int AND_CID = 0;
    public static final int OR_CID = 1;
    public static final int NOT_CID = 2;
    public static final int EQUALITYMATCH_CID = 3;
    public static final int SUBSTRINGS_CID = 4;
    public static final int GREATEROREQUAL_CID = 5;
    public static final int LESSOREQUAL_CID = 6;
    public static final int PRESENT_CID = 7;
    public static final int APPROXMATCH_CID = 8;
    public static final int EXTENSIBLEMATCH_CID = 9;
    int[] tag_list = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
    public int choiceId;
    public FilterSetOf and = null;
    public FilterSetOf1 or = null;
    public Filter not = null;
    public AttributeValueAssertion equalityMatch = null;
    public SubstringFilter substrings = null;
    public AttributeValueAssertion greaterOrEqual = null;
    public AttributeValueAssertion lessOrEqual = null;
    public byte[] present = null;
    public AttributeValueAssertion approxMatch = null;
    public MatchingRuleAssertion extensibleMatch = null;

    public Filter() {
    }

    public Filter(Filter arg) {
        this.choiceId = arg.choiceId;
        switch (this.choiceId) {
            case 0: {
                this.and = new FilterSetOf(arg.and);
                break;
            }
            case 1: {
                this.or = new FilterSetOf1(arg.or);
                break;
            }
            case 2: {
                this.not = new Filter(arg.not);
                break;
            }
            case 3: {
                this.equalityMatch = new AttributeValueAssertion(arg.equalityMatch);
                break;
            }
            case 4: {
                this.substrings = new SubstringFilter(arg.substrings);
                break;
            }
            case 5: {
                this.greaterOrEqual = new AttributeValueAssertion(arg.greaterOrEqual);
                break;
            }
            case 6: {
                this.lessOrEqual = new AttributeValueAssertion(arg.lessOrEqual);
                break;
            }
            case 7: {
                this.present = new byte[arg.present.length];
                System.arraycopy(arg.present, 0, this.present, 0, arg.present.length);
                break;
            }
            case 8: {
                this.approxMatch = new AttributeValueAssertion(arg.approxMatch);
                break;
            }
            case 9: {
                this.extensibleMatch = new MatchingRuleAssertion(arg.extensibleMatch);
            }
        }
    }

    public Filter(String mal) {
        if (mal.startsWith("(")) {
            if (!mal.endsWith(")")) {
                return;
            }
            mal = mal.substring(1, mal.length() - 1);
        }
        if (mal.startsWith("&")) {
            mal = mal.substring(1);
            this.and = new FilterSetOf(mal);
            this.choiceId = 0;
            return;
        }
        if (mal.startsWith("|")) {
            mal = mal.substring(1);
            this.or = new FilterSetOf1(mal);
            this.choiceId = 1;
            return;
        }
        if (mal.startsWith("!")) {
            mal = mal.substring(1);
            this.not = new Filter(mal);
            this.choiceId = 2;
            return;
        }
        String value = "";
        Vector v2 = MVDUtil.splitString(mal, "<=");
        if (v2.size() == 2) {
            this.lessOrEqual = new AttributeValueAssertion(v2);
            this.choiceId = 6;
            return;
        }
        v2 = MVDUtil.splitString(mal, ">=");
        if (v2.size() == 2) {
            this.greaterOrEqual = new AttributeValueAssertion(v2);
            this.choiceId = 5;
            return;
        }
        v2 = MVDUtil.splitString(mal, "~=");
        if (v2.size() == 2) {
            this.approxMatch = new AttributeValueAssertion(v2);
            this.choiceId = 8;
            return;
        }
        v2 = MVDUtil.splitString(mal, "=");
        if (v2.size() > 2) {
            int eqIndex = mal.indexOf(61);
            String before = mal.substring(0, eqIndex);
            String after = mal.substring(eqIndex + 1);
            v2 = new Vector();
            v2.add(before);
            v2.add(after);
        }
        if (v2.size() == 2) {
            value = (String)v2.elementAt(1);
            if (value.indexOf("*") < 0) {
                this.equalityMatch = new AttributeValueAssertion(v2);
                this.choiceId = 3;
                return;
            }
            if (value.equals("*")) {
                String what = (String)v2.elementAt(0);
                byte[] whatbyte = MVDUtil.ToUTF8(what);
                this.present = new byte[whatbyte.length];
                System.arraycopy(whatbyte, 0, this.present, 0, whatbyte.length);
                this.choiceId = 7;
                return;
            }
            this.choiceId = 4;
            this.substrings = new SubstringFilter(mal);
            return;
        }
        if (v2.size() > 2) {
            // empty if block
        }
    }

    public void decode(ASN1Decoder dec) throws ASN1Exception {
        int tag = dec.decodeChoice(this.tag_list);
        if (tag == ASN1Decoder.makeTag(2, 0)) {
            this.and = new FilterSetOf();
            dec.nextIsImplicit(ASN1Decoder.makeTag(2, 0));
            this.and.decode(dec);
            this.choiceId = 0;
        }
        if (tag == ASN1Decoder.makeTag(2, 1)) {
            this.or = new FilterSetOf1();
            dec.nextIsImplicit(ASN1Decoder.makeTag(2, 1));
            this.or.decode(dec);
            this.choiceId = 1;
        }
        if (tag == ASN1Decoder.makeTag(2, 2)) {
            this.not = new Filter();
            int ex_id_not = dec.decodeExplicit(ASN1Decoder.makeTag(2, 2));
            this.not.decode(dec);
            dec.endOf(ex_id_not);
            this.choiceId = 2;
        }
        if (tag == ASN1Decoder.makeTag(2, 3)) {
            this.equalityMatch = new AttributeValueAssertion();
            dec.nextIsImplicit(ASN1Decoder.makeTag(2, 3));
            this.equalityMatch.decode(dec);
            this.choiceId = 3;
        }
        if (tag == ASN1Decoder.makeTag(2, 4)) {
            this.substrings = new SubstringFilter();
            dec.nextIsImplicit(ASN1Decoder.makeTag(2, 4));
            this.substrings.decode(dec);
            this.choiceId = 4;
        }
        if (tag == ASN1Decoder.makeTag(2, 5)) {
            this.greaterOrEqual = new AttributeValueAssertion();
            dec.nextIsImplicit(ASN1Decoder.makeTag(2, 5));
            this.greaterOrEqual.decode(dec);
            this.choiceId = 5;
        }
        if (tag == ASN1Decoder.makeTag(2, 6)) {
            this.lessOrEqual = new AttributeValueAssertion();
            dec.nextIsImplicit(ASN1Decoder.makeTag(2, 6));
            this.lessOrEqual.decode(dec);
            this.choiceId = 6;
        }
        if (tag == ASN1Decoder.makeTag(2, 7)) {
            dec.nextIsImplicit(ASN1Decoder.makeTag(2, 7));
            this.present = dec.decodeOctetString();
            this.choiceId = 7;
        }
        if (tag == ASN1Decoder.makeTag(2, 8)) {
            this.approxMatch = new AttributeValueAssertion();
            dec.nextIsImplicit(ASN1Decoder.makeTag(2, 8));
            this.approxMatch.decode(dec);
            this.choiceId = 8;
        }
        if (tag == ASN1Decoder.makeTag(2, 9)) {
            this.extensibleMatch = new MatchingRuleAssertion();
            dec.nextIsImplicit(ASN1Decoder.makeTag(2, 9));
            this.extensibleMatch.decode(dec);
            this.choiceId = 9;
        }
    }

    public void encode(ASN1Encoder enc) throws ASN1Exception {
        enc.encodeChoice(this.choiceId, this.tag_list);
        switch (this.choiceId) {
            case 0: {
                enc.nextIsImplicit(ASN1Encoder.makeTag(2, 0));
                this.and.encode(enc);
                break;
            }
            case 1: {
                enc.nextIsImplicit(ASN1Encoder.makeTag(2, 1));
                this.or.encode(enc);
                break;
            }
            case 2: {
                int ex_id_not = enc.encodeExplicit(ASN1Encoder.makeTag(2, 2));
                this.not.encode(enc);
                enc.endOf(ex_id_not);
                break;
            }
            case 3: {
                enc.nextIsImplicit(ASN1Encoder.makeTag(2, 3));
                this.equalityMatch.encode(enc);
                break;
            }
            case 4: {
                enc.nextIsImplicit(ASN1Encoder.makeTag(2, 4));
                this.substrings.encode(enc);
                break;
            }
            case 5: {
                enc.nextIsImplicit(ASN1Encoder.makeTag(2, 5));
                this.greaterOrEqual.encode(enc);
                break;
            }
            case 6: {
                enc.nextIsImplicit(ASN1Encoder.makeTag(2, 6));
                this.lessOrEqual.encode(enc);
                break;
            }
            case 7: {
                enc.nextIsImplicit(ASN1Encoder.makeTag(2, 7));
                enc.encodeOctetString(this.present);
                break;
            }
            case 8: {
                enc.nextIsImplicit(ASN1Encoder.makeTag(2, 8));
                this.approxMatch.encode(enc);
                break;
            }
            case 9: {
                enc.nextIsImplicit(ASN1Encoder.makeTag(2, 9));
                this.extensibleMatch.encode(enc);
            }
        }
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public void print(PrintStream os, int indent) {
        os.println("{ -- CHOICE --");
        switch (this.choiceId) {
            case 0: {
                for (int ii = 0; ii < indent + 2; ++ii) {
                    os.print(' ');
                }
                os.print("and = ");
                this.and.print(os, indent + 2);
                break;
            }
            case 1: {
                for (int ii = 0; ii < indent + 2; ++ii) {
                    os.print(' ');
                }
                os.print("or = ");
                this.or.print(os, indent + 2);
                break;
            }
            case 2: {
                for (int ii = 0; ii < indent + 2; ++ii) {
                    os.print(' ');
                }
                os.print("not = ");
                this.not.print(os, indent + 2);
                break;
            }
            case 3: {
                for (int ii = 0; ii < indent + 2; ++ii) {
                    os.print(' ');
                }
                os.print("equalityMatch = ");
                this.equalityMatch.print(os, indent + 2);
                break;
            }
            case 4: {
                for (int ii = 0; ii < indent + 2; ++ii) {
                    os.print(' ');
                }
                os.print("substrings = ");
                this.substrings.print(os, indent + 2);
                break;
            }
            case 5: {
                for (int ii = 0; ii < indent + 2; ++ii) {
                    os.print(' ');
                }
                os.print("greaterOrEqual = ");
                this.greaterOrEqual.print(os, indent + 2);
                break;
            }
            case 6: {
                for (int ii = 0; ii < indent + 2; ++ii) {
                    os.print(' ');
                }
                os.print("lessOrEqual = ");
                this.lessOrEqual.print(os, indent + 2);
                break;
            }
            case 7: {
                for (int ii = 0; ii < indent + 2; ++ii) {
                    os.print(' ');
                }
                os.print("present = ");
                try {
                    new HexOutputStream(os).write(this.present);
                }
                catch (IOException ex) {
                    os.print("( unprintable OCTET STRING value )");
                }
                break;
            }
            case 8: {
                for (int ii = 0; ii < indent + 2; ++ii) {
                    os.print(' ');
                }
                os.print("approxMatch = ");
                this.approxMatch.print(os, indent + 2);
                break;
            }
            case 9: {
                for (int ii = 0; ii < indent + 2; ++ii) {
                    os.print(' ');
                }
                os.print("extensibleMatch = ");
                this.extensibleMatch.print(os, indent + 2);
            }
        }
        for (int ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print("}");
    }

    public static String removeChar(String s, char c) {
        String r = "";
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == c) continue;
            r = r + s.charAt(i);
        }
        return r;
    }

    public String toURL() {
        switch (this.choiceId) {
            case 0: {
                return this.and.toURL();
            }
            case 1: {
                return this.or.toURL();
            }
            case 2: {
                String sss = this.not.toURL();
                if (sss.equalsIgnoreCase("(INVALIDFILTER)")) {
                    return "(INVALIDFILTER)";
                }
                if (sss.equalsIgnoreCase("(IGNOREDFILTER)")) {
                    return "(IGNOREDFILTER)";
                }
                return "(!" + sss + ")";
            }
            case 3: {
                String sss = this.equalityMatch.toURL();
                sss = Filter.removeChar(sss, '#');
                return sss;
            }
            case 4: {
                return this.substrings.toURL();
            }
            case 5: {
                String sss = this.greaterOrEqual.toURL();
                sss = sss.replace('#', '>');
                return sss;
            }
            case 6: {
                String sss = this.lessOrEqual.toURL();
                sss = sss.replace('#', '<');
                return sss;
            }
            case 7: {
                String sss = MVDUtil.FromUTF8(this.present);
                if (sss.equalsIgnoreCase("INVALIDATTR")) {
                    return "(INVALIDFILTER)";
                }
                if (sss.equalsIgnoreCase("IGNOREDATTR")) {
                    return "(IGNOREDFILTER)";
                }
                return "(" + sss + "=*)";
            }
            case 8: {
                String sss = this.approxMatch.toURL();
                sss = sss.replace('#', '~');
                return sss;
            }
            case 9: {
                return this.extensibleMatch.toURL();
            }
        }
        return "";
    }

    public String toDBFilter(MVDDataSource ds) {
        switch (this.choiceId) {
            case 0: {
                return this.and.toDBFilter(ds);
            }
            case 1: {
                return this.or.toDBFilter(ds);
            }
            case 2: {
                String sss = this.not.toDBFilter(ds);
                if (sss.equalsIgnoreCase("(INVALIDFILTER)")) {
                    return "(INVALIDFILTER)";
                }
                if (sss.equalsIgnoreCase("(IGNOREDFILTER)")) {
                    return "(IGNOREDFILTER)";
                }
                return "NOT " + this.not.toDBFilter(ds);
            }
            case 3: {
                String sss = this.equalityMatch.toDBFilter(ds);
                sss = Filter.removeChar(sss, '#');
                return sss;
            }
            case 4: {
                return this.substrings.toDBFilter(ds);
            }
            case 5: {
                String sss = this.greaterOrEqual.toDBFilter(ds);
                sss = sss.replace('#', '>');
                return sss;
            }
            case 6: {
                String sss = this.lessOrEqual.toDBFilter(ds);
                sss = sss.replace('#', '<');
                return sss;
            }
            case 7: {
                String strType;
                String dbQuote;
                String tmpVal;
                HashMap sensh;
                String sss = MVDUtil.FromUTF8(this.present).toLowerCase();
                if (sss.equalsIgnoreCase("INVALIDATTR")) {
                    return "(INVALIDFILTER)";
                }
                if (sss.equalsIgnoreCase("IGNOREDATTR")) {
                    return "(IGNOREDFILTER)";
                }
                String strPresent = MVDUtil.FromUTF8(this.present);
                if (ds.IsCaseSensitive() && (sensh = ds.CaseSensitivityMap()) != null && (tmpVal = (String)sensh.get(strPresent)) != null) {
                    strPresent = tmpVal;
                }
                if ((dbQuote = (String)ds.ParamFields().get("DS_DO_DBQUOTE")) != null && dbQuote.equalsIgnoreCase("true")) {
                    String lc = (String)ds.ParamFields().get("DS_LEFT_QUOTECHAR");
                    String rc = (String)ds.ParamFields().get("DS_RIGHT_QUOTECHAR");
                    if (lc != null && rc != null) {
                        strPresent = lc + strPresent + rc;
                    }
                }
                if ((strType = (String)MVDProxy.MVDGlobals().get("GLOBAL_LDAP_PRESENT_FTYPE")) == null) {
                    return strPresent + " like '*'";
                }
                int ptype = Integer.parseInt(strType);
                if (ptype == 0) {
                    return strPresent + " like '*'";
                }
                if (ptype == 1) {
                    return strPresent + " is not null";
                }
                if (ptype == 2) {
                    return strPresent + " <> ''";
                }
                return strPresent + " like '*'";
            }
            case 8: {
                String sss = this.approxMatch.toDBFilter(ds);
                sss = sss.replace('#', '~');
                return sss;
            }
            case 9: {
                return "NOT IMPLENETED";
            }
        }
        return "";
    }

    public String toIdSFilter() {
        String res = "";
        switch (this.choiceId) {
            case 0: {
                res = this.and.toIdSFilter();
                break;
            }
            case 1: {
                res = this.or.toIdSFilter();
                break;
            }
            case 2: {
                res = this.not.toIdSFilter();
                if (res.equalsIgnoreCase("(INVALIDFILTER)")) {
                    return "(INVALIDFILTER)";
                }
                if (res.equalsIgnoreCase("(IGNOREDFILTER)")) {
                    return "(IGNOREDFILTER)";
                }
                res = "NOT (" + this.not.toIdSFilter() + ")";
                break;
            }
            case 3: {
                res = this.equalityMatch.toIdSFilter();
                res = Filter.removeChar(res, '#');
                break;
            }
            case 4: {
                res = this.substrings.toIdSFilter();
                break;
            }
            case 5: {
                res = this.greaterOrEqual.toIdSFilter();
                res = res.replace('#', '>');
                break;
            }
            case 6: {
                res = this.lessOrEqual.toIdSFilter();
                res = res.replace('#', '<');
                break;
            }
            case 7: {
                res = MVDUtil.FromUTF8(this.present);
                if (res.equalsIgnoreCase("INVALIDATTR")) {
                    return "(INVALIDFILTER)";
                }
                if (res.equalsIgnoreCase("IGNOREDATTR")) {
                    return "(IGNOREDFILTER)";
                }
                res = "mskey in (select mskey from mxiv_entries where attrname='" + res + "' and is_id=1 " + "and searchvalue like '*')";
                break;
            }
            case 8: {
                return "NOT IMPLENETED";
            }
            case 9: {
                return "NOT IMPLENETED";
            }
        }
        return res;
    }

    public void fixFilter(HashMap hmAvailable, HashMap hmIgnored, HashMap hmInMapping) {
        switch (this.choiceId) {
            case 0: {
                this.and.fixFilter(hmAvailable, hmIgnored, hmInMapping);
                break;
            }
            case 1: {
                this.or.fixFilter(hmAvailable, hmIgnored, hmInMapping);
                break;
            }
            case 2: {
                this.not.fixFilter(hmAvailable, hmIgnored, hmInMapping);
                break;
            }
            case 3: {
                this.equalityMatch.fixFilter(hmAvailable, hmIgnored, hmInMapping);
                break;
            }
            case 4: {
                this.substrings.fixFilter(hmAvailable, hmIgnored, hmInMapping);
                break;
            }
            case 5: {
                this.greaterOrEqual.fixFilter(hmAvailable, hmIgnored, hmInMapping);
                break;
            }
            case 6: {
                this.lessOrEqual.fixFilter(hmAvailable, hmIgnored, hmInMapping);
                break;
            }
            case 7: {
                String sss = MVDUtil.FromUTF8(this.present).toLowerCase();
                if (hmInMapping != null && hmInMapping.containsKey(sss)) {
                    this.present = MVDUtil.ToUTF8((String)hmInMapping.get(sss));
                    sss = MVDUtil.FromUTF8(this.present);
                }
                if (hmIgnored != null && hmIgnored.containsKey(sss)) {
                    this.present = MVDUtil.ToUTF8("IGNOREDATTR");
                    return;
                }
                if (hmAvailable == null) break;
                Object sVal = hmAvailable.get(sss);
                if (sVal == null) {
                    this.present = MVDUtil.ToUTF8("INVALIDATTR");
                    break;
                }
                if (sVal instanceof String) {
                    this.present = MVDUtil.ToUTF8((String)sVal);
                    break;
                }
                if (!(sVal instanceof Vector)) break;
                this.present = MVDUtil.ToUTF8(sss);
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                this.extensibleMatch.fixFilter(hmAvailable, hmIgnored, hmInMapping);
            }
        }
    }

    public boolean testFilter(HashMap hmTestOn, boolean defaultNonExisting) {
        switch (this.choiceId) {
            case 0: {
                return this.and.testFilter(hmTestOn, defaultNonExisting);
            }
            case 1: {
                return this.or.testFilter(hmTestOn, defaultNonExisting);
            }
            case 2: {
                return !this.not.testFilter(hmTestOn, !defaultNonExisting);
            }
            case 3: {
                return this.equalityMatch.testFilter(hmTestOn, defaultNonExisting);
            }
            case 4: {
                return this.substrings.testFilter(hmTestOn, defaultNonExisting);
            }
            case 5: {
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                String sss = MVDUtil.FromUTF8(this.present).toLowerCase();
                if (hmTestOn == null || !hmTestOn.containsKey(sss)) {
                    return defaultNonExisting;
                }
                return true;
            }
            case 8: {
                break;
            }
        }
        return false;
    }
}

