/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.ldapv3;

import com.sap.idm.vds.asn1.ASN1Decoder;
import com.sap.idm.vds.asn1.ASN1Encoder;
import com.sap.idm.vds.asn1.ASN1Exception;
import com.sap.idm.vds.asn1.util.HexOutputStream;
import com.sap.idm.vds.ldapv3.LDAPv3;
import java.io.IOException;
import java.io.PrintStream;

public class ExtendedRequest
implements LDAPv3 {
    public byte[] requestName;
    public byte[] requestValue = null;

    public ExtendedRequest() {
    }

    public ExtendedRequest(ExtendedRequest arg) {
        this.requestName = new byte[arg.requestName.length];
        System.arraycopy(arg.requestName, 0, this.requestName, 0, arg.requestName.length);
        this.requestValue = new byte[arg.requestValue.length];
        System.arraycopy(arg.requestValue, 0, this.requestValue, 0, arg.requestValue.length);
    }

    public void decode(ASN1Decoder dec) throws ASN1Exception {
        dec.nextIsImplicit(ASN1Decoder.makeTag(1, 23));
        int seq_nr = dec.decodeSequence();
        dec.nextIsImplicit(ASN1Decoder.makeTag(2, 0));
        this.requestName = dec.decodeOctetString();
        if (!dec.nextIsOptional(ASN1Decoder.makeTag(2, 1))) {
            dec.nextIsImplicit(ASN1Decoder.makeTag(2, 1));
            this.requestValue = dec.decodeOctetString();
        }
        dec.endOf(seq_nr);
    }

    public void encode(ASN1Encoder enc) throws ASN1Exception {
        enc.nextIsImplicit(ASN1Encoder.makeTag(1, 23));
        int seq_nr = enc.encodeSequence();
        enc.nextIsImplicit(ASN1Encoder.makeTag(2, 0));
        enc.encodeOctetString(this.requestName);
        if (this.requestValue != null) {
            enc.nextIsImplicit(ASN1Encoder.makeTag(2, 1));
            enc.encodeOctetString(this.requestValue);
        }
        enc.endOf(seq_nr);
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public void print(PrintStream os, int indent) {
        os.println("{ -- SEQUENCE --");
        for (int ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("requestName = ");
        try {
            new HexOutputStream(os).write(this.requestName);
        }
        catch (IOException ex) {
            os.print("( unprintable OCTET STRING value )");
        }
        os.println(',');
        if (this.requestValue != null) {
            for (int ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("requestValue = ");
            try {
                new HexOutputStream(os).write(this.requestValue);
            }
            catch (IOException ex) {
                os.print("( unprintable OCTET STRING value )");
            }
        }
        os.println();
        for (int ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }
}

