/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.ldapv3;

import com.sap.idm.vds.asn1.ASN1Decoder;
import com.sap.idm.vds.asn1.ASN1Encoder;
import com.sap.idm.vds.asn1.ASN1Exception;
import com.sap.idm.vds.asn1.util.HexOutputStream;
import com.sap.idm.vds.ldapv3.LDAPv3;
import java.io.IOException;
import java.io.PrintStream;

public class DelRequest
implements LDAPv3 {
    public byte[] value;

    public DelRequest() {
    }

    public DelRequest(byte[] arg) {
        this.value = arg;
    }

    public DelRequest(DelRequest arg) {
        this.value = new byte[arg.value.length];
        System.arraycopy(arg.value, 0, this.value, 0, arg.value.length);
    }

    public void decode(ASN1Decoder dec) throws ASN1Exception {
        dec.nextIsImplicit(ASN1Decoder.makeTag(1, 10));
        this.value = dec.decodeOctetString();
    }

    public void encode(ASN1Encoder enc) throws ASN1Exception {
        enc.nextIsImplicit(ASN1Encoder.makeTag(1, 10));
        enc.encodeOctetString(this.value);
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public void print(PrintStream os, int indent) {
        try {
            new HexOutputStream(os).write(this.value);
        }
        catch (IOException ex) {
            os.print("( unprintable OCTET STRING value )");
        }
    }
}

