/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.ldapv3;

import com.sap.idm.vds.asn1.ASN1Decoder;
import com.sap.idm.vds.asn1.ASN1Encoder;
import com.sap.idm.vds.asn1.ASN1Exception;
import com.sap.idm.vds.asn1.util.HexOutputStream;
import com.sap.idm.vds.ldapv3.LDAPResultEnum;
import com.sap.idm.vds.ldapv3.LDAPv3;
import com.sap.idm.vds.ldapv3.Referral;
import java.io.IOException;
import java.io.PrintStream;

public class BindResponse
implements LDAPv3 {
    public LDAPResultEnum resultCode = new LDAPResultEnum();
    public byte[] matchedDN;
    public byte[] errorMessage;
    public Referral referral = null;
    public byte[] serverSaslCreds = null;

    public BindResponse() {
    }

    public BindResponse(BindResponse arg) {
        this.resultCode = new LDAPResultEnum(arg.resultCode);
        this.matchedDN = new byte[arg.matchedDN.length];
        System.arraycopy(arg.matchedDN, 0, this.matchedDN, 0, arg.matchedDN.length);
        this.errorMessage = new byte[arg.errorMessage.length];
        System.arraycopy(arg.errorMessage, 0, this.errorMessage, 0, arg.errorMessage.length);
        this.referral = new Referral(arg.referral);
        this.serverSaslCreds = new byte[arg.serverSaslCreds.length];
        System.arraycopy(arg.serverSaslCreds, 0, this.serverSaslCreds, 0, arg.serverSaslCreds.length);
    }

    public void decode(ASN1Decoder dec) throws ASN1Exception {
        dec.nextIsImplicit(ASN1Decoder.makeTag(1, 1));
        int seq_nr = dec.decodeSequence();
        this.resultCode.decode(dec);
        this.matchedDN = dec.decodeOctetString();
        this.errorMessage = dec.decodeOctetString();
        if (!dec.nextIsOptional(ASN1Decoder.makeTag(2, 3))) {
            this.referral = new Referral();
            dec.nextIsImplicit(ASN1Decoder.makeTag(2, 3));
            this.referral.decode(dec);
        }
        if (!dec.nextIsOptional(ASN1Decoder.makeTag(2, 7))) {
            dec.nextIsImplicit(ASN1Decoder.makeTag(2, 7));
            this.serverSaslCreds = dec.decodeOctetString();
        }
        dec.endOf(seq_nr);
    }

    public void encode(ASN1Encoder enc) throws ASN1Exception {
        enc.nextIsImplicit(ASN1Encoder.makeTag(1, 1));
        int seq_nr = enc.encodeSequence();
        this.resultCode.encode(enc);
        enc.encodeOctetString(this.matchedDN);
        enc.encodeOctetString(this.errorMessage);
        if (this.referral != null) {
            enc.nextIsImplicit(ASN1Encoder.makeTag(2, 3));
            this.referral.encode(enc);
        }
        if (this.serverSaslCreds != null) {
            enc.nextIsImplicit(ASN1Encoder.makeTag(2, 7));
            enc.encodeOctetString(this.serverSaslCreds);
        }
        enc.endOf(seq_nr);
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("resultCode = ");
        this.resultCode.print(os, indent + 2);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("matchedDN = ");
        try {
            new HexOutputStream(os).write(this.matchedDN);
        }
        catch (IOException ex) {
            os.print("( unprintable OCTET STRING value )");
        }
        os.println(',');
        for (int ii2 = 0; ii2 < indent + 2; ++ii2) {
            os.print(' ');
        }
        os.print("errorMessage = ");
        try {
            new HexOutputStream(os).write(this.errorMessage);
        }
        catch (IOException ex) {
            os.print("( unprintable OCTET STRING value )");
        }
        os.println(',');
        if (this.referral != null) {
            for (int ii3 = 0; ii3 < indent + 2; ++ii3) {
                os.print(' ');
            }
            os.print("referral = ");
            this.referral.print(os, indent + 2);
        }
        os.println(',');
        if (this.serverSaslCreds != null) {
            for (int ii4 = 0; ii4 < indent + 2; ++ii4) {
                os.print(' ');
            }
            os.print("serverSaslCreds = ");
            try {
                new HexOutputStream(os).write(this.serverSaslCreds);
            }
            catch (IOException ex) {
                os.print("( unprintable OCTET STRING value )");
            }
        }
        os.println();
        for (int ii5 = 0; ii5 < indent; ++ii5) {
            os.print(' ');
        }
        os.print('}');
    }
}

