/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.ldapv3;

import com.sap.idm.vds.MVDUtil;
import com.sap.idm.vds.MVDUtilities;
import com.sap.idm.vds.asn1.ASN1Decoder;
import com.sap.idm.vds.asn1.ASN1Encoder;
import com.sap.idm.vds.asn1.ASN1Exception;
import com.sap.idm.vds.asn1.util.HexOutputStream;
import com.sap.idm.vds.config.MVDDataSource;
import com.sap.idm.vds.ldapv3.LDAPv3;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Vector;

public class AttributeValueAssertion
implements LDAPv3 {
    public byte[] attributeDesc;
    public byte[] assertionValue;

    public AttributeValueAssertion() {
    }

    public AttributeValueAssertion(AttributeValueAssertion arg) {
        this.attributeDesc = new byte[arg.attributeDesc.length];
        System.arraycopy(arg.attributeDesc, 0, this.attributeDesc, 0, arg.attributeDesc.length);
        this.assertionValue = new byte[arg.assertionValue.length];
        System.arraycopy(arg.assertionValue, 0, this.assertionValue, 0, arg.assertionValue.length);
    }

    public AttributeValueAssertion(Vector v2) {
        if (v2.size() == 2) {
            byte[] value = MVDUtil.ToUTF8((String)v2.elementAt(1));
            this.assertionValue = new byte[value.length];
            System.arraycopy(value, 0, this.assertionValue, 0, value.length);
            value = MVDUtil.ToUTF8((String)v2.elementAt(0));
            this.attributeDesc = new byte[value.length];
            System.arraycopy(value, 0, this.attributeDesc, 0, value.length);
        }
    }

    public void decode(ASN1Decoder dec) throws ASN1Exception {
        int seq_nr = dec.decodeSequence();
        this.attributeDesc = dec.decodeOctetString();
        this.assertionValue = dec.decodeOctetString();
        dec.endOf(seq_nr);
    }

    public void encode(ASN1Encoder enc) throws ASN1Exception {
        int seq_nr = enc.encodeSequence();
        enc.encodeOctetString(this.attributeDesc);
        enc.encodeOctetString(this.assertionValue);
        enc.endOf(seq_nr);
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public void print(PrintStream os, int indent) {
        os.println("{ -- SEQUENCE --");
        for (int ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("attributeDesc = ");
        try {
            new HexOutputStream(os).write(this.attributeDesc);
        }
        catch (IOException ex) {
            os.print("( unprintable OCTET STRING value )");
        }
        os.println(',');
        for (int ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("assertionValue = ");
        try {
            new HexOutputStream(os).write(this.assertionValue);
        }
        catch (IOException ex) {
            os.print("( unprintable OCTET STRING value )");
        }
        os.println();
        for (int ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public String toURL() {
        String resString = "";
        String tempString = MVDUtil.FromUTF8(this.attributeDesc);
        if (tempString.equalsIgnoreCase("INVALIDATTR")) {
            resString = "(INVALIDFILTER)";
        } else if (tempString.equalsIgnoreCase("IGNOREDATTR")) {
            resString = "(IGNOREDFILTER)";
        } else {
            String valStr = "";
            valStr = MVDUtilities.IsBinaryAttribute(tempString) ? MVDUtil.byteToEscapedHex(this.assertionValue) : MVDUtil.FromUTF8(this.assertionValue);
            resString = "(" + tempString + "#=" + valStr + ")";
        }
        return resString;
    }

    public String toDBFilter(MVDDataSource ds) {
        String resString = "";
        String tempString = MVDUtil.FromUTF8(this.attributeDesc).toLowerCase();
        if (tempString.equalsIgnoreCase("INVALIDATTR")) {
            resString = "(INVALIDFILTER)";
        } else if (tempString.equalsIgnoreCase("IGNOREDATTR")) {
            resString = "(IGNOREDFILTER)";
        } else {
            String dbQuote;
            HashMap sensh;
            String tmpVal;
            String theValue = MVDUtil.FromUTF8(this.assertionValue);
            theValue = MVDUtil.replace(theValue, "'", "''");
            String quoteChar = "";
            HashMap typesh = ds.ConfiguredAvailableFieldsTypes();
            if (typesh == null) {
                quoteChar = "'";
            } else {
                tmpVal = (String)typesh.get(tempString);
                if (tmpVal != null) {
                    quoteChar = tmpVal.equals("0") ? "'" : "";
                }
            }
            if (ds.IsCaseSensitive() && (sensh = ds.CaseSensitivityMap()) != null && (tmpVal = (String)sensh.get(tempString)) != null) {
                tempString = tmpVal;
            }
            if ((dbQuote = (String)ds.ParamFields().get("DS_DO_DBQUOTE")) != null && dbQuote.equalsIgnoreCase("true")) {
                String lc = (String)ds.ParamFields().get("DS_LEFT_QUOTECHAR");
                String rc = (String)ds.ParamFields().get("DS_RIGHT_QUOTECHAR");
                if (lc != null && rc != null) {
                    tempString = lc + tempString + rc;
                }
            }
            resString = tempString + "#=" + quoteChar + theValue + quoteChar;
        }
        return resString;
    }

    public String toIdSFilter() {
        String resString = "";
        String tempString = MVDUtil.FromUTF8(this.attributeDesc).toLowerCase();
        if (tempString.equalsIgnoreCase("INVALIDATTR")) {
            return "(INVALIDFILTER)";
        }
        if (tempString.equalsIgnoreCase("IGNOREDATTR")) {
            return "(IGNOREDFILTER)";
        }
        resString = MVDUtil.FromUTF8(this.assertionValue);
        return "mskey in (select mskey from mxiv_entries where attrname='" + tempString + "' and " + "is_id=1 and " + "searchvalue#='" + resString + "')";
    }

    public void fixFilter(HashMap hmAvailable, HashMap hmIgnored, HashMap hmInMapping) {
        String sss = MVDUtil.FromUTF8(this.attributeDesc).toLowerCase();
        if (hmInMapping != null && hmInMapping.containsKey(sss)) {
            this.attributeDesc = MVDUtil.ToUTF8((String)hmInMapping.get(sss));
            sss = MVDUtil.FromUTF8(this.attributeDesc);
        }
        if (hmIgnored != null && hmIgnored.containsKey(sss)) {
            String ss = "IGNOREDATTR";
            this.attributeDesc = MVDUtil.ToUTF8(ss);
            return;
        }
        if (hmAvailable != null) {
            Object sVal = hmAvailable.get(sss);
            if (sVal == null) {
                String ss = "INVALIDATTR";
                this.attributeDesc = MVDUtil.ToUTF8(ss);
            } else if (sVal instanceof String) {
                this.attributeDesc = MVDUtil.ToUTF8((String)sVal);
            } else if (sVal instanceof Vector) {
                this.attributeDesc = MVDUtil.ToUTF8(sss);
            }
            return;
        }
    }

    public boolean testFilter(HashMap hmTestOn, boolean defaultNonExisting) {
        String sss = MVDUtil.FromUTF8(this.attributeDesc).toLowerCase();
        if (hmTestOn == null || !hmTestOn.containsKey(sss)) {
            return defaultNonExisting;
        }
        String sVal = ((String)hmTestOn.get(sss)).toLowerCase();
        String assVal = MVDUtil.FromUTF8(this.assertionValue);
        return sVal.indexOf("|" + assVal.toLowerCase() + "|") > -1;
    }
}

