/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.ldapv3;

import com.sap.idm.vds.asn1.ASN1Decoder;
import com.sap.idm.vds.asn1.ASN1Encoder;
import com.sap.idm.vds.asn1.ASN1Exception;
import com.sap.idm.vds.asn1.util.HexOutputStream;
import com.sap.idm.vds.ldapv3.AttributeList;
import com.sap.idm.vds.ldapv3.LDAPv3;
import java.io.IOException;
import java.io.PrintStream;

public class AddRequest
implements LDAPv3 {
    public byte[] entry;
    public AttributeList attributes = new AttributeList();

    public AddRequest() {
    }

    public AddRequest(AddRequest arg) {
        this.entry = new byte[arg.entry.length];
        System.arraycopy(arg.entry, 0, this.entry, 0, arg.entry.length);
        this.attributes = new AttributeList(arg.attributes);
    }

    public void decode(ASN1Decoder dec) throws ASN1Exception {
        dec.nextIsImplicit(ASN1Decoder.makeTag(1, 8));
        int seq_nr = dec.decodeSequence();
        this.entry = dec.decodeOctetString();
        this.attributes.decode(dec);
        dec.endOf(seq_nr);
    }

    public void encode(ASN1Encoder enc) throws ASN1Exception {
        enc.nextIsImplicit(ASN1Encoder.makeTag(1, 8));
        int seq_nr = enc.encodeSequence();
        enc.encodeOctetString(this.entry);
        this.attributes.encode(enc);
        enc.endOf(seq_nr);
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (int ii2 = 0; ii2 < indent + 2; ++ii2) {
            os.print(' ');
        }
        os.print("entry = ");
        try {
            new HexOutputStream(os).write(this.entry);
        }
        catch (IOException ex) {
            os.print("( unprintable OCTET STRING value )");
        }
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("attributes = ");
        this.attributes.print(os, indent + 2);
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }
}

