/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.implicitattr;

import com.sap.idm.vds.Engine;
import com.sap.idm.vds.MVDException;
import com.sap.idm.vds.MVDInternalContext;
import com.sap.idm.vds.MVDLogger;
import com.sap.idm.vds.MVDOrderedHashMap;
import com.sap.idm.vds.MVDSearchResultEntry;
import com.sap.idm.vds.MVDSearchResults;
import com.sap.idm.vds.MVDUtil;
import com.sap.idm.vds.MVDUtilities;
import com.sap.idm.vds.config.MVDAttrSourceMethod;
import com.sap.idm.vds.config.MVDAttributeSource;
import com.sap.idm.vds.config.MVDDynamicAddGroup;
import com.sap.idm.vds.config.MVDJoinGroup;
import com.sap.idm.vds.implicitattr.Attribute;
import com.sap.idm.vds.implicitattr.AttributeSource;
import com.sap.idm.vds.message.MxAdd;
import com.sap.idm.vds.message.MxAttrSet;
import com.sap.idm.vds.message.MxEntry;
import com.sap.idm.vds.message.MxRequest;
import com.sap.idm.vds.message.MxResponse;
import com.sap.idm.vds.message.MxSearch;
import com.sap.idm.vds.util.LDAPUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class ImplicitAttributes {
    public static void doDynamicAddGroupFixing(MVDDynamicAddGroup aGroup, MxAdd aRequest, Engine aEngine) throws MVDException {
        MVDOrderedHashMap sources = aGroup.getDynamicAddEntries();
        MVDOrderedHashMap attributesHashMap = aGroup.getDynamicAddAttributes();
        ImplicitAttributes.doFetchImplicitAttributes(sources, attributesHashMap, aRequest.getDn(), aRequest.getAttrSetAndValues(), aEngine);
    }

    public static MVDSearchResults doJoinGroupFixing(MVDJoinGroup aGroup, MVDSearchResults aResult, Engine aEngine, Vector aReqAttributes, String aReqFilter) throws MVDException {
        MVDSearchResults res = new MVDSearchResults();
        boolean szLimitExceeded = false;
        boolean allWell = true;
        Iterator iter = aResult.iterator();
        while (iter.hasNext()) {
            if (aGroup.isUseJoinLimit() && res.size() >= aGroup.getJoinLimit()) {
                szLimitExceeded = true;
                break;
            }
            try {
                MVDOrderedHashMap sources = aGroup.getJoinEntries();
                MVDOrderedHashMap attributesHashMap = aGroup.getJoinAttributes();
                MVDSearchResultEntry entry = (MVDSearchResultEntry)iter.next();
                ImplicitAttributes.doSearchSetFixingOneEntry(sources, attributesHashMap, entry, aEngine, aReqFilter, aReqAttributes);
                res.add(entry);
            }
            catch (Exception e) {}
        }
        if (allWell) {
            if (szLimitExceeded) {
                res.setOK(4, "Size limit exceeded");
            } else {
                res.setOK();
            }
        } else {
            res.setError(2, "");
        }
        return res;
    }

    private static void doSearchSetFixingOneEntry(MVDOrderedHashMap aSources, MVDOrderedHashMap aAttributesHashMap, MVDSearchResultEntry aEntry, Engine aEngine, String aReqFilter, Vector aReqAttributes) throws MVDException {
        ImplicitAttributes.doJoin(aSources, aAttributesHashMap, aEntry.getDn(), aEntry.getAttrSetAndValues(), aEngine, aReqFilter, aReqAttributes);
    }

    private static void removeIgnoredAttributes(MVDOrderedHashMap aAttrSources, MVDOrderedHashMap aAttributesHashMap, MxAttrSet aAttrSet) {
        Vector attributesInOriginalRequest = aAttrSet.getAttributes();
        Iterator iter = attributesInOriginalRequest.iterator();
        while (iter.hasNext()) {
            String attrname = (String)iter.next();
            Attribute attr = (Attribute)aAttributesHashMap.get(attrname);
            if (attr == null || attr.getOperation() != 1) continue;
            Vector sourcesToRemoveFrom = attr.ignore();
            Iterator iterator = sourcesToRemoveFrom.iterator();
            while (iterator.hasNext()) {
                String sourceName = (String)iterator.next();
                AttributeSource src = (AttributeSource)aAttrSources.get(sourceName);
                if (src == null) continue;
                src.removeAttribute(attrname);
            }
        }
    }

    private static void doFetchImplicitAttributes(MVDOrderedHashMap sources, MVDOrderedHashMap attributesHashMap, String aDn, MxAttrSet aAttrSet, Engine aEngine) throws MVDException {
        MxEntry wholeentry = new MxEntry();
        ImplicitAttributes.removeIgnoredAttributes(sources, attributesHashMap, aAttrSet);
        Iterator iter = attributesHashMap.keySet().iterator();
        while (iter.hasNext()) {
            String attrname = (String)iter.next();
            Attribute searchForAttr = (Attribute)attributesHashMap.get(attrname);
            String srcName = searchForAttr.getNextSource();
            while (srcName != null) {
                AttributeSource src = (AttributeSource)sources.get(srcName);
                Vector attributes = src.getAttributes();
                if (src.isDefault()) {
                    ImplicitAttributes.assignDefaultValuesToAttribute(attributesHashMap, attributes, src.getDefaultValue(), wholeentry, aDn, aAttrSet);
                    ImplicitAttributes.removeRemainingAttributeFromSources(attributes, sources, attributesHashMap, srcName);
                } else {
                    MxEntry oneEntry = ImplicitAttributes.doFetchFromTheSource(src, aDn, aAttrSet, wholeentry, aEngine, "");
                    Vector entries = oneEntry.getAttributes();
                    Iterator iterat = entries.iterator();
                    while (iterat.hasNext()) {
                        String attrName = (String)iterat.next();
                        Attribute attr = (Attribute)attributesHashMap.get(attrName.toLowerCase());
                        if (attr == null && attributes.contains("*")) {
                            attr = (Attribute)attributesHashMap.get("*");
                        }
                        if (attr.isSingleValue()) {
                            Vector v = wholeentry.getAttrValues(attrName);
                            if (v == null || v.size() == 0) {
                                MVDLogger.Log(attrName + " is a single value attribute, do not append. No previous values", 2);
                            } else {
                                MVDLogger.Log(attrName + " is a single value attribute, do not append. Replacing previous values: " + v, 2);
                            }
                            wholeentry.setAttrValue(attrName, false, oneEntry.getAttrValues(attrName));
                            continue;
                        }
                        MVDLogger.Log(attr.getName() + " is not a single value attribute, append", 2);
                        wholeentry.setAttrValue(attrName, true, oneEntry.getAttrValues(attrName));
                    }
                    ImplicitAttributes.removeRemainingAttributeFromSources(entries, sources, attributesHashMap, srcName);
                }
                srcName = searchForAttr.getNextSource();
            }
            if (!searchForAttr.isMandatory()) continue;
            Vector fetched = wholeentry.getAttrValues(attrname);
            Vector org = aAttrSet.getAttrValues(attrname);
            if (fetched != null && fetched.size() > 0 || org != null && org.size() > 0) continue;
            MVDLogger.Log("Mandatory attribute " + attrname + " not found", 3);
            throw new MVDException(1, "Not all mandatory attributes present");
        }
        MVDLogger.Log("Joining fetched attribute(s) with original request", 2);
        ImplicitAttributes.joinWithAttrSet(wholeentry.getAttrAndValues(), aAttrSet, attributesHashMap);
    }

    private static void doJoin(MVDOrderedHashMap aSources, MVDOrderedHashMap aAttributesHashMap, String aDn, MxAttrSet aAttrSet, Engine aEngine, String aReqFilter, Vector aReqAttributes) throws MVDException {
        MxEntry wholeentry = new MxEntry();
        ImplicitAttributes.removeIgnoredAttributes(aSources, aAttributesHashMap, aAttrSet);
        Iterator iter = aAttributesHashMap.keySet().iterator();
        while (iter.hasNext()) {
            String attrname = (String)iter.next();
            Attribute searchForAttr = (Attribute)aAttributesHashMap.get(attrname);
            if (aReqAttributes.size() > 0 && !aReqAttributes.contains("*")) {
                MVDAttributeSource mas;
                String aKey;
                AttributeSource as;
                boolean bIsRequredByAttrSourceConnection = false;
                Iterator sourceiter = aSources.keySet().iterator();
                while (sourceiter.hasNext() && ((as = (AttributeSource)aSources.get(aKey = (String)sourceiter.next())).isDefault() || !(bIsRequredByAttrSourceConnection = (mas = as.getAttributeSource()).requiresAttr(attrname)))) {
                }
                if (!aReqAttributes.contains(attrname) && !bIsRequredByAttrSourceConnection) {
                    MVDLogger.Log("The attribute " + attrname + " is not requested at all ..", 2);
                    continue;
                }
            }
            String srcName = searchForAttr.getNextSource();
            while (srcName != null) {
                AttributeSource src = (AttributeSource)aSources.get(srcName);
                Vector attributes = src.getAttributes();
                if (src.isDefault()) {
                    ImplicitAttributes.assignDefaultValuesToAttribute(aAttributesHashMap, attributes, src.getDefaultValue(), wholeentry, aDn, aAttrSet);
                    ImplicitAttributes.removeRemainingAttributeFromSources(attributes, aSources, aAttributesHashMap, srcName);
                } else {
                    MxEntry oneEntry = ImplicitAttributes.doFetchFromTheSource(src, aDn, aAttrSet, wholeentry, aEngine, aReqFilter);
                    Vector entries = oneEntry.getAttributes();
                    Iterator iterat = entries.iterator();
                    while (iterat.hasNext()) {
                        String attrName = (String)iterat.next();
                        Attribute attr = (Attribute)aAttributesHashMap.get(attrName.toLowerCase());
                        if (attr == null && attributes.contains("*")) {
                            attr = (Attribute)aAttributesHashMap.get("*");
                        }
                        if (attr.isSingleValue()) {
                            Vector v = wholeentry.getAttrValues(attrName);
                            if (v == null || v.size() == 0) {
                                MVDLogger.Log(attrName + " is a single value attribute, do not append. No previous values", 2);
                            } else {
                                MVDLogger.Log(attrName + " is a single value attribute, do not append. Replacing previous values: " + v, 2);
                            }
                            wholeentry.setAttrValue(attrName, false, oneEntry.getAttrValues(attrName));
                            continue;
                        }
                        MVDLogger.Log(attr.getName() + " is not a single value attribute, append", 2);
                        wholeentry.setAttrValue(attrName, true, oneEntry.getAttrValues(attrName));
                    }
                    ImplicitAttributes.removeRemainingAttributeFromSources(entries, aSources, aAttributesHashMap, srcName);
                }
                srcName = searchForAttr.getNextSource();
            }
            if (!searchForAttr.isMandatory()) continue;
            Vector fetched = wholeentry.getAttrValues(attrname);
            Vector org = aAttrSet.getAttrValues(attrname);
            if (fetched != null && fetched.size() > 0 || org != null && org.size() > 0) continue;
            MVDLogger.Log("Mandatory attribute " + attrname + " not found", 3);
            throw new MVDException(1, "Not all mandatory attributes present");
        }
        MVDLogger.Log("Joining fetched attribute(s) with original request", 2);
        ImplicitAttributes.joinWithAttrSet(wholeentry.getAttrAndValues(), aAttrSet, aAttributesHashMap);
    }

    private static void removeRemainingAttributeFromSources(Vector aAttributes, MVDOrderedHashMap aSources, HashMap aAttributesHashMap, String aSrcName) {
        MVDLogger.Log("Search performed on datasource: " + aSrcName + " performing removal of singlevalue attributes from \"lower ranked\" sources", 2);
        Iterator iter = aAttributes.iterator();
        while (iter.hasNext()) {
            String attrName = (String)iter.next();
            Attribute attr = (Attribute)aAttributesHashMap.get(attrName);
            if (attr == null && aAttributesHashMap.containsKey("*")) {
                attr = (Attribute)aAttributesHashMap.get("*");
            }
            if (attr.isSingleValue()) {
                Vector sourcesToRemove = attr.removeSourcesAfter(aSrcName);
                MVDLogger.Log(attrName + " is a singlevalue attribute, we must remove the lower ranked sources: " + sourcesToRemove, 2);
                Iterator iterator = sourcesToRemove.iterator();
                while (iterator.hasNext()) {
                    String oneSourceToRemoveFrom = (String)iterator.next();
                    AttributeSource src = (AttributeSource)aSources.get(oneSourceToRemoveFrom);
                    src.removeAttribute(attrName);
                }
                continue;
            }
            MVDLogger.Log(attrName + " is not a single value attribute, try also remaining sources.", 2);
        }
        AttributeSource src = (AttributeSource)aSources.get(aSrcName);
        Vector v = src.getAttributes();
        Iterator iter2 = v.iterator();
        while (iter2.hasNext()) {
            String attrToRemoveFrom = (String)iter2.next();
            Attribute attr = (Attribute)aAttributesHashMap.get(attrToRemoveFrom);
            attr.removeSource(aSrcName);
        }
        src.removeAllAttributes();
    }

    private static void assignDefaultValuesToAttribute(HashMap aAttributesHashMap, Vector aAttrbutes, String aDefValue, MxEntry aWholeentry, String aOrgDN, MxAttrSet aOrgSet) throws MVDException {
        Vector v;
        boolean defaultvaluesucceded = true;
        int dnindex = aDefValue.toLowerCase().indexOf("$dn.");
        HashMap<String, Vector> dnComponents = new HashMap<String, Vector>();
        if (dnindex >= 0) {
            Vector dnparts = MVDUtil.splitString(aOrgDN, ',');
            for (int i = 0; i < dnparts.size(); ++i) {
                String part = (String)dnparts.elementAt(i);
                int eqIndx = part.indexOf(61);
                String key = part.substring(0, eqIndx);
                String value = part.substring(eqIndx + 1);
                Object prevVal = dnComponents.get(key);
                if (prevVal == null) {
                    v = new Vector();
                    v.add(value);
                    dnComponents.put(key, v);
                    continue;
                }
                v = (Vector)prevVal;
                v.add(value);
            }
        }
        while (dnindex >= 0) {
            Vector v2;
            String prefix = aDefValue.substring(0, dnindex);
            int valuestart = aDefValue.indexOf(60, dnindex);
            int valueend = aDefValue.indexOf(62, dnindex);
            if (valuestart < 0 || valueend < 0) {
                defaultvaluesucceded = false;
                break;
            }
            String valuekey = aDefValue.substring(valuestart + 1, valueend);
            String suffix = aDefValue.substring(valueend + 1);
            int numvalue = valuekey.indexOf(58);
            if (numvalue > 0) {
                String keynum = valuekey.substring(numvalue + 1);
                valuekey = valuekey.substring(0, numvalue);
                try {
                    numvalue = Integer.parseInt(keynum);
                }
                catch (Exception e) {
                    numvalue = 0;
                }
            } else {
                numvalue = 0;
            }
            if ((v2 = (Vector)dnComponents.get(valuekey.toLowerCase())) == null) {
                defaultvaluesucceded = false;
                break;
            }
            if (numvalue >= v2.size()) {
                numvalue = v2.size() - 1;
            }
            String value = (String)v2.elementAt(numvalue);
            aDefValue = prefix + value + suffix;
            dnindex = aDefValue.toLowerCase().indexOf("$dn.");
        }
        int reqindex = aDefValue.toLowerCase().indexOf("$req.");
        while (reqindex >= 0) {
            String prefix = aDefValue.substring(0, reqindex);
            int valuestart = aDefValue.indexOf(60, reqindex);
            int valueend = aDefValue.indexOf(62, reqindex);
            if (valuestart < 0 || valueend < 0) {
                defaultvaluesucceded = false;
                break;
            }
            String valuekey = aDefValue.substring(valuestart + 1, valueend);
            String suffix = aDefValue.substring(valueend + 1);
            int numvalue = valuekey.indexOf(58);
            if (numvalue > 0) {
                String keynum = valuekey.substring(numvalue + 1);
                valuekey = valuekey.substring(0, numvalue);
                try {
                    numvalue = Integer.parseInt(keynum);
                }
                catch (Exception e) {
                    numvalue = 0;
                }
            } else {
                numvalue = 0;
            }
            if ((v = aOrgSet.getAttrValues(valuekey.toLowerCase())) == null || v.size() == 0) {
                defaultvaluesucceded = false;
                break;
            }
            if (numvalue >= v.size()) {
                numvalue = v.size() - 1;
            }
            String value = (String)v.elementAt(numvalue);
            aDefValue = prefix + value + suffix;
            reqindex = aDefValue.toLowerCase().indexOf("$req.");
        }
        if (defaultvaluesucceded) {
            Iterator iter = aAttrbutes.iterator();
            while (iter.hasNext()) {
                String attrName = (String)iter.next();
                Attribute attr = (Attribute)aAttributesHashMap.get(attrName);
                MVDLogger.Log("Assigning default value " + aDefValue + " to " + attrName, 2);
                if (attr.isSingleValue()) {
                    Vector v3 = aWholeentry.getAttrValues(attrName);
                    if (v3 == null || v3.size() == 0) {
                        MVDLogger.Log(attrName + " is a single value attribute, overwrite. No previous values", 2);
                    } else {
                        MVDLogger.Log(attrName + " is a single value attribute, overwrite. Replacing previous values: " + v3, 2);
                    }
                    aWholeentry.setAttrValue(attrName, !attr.isSingleValue(), aDefValue);
                    continue;
                }
                MVDLogger.Log(attr.getName() + " is not a single value attribute, append", 2);
                aWholeentry.setAttrValue(attrName, !attr.isSingleValue(), aDefValue);
            }
        } else {
            Iterator iter = aAttrbutes.iterator();
            while (iter.hasNext()) {
                String attrName = (String)iter.next();
                Attribute attr = (Attribute)aAttributesHashMap.get(attrName);
                if (!attr.isMandatory()) continue;
                MVDLogger.Log("Unable to create mandatory attribute " + attrName, 3);
                throw new MVDException(1, "Not all mandatory attributes present");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static MxEntry doFetchFromTheSource(AttributeSource aSrc, String aOrgDN, MxAttrSet aOrgSet, MxEntry aPreviousResults, Engine aEngine, String aReqFilter) {
        MxResponse res;
        block17: {
            MVDAttributeSource attrsrc = aSrc.getAttributeSource();
            String startingpoint = attrsrc.getStartingPoint();
            String templateDN = attrsrc.getTemplateDN();
            HashMap fromDN = new HashMap();
            MVDUtilities.matchBracketTemplatePortion(aOrgDN, templateDN, fromDN);
            Vector attrMethods = attrsrc.getAttributeMethods();
            HashMap<String, String> attrSourceVariables = new HashMap<String, String>();
            if (attrMethods != null && attrMethods.size() > 0) {
                Iterator iter = attrMethods.iterator();
                while (iter.hasNext()) {
                    MVDAttrSourceMethod method = (MVDAttrSourceMethod)iter.next();
                    String orgVarName = method.getOrgVariable();
                    String orgVarVal = (String)attrSourceVariables.get(orgVarName);
                    if (orgVarVal == null && (orgVarVal = aOrgSet.getFirstAttrValue(orgVarName)) == null && (orgVarVal = (String)fromDN.get("<" + orgVarName + ">")) == null) {
                        orgVarVal = aPreviousResults.getFirstAttrValue(orgVarName);
                    }
                    if (orgVarVal == null) continue;
                    String newVal = method.performEvaluation(orgVarVal, aEngine);
                    attrSourceVariables.put(method.getResultingVariable(), newVal);
                }
            }
            StringBuffer tmpFilter = new StringBuffer(attrsrc.getFilter());
            int index = -1;
            while ((index = tmpFilter.indexOf("%filter")) >= 0) {
                if (tmpFilter.charAt(index + 7) == '%') {
                    tmpFilter.replace(index, index + 8, aReqFilter);
                    continue;
                }
                tmpFilter.delete(index, index + 6);
            }
            if ((startingpoint = ImplicitAttributes.replaceBrackets(startingpoint, attrSourceVariables, aOrgSet, fromDN, aPreviousResults)).indexOf(60) >= 0 || startingpoint.indexOf(62) >= 0) {
                MVDLogger.Log("Could not expand startingpoint, attribute source: " + attrsrc.getName(), 6);
                return new MxEntry();
            }
            String filter = tmpFilter.toString();
            filter = MVDUtil.replace(filter, "<=", "&lt;=");
            filter = MVDUtil.replace(filter, ">=", "&gt;=");
            if ((filter = ImplicitAttributes.replaceBrackets(filter, attrSourceVariables, aOrgSet, fromDN, aPreviousResults)).indexOf(60) >= 0 || filter.indexOf(62) >= 0) {
                MVDLogger.Log("Could not expand filter, attribute source: " + attrsrc.getName(), 6);
                return new MxEntry();
            }
            filter = MVDUtil.replace(filter, "&lt;=", "<=");
            filter = MVDUtil.replace(filter, "&gt;=", ">=");
            MVDLogger.Log("Filter to be used in join: " + filter, 2);
            Vector attributes = aSrc.getAttributes();
            if (attributes.size() <= 0) {
                MVDLogger.Log("Nothing to search for", 2);
                return new MxEntry();
            }
            res = null;
            if (attrsrc.isUseInternalServer()) {
                MVDInternalContext internalServerConnection = null;
                try {
                    try {
                        internalServerConnection = new MVDInternalContext();
                        internalServerConnection.bind(aEngine.getEngineData(), attrsrc.getInternalTree());
                        MxSearch search = new MxSearch();
                        search.setRequestedAttributes(attributes);
                        search.setOperationScope(attrsrc.getOperationType());
                        search.setRequestedFilter(filter);
                        search.setStartingPoint(startingpoint);
                        search.setSizeLimit(1);
                        res = internalServerConnection.answerRequest(search);
                        internalServerConnection.close();
                        internalServerConnection = null;
                    }
                    catch (Exception e) {
                        if (internalServerConnection != null) {
                            internalServerConnection.close();
                            internalServerConnection = null;
                        }
                        res = new MxResponse();
                        res.setError(82, e.getMessage());
                        Object var20_22 = null;
                        if (internalServerConnection != null) {
                            internalServerConnection.close();
                            internalServerConnection = null;
                        }
                        break block17;
                    }
                    Object var20_21 = null;
                    if (internalServerConnection == null) break block17;
                }
                catch (Throwable throwable) {
                    Object var20_23 = null;
                    if (internalServerConnection == null) throw throwable;
                    internalServerConnection.close();
                    internalServerConnection = null;
                    throw throwable;
                }
                internalServerConnection.close();
                internalServerConnection = null;
            } else {
                MVDLogger.Log("Ready to search for following attributes: " + attributes + " from source: " + aSrc.getAttributeSource().getName(), 2);
                res = LDAPUtil.search(attrsrc.getServeraddress(), "" + attrsrc.getServerport(), attrsrc.getUsername(), attrsrc.getPassword(), startingpoint, attrsrc.getOperationType(), attributes, filter, 1, 30, null, null, true, aEngine.getEngineGs());
            }
        }
        if (res.isOK() && res.size() == 1) {
            MxEntry thisentry = (MxEntry)res.elementAt(0);
            MVDLogger.Log("Search returned attributes: " + thisentry.getAttributes(), 2);
            return thisentry;
        }
        MVDLogger.Log("Search returned nothing", 2);
        return new MxEntry();
    }

    private static String replaceBrackets(String aTextToReplace, HashMap aAttributeSourceVars, MxAttrSet aOrgSet, HashMap aFromDN, MxEntry aPreviousResults) {
        StringBuffer strbuf = new StringBuffer(aTextToReplace.length() * 2);
        strbuf.append(aTextToReplace);
        int bracketstart = strbuf.indexOf("<");
        while (bracketstart >= 0) {
            int bracketend = strbuf.indexOf(">", bracketstart);
            if (bracketend < 0) {
                MVDLogger.Log("Unbalanced brackets in template: " + aTextToReplace, 2);
                return aTextToReplace;
            }
            String attrname = strbuf.substring(bracketstart + 1, bracketend);
            String value = (String)aAttributeSourceVars.get(attrname.toLowerCase());
            if (value == null) {
                Vector v = aOrgSet.getAttrValues(attrname.toLowerCase());
                if (v != null && v.size() > 0 && v.firstElement() instanceof String) {
                    value = (String)v.firstElement();
                } else {
                    value = (String)aFromDN.get('<' + attrname.toLowerCase() + '>');
                    if (value == null && (v = aPreviousResults.getAttrValues(attrname.toLowerCase())) != null && v.size() > 0 && v.firstElement() instanceof String) {
                        value = (String)v.firstElement();
                    }
                }
            }
            if (value == null || value.length() <= 0) {
                return strbuf.toString();
            }
            strbuf.replace(bracketstart, bracketend + 1, value);
            bracketstart = strbuf.indexOf("<");
        }
        return strbuf.toString();
    }

    private static void joinWithAttrSet(HashMap aAttrs, MxAttrSet aEntry, HashMap aAttributesFetched) {
        Iterator iter = aAttrs.entrySet().iterator();
        while (iter.hasNext()) {
            int oper;
            Map.Entry element = iter.next();
            String attrName = (String)element.getKey();
            Attribute tmp = (Attribute)aAttributesFetched.get(attrName);
            if (tmp == null && aAttributesFetched.containsKey("*")) {
                tmp = (Attribute)aAttributesFetched.get("*");
            }
            if ((oper = tmp.getOperation()) == 2) {
                aEntry.setAttrValue(attrName, true, (Vector)element.getValue());
                continue;
            }
            if (oper == 3) {
                aEntry.setAttrValue(attrName, false, (Vector)element.getValue());
                continue;
            }
            if (oper != 1) continue;
            aEntry.setAttrValue(attrName, true, (Vector)element.getValue());
        }
    }

    private void addAttributesToRequest(MxRequest aRequest, MVDSearchResults aSearchRes, HashMap aMappings) {
        MVDSearchResultEntry entry = (MVDSearchResultEntry)aSearchRes.elementAt(0);
        Iterator iter = entry.getAttrAndValues().entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry attr = iter.next();
            String attrDSName = (String)attr.getKey();
            String attrValue = (String)((Vector)attr.getValue()).firstElement();
            String attrName = (String)aMappings.get(attrDSName);
        }
    }
}

