/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.implicitattr;

import com.sap.idm.vds.config.MVDAttributeSource;
import com.sap.idm.vds.config.MVDAttributeSourceList;
import com.sap.idm.vds.config.MVDConfigException;
import java.util.Vector;

public class ImplicitAttributeEntry {
    private boolean mEnabled;
    private boolean mMandatory;
    private String mAttrName;
    private int mAttributeSource;

    public ImplicitAttributeEntry(Vector entry) throws MVDConfigException {
        this.setEntries(entry);
    }

    public void setEntries(Vector entry) throws MVDConfigException {
        this.setEnabled((String)entry.elementAt(0));
        this.setAttrName((String)entry.elementAt(1));
        this.setMandatory((String)entry.elementAt(2));
        this.setAttributeSource((String)entry.elementAt(3));
    }

    public boolean isEnabled() {
        return this.mEnabled;
    }

    public void setEnabled(String aEnabled) {
        this.mEnabled = Boolean.valueOf(aEnabled);
    }

    public boolean isMandatory() {
        return this.mMandatory;
    }

    public void setMandatory(String aMandatory) {
        this.mMandatory = Boolean.valueOf(aMandatory);
    }

    private void setAttrName(String string) {
        this.mAttrName = string;
    }

    public String getAttrName() {
        return this.mAttrName;
    }

    public int getAttributeSourceId() {
        return this.mAttributeSource;
    }

    public MVDAttributeSource getAttributeSource() {
        MVDAttributeSource source = MVDAttributeSourceList.getAttributeSourceByID(this.mAttributeSource);
        if (source == null) {
            throw new RuntimeException("Attribute source " + this.mAttributeSource + " not found");
        }
        return source;
    }

    public void setAttributeSource(String aAttributeSource) throws MVDConfigException {
        try {
            this.mAttributeSource = Integer.parseInt(aAttributeSource);
        }
        catch (NumberFormatException e) {
            throw new MVDConfigException("Error setting attribute source.");
        }
    }
}

